/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlTableFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlUtil;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlWindowTableFunction
extends SqlFunction
implements SqlTableFunction {
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = SqlWindowTableFunction::inferRowType;

    public SqlWindowTableFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlReturnTypeInference getRowTypeInference() {
        return ARG0_TABLE_FUNCTION_WINDOWING;
    }

    protected boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    protected void validateColumnNames(SqlValidator validator, List<String> fieldNames, List<SqlNode> columnNames) {
        SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
        for (SqlNode columnName : columnNames) {
            String name = ((SqlIdentifier)columnName).getSimple();
            if (matcher.indexOf(fieldNames, name) >= 0) continue;
            throw SqlUtil.newContextException(columnName.getParserPosition(), Static.RESOURCE.unknownIdentifier(name));
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }

    private static RelDataType inferRowType(SqlOperatorBinding opBinding) {
        RelDataType inputRowType = opBinding.getOperandType(0);
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType timestampType = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        return ((RelDataTypeFactory.FieldInfoBuilder)typeFactory.builder().kind(inputRowType.getStructKind()).addAll(inputRowType.getFieldList())).add("window_start", timestampType).add("window_end", timestampType).build();
    }
}

