/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionalOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.type.ArraySqlType;
import org.apache.hive.druid.org.apache.calcite.sql.type.MapSqlType;
import org.apache.hive.druid.org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class SqlUnnestOperator
extends SqlFunctionalOperator {
    public final boolean withOrdinality;
    public static final String ORDINALITY_COLUMN_NAME = "ORDINALITY";
    public static final String MAP_KEY_COLUMN_NAME = "KEY";
    public static final String MAP_VALUE_COLUMN_NAME = "VALUE";

    public SqlUnnestOperator(boolean withOrdinality) {
        super("UNNEST", SqlKind.UNNEST, 200, true, null, null, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.SCALAR_OR_RECORD_COLLECTION_OR_MAP));
        this.withOrdinality = withOrdinality;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (Integer operand : Util.range(opBinding.getOperandCount())) {
            RelDataType type = opBinding.getOperandType(operand);
            if (type.getSqlTypeName() == SqlTypeName.ANY) {
                return ((RelDataTypeFactory.Builder)builder).add("$unnest", SqlTypeName.ANY).nullable(true).build();
            }
            if (type.isStruct()) {
                type = type.getFieldList().get(0).getType();
            }
            assert (type instanceof ArraySqlType || type instanceof MultisetSqlType || type instanceof MapSqlType);
            if (type instanceof MapSqlType) {
                ((RelDataTypeFactory.Builder)builder).add(MAP_KEY_COLUMN_NAME, type.getKeyType());
                ((RelDataTypeFactory.Builder)builder).add(MAP_VALUE_COLUMN_NAME, type.getValueType());
                continue;
            }
            if (!this.allowAliasUnnestItems(opBinding) && type.getComponentType().isStruct()) {
                ((RelDataTypeFactory.Builder)builder).addAll(type.getComponentType().getFieldList());
                continue;
            }
            ((RelDataTypeFactory.Builder)builder).add(SqlUtil.deriveAliasFromOrdinal(operand), type.getComponentType());
        }
        if (this.withOrdinality) {
            ((RelDataTypeFactory.Builder)builder).add(ORDINALITY_COLUMN_NAME, SqlTypeName.INTEGER);
        }
        return builder.build();
    }

    private boolean allowAliasUnnestItems(SqlOperatorBinding operatorBinding) {
        return operatorBinding instanceof SqlCallBinding && ((SqlCallBinding)operatorBinding).getValidator().config().sqlConformance().allowAliasUnnestItems();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.operandCount() == 1 && call.getOperandList().get(0).getKind() == SqlKind.SELECT) {
            writer.keyword(this.getName());
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        } else {
            super.unparse(writer, call, leftPrec, rightPrec);
        }
        if (this.withOrdinality) {
            writer.keyword("WITH ORDINALITY");
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

