/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;

public class SqlSessionTableFunction
extends SqlWindowTableFunction {
    public SqlSessionTableFunction() {
        super(SqlKind.SESSION.name());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(4);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        SqlNode operand1 = callBinding.operand(1);
        if (operand1.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand1).getOperandList());
        SqlNode operand2 = callBinding.operand(2);
        if (operand2.getKind() != SqlKind.DESCRIPTOR) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand2).getOperandList());
        RelDataType type3 = validator.getValidatedNodeType(callBinding.operand(3));
        if (!SqlTypeUtil.isInterval(type3)) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col), DESCRIPTOR(col), datetime interval)";
    }
}

