/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.schema.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.runtime.CalciteException;
import org.apache.hive.druid.org.apache.calcite.schema.ImplementableFunction;
import org.apache.hive.druid.org.apache.calcite.schema.QueryableTable;
import org.apache.hive.druid.org.apache.calcite.schema.ScannableTable;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.TableFunction;
import org.apache.hive.druid.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class TableFunctionImpl
extends ReflectiveFunctionBase
implements TableFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private TableFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static TableFunction create(Class<?> clazz) {
        return TableFunctionImpl.create(clazz, "eval");
    }

    public static TableFunction create(Class<?> clazz, String methodName) {
        Method method = TableFunctionImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return TableFunctionImpl.create(method);
    }

    public static TableFunction create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !TableFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!QueryableTable.class.isAssignableFrom(returnType) && !ScannableTable.class.isAssignableFrom(returnType)) {
            return null;
        }
        CallImplementor implementor = TableFunctionImpl.createImplementor(method);
        return new TableFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return this.apply(arguments).getRowType(typeFactory);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        Table table = this.apply(arguments);
        if (table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)table;
            return queryableTable.getElementType();
        }
        if (table instanceof ScannableTable) {
            return Object[].class;
        }
        throw new AssertionError((Object)("Invalid table class: " + table + " " + table.getClass()));
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                Expression expr = super.implement(translator, call, translatedOperands);
                Class<?> returnType = this.method.getReturnType();
                if (QueryableTable.class.isAssignableFrom(returnType)) {
                    MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_(expr, QueryableTable.class), BuiltInMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant(call.getOperator().getName(), String.class));
                    expr = Expressions.call((Expression)queryable, BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, new Expression[0]);
                } else {
                    expr = Expressions.call(expr, BuiltInMethod.SCANNABLE_TABLE_SCAN.method, DataContext.ROOT);
                }
                return expr;
            }
        }, NullPolicy.NONE, false);
    }

    private Table apply(List<Object> arguments) {
        try {
            Object o = null;
            if (!Modifier.isStatic(this.method.getModifiers())) {
                Constructor<?> constructor = this.method.getDeclaringClass().getConstructor(new Class[0]);
                o = constructor.newInstance(new Object[0]);
            }
            Object table = this.method.invoke(o, arguments.toArray());
            return (Table)table;
        }
        catch (IllegalArgumentException e) {
            throw (CalciteException)Static.RESOURCE.illegalArgumentForTableFunctionCall(this.method.toString(), Arrays.toString(this.method.getParameterTypes()), arguments.toString()).ex(e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

