/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rex;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.rex.RexFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.rex.RexWindowBound;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class RexWindow {
    public final ImmutableList<RexNode> partitionKeys;
    public final ImmutableList<RexFieldCollation> orderKeys;
    private final RexWindowBound lowerBound;
    private final RexWindowBound upperBound;
    private final boolean isRows;
    private final String digest;
    public final int nodeCount;

    RexWindow(List<RexNode> partitionKeys, List<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean isRows) {
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.orderKeys = ImmutableList.copyOf(orderKeys);
        this.lowerBound = Objects.requireNonNull(lowerBound);
        this.upperBound = Objects.requireNonNull(upperBound);
        this.isRows = isRows;
        this.nodeCount = this.computeCodeCount();
        this.digest = this.computeDigest();
        Preconditions.checkArgument(!lowerBound.isUnbounded() || !lowerBound.isPreceding() || !upperBound.isUnbounded() || !upperBound.isFollowing() || !isRows, "use RANGE for unbounded, not ROWS");
    }

    public String toString() {
        return this.digest;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof RexWindow) {
            RexWindow window = (RexWindow)that;
            return this.digest.equals(window.digest);
        }
        return false;
    }

    private String computeDigest() {
        return this.appendDigest_(new StringBuilder(), true).toString();
    }

    StringBuilder appendDigest(StringBuilder sb, boolean allowFraming) {
        if (allowFraming) {
            return sb.append(this.digest);
        }
        return this.appendDigest_(sb, allowFraming);
    }

    private StringBuilder appendDigest_(StringBuilder sb, boolean allowFraming) {
        int i;
        int initialLength = sb.length();
        if (this.partitionKeys.size() > 0) {
            sb.append("PARTITION BY ");
            for (i = 0; i < this.partitionKeys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.partitionKeys.get(i));
            }
        }
        if (this.orderKeys.size() > 0) {
            sb.append(sb.length() > initialLength ? " ORDER BY " : "ORDER BY ");
            for (i = 0; i < this.orderKeys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.orderKeys.get(i));
            }
        }
        if (!(!allowFraming || this.orderKeys.isEmpty() || this.lowerBound.isUnbounded() && this.lowerBound.isPreceding() && this.upperBound.isCurrentRow() && !this.isRows)) {
            if (this.upperBound.isCurrentRow()) {
                sb.append(sb.length() > initialLength ? (this.isRows ? " ROWS " : " RANGE ") : (this.isRows ? "ROWS " : "RANGE ")).append(this.lowerBound);
            } else {
                sb.append(sb.length() > initialLength ? (this.isRows ? " ROWS BETWEEN " : " RANGE BETWEEN ") : (this.isRows ? "ROWS BETWEEN " : "RANGE BETWEEN ")).append(this.lowerBound).append(" AND ").append(this.upperBound);
            }
        }
        return sb;
    }

    public RexWindowBound getLowerBound() {
        return this.lowerBound;
    }

    public RexWindowBound getUpperBound() {
        return this.upperBound;
    }

    public boolean isRows() {
        return this.isRows;
    }

    private int computeCodeCount() {
        return RexUtil.nodeCount(this.partitionKeys) + RexUtil.nodeCount(Pair.left(this.orderKeys)) + (this.lowerBound == null ? 0 : this.lowerBound.nodeCount()) + (this.upperBound == null ? 0 : this.upperBound.nodeCount());
    }
}

