/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules.materialize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.druid.com.google.common.collect.BiMap;
import org.apache.hive.druid.com.google.common.collect.HashBiMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Multimap;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptMaterialization;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepProgram;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexExecutor;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexSimplify;
import org.apache.hive.druid.org.apache.calcite.rex.RexTableInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBeans;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mapping;

public abstract class MaterializedViewRule<C extends Config>
extends RelRule<C> {
    MaterializedViewRule(C config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        return !call.getPlanner().getMaterializations().isEmpty();
    }

    protected void perform(RelOptRuleCall call, Project topProject, RelNode node) {
        RexBuilder rexBuilder = node.getCluster().getRexBuilder();
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPlanner planner = call.getPlanner();
        RexExecutor executor = Util.first(planner.getExecutor(), RexUtil.EXECUTOR);
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        RexSimplify simplify = new RexSimplify(rexBuilder, predicates, executor);
        List<RelOptMaterialization> materializations = planner.getMaterializations();
        if (!materializations.isEmpty()) {
            if (!this.isValidPlan(topProject, node, mq)) {
                return;
            }
            Set<RexTableInputRef.RelTableRef> queryTableRefs = mq.getTableReferences(node);
            if (queryTableRefs == null) {
                return;
            }
            RelOptPredicateList queryPredicateList = mq.getAllPredicates(node);
            if (queryPredicateList == null) {
                return;
            }
            RexNode pred = simplify.simplifyUnknownAsFalse(RexUtil.composeConjunction(rexBuilder, queryPredicateList.pulledUpPredicates));
            Pair<RexNode, RexNode> queryPreds = this.splitPredicates(rexBuilder, pred);
            EquivalenceClasses qEC = new EquivalenceClasses();
            for (RexNode conj : RelOptUtil.conjunctions((RexNode)queryPreds.left)) {
                assert (conj.isA(SqlKind.EQUALS));
                RexCall equiCond = (RexCall)conj;
                qEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
            }
            for (RelOptMaterialization materialization : materializations) {
                MatchModality matchModality;
                RelOptPredicateList viewPredicateList;
                RelNode viewNode;
                Project topViewProject;
                RelNode view = materialization.tableRel;
                if (materialization.queryRel instanceof Project) {
                    topViewProject = (Project)materialization.queryRel;
                    viewNode = topViewProject.getInput();
                } else {
                    topViewProject = null;
                    viewNode = materialization.queryRel;
                }
                Set<RexTableInputRef.RelTableRef> viewTableRefs = mq.getTableReferences(viewNode);
                if (viewTableRefs == null) continue;
                boolean applicable = false;
                for (RexTableInputRef.RelTableRef tableRef : viewTableRefs) {
                    if (!queryTableRefs.contains(tableRef)) continue;
                    applicable = true;
                    break;
                }
                if (!applicable || !this.isValidPlan(topViewProject, viewNode, mq) || (viewPredicateList = mq.getAllPredicates(viewNode)) == null) continue;
                RexNode viewPred = simplify.simplifyUnknownAsFalse(RexUtil.composeConjunction(rexBuilder, viewPredicateList.pulledUpPredicates));
                Pair<RexNode, RexNode> viewPreds = this.splitPredicates(rexBuilder, viewPred);
                ArrayListMultimap<RexTableInputRef, RexTableInputRef> compensationEquiColumns = ArrayListMultimap.create();
                if (!queryTableRefs.equals(viewTableRefs)) {
                    if (viewTableRefs.containsAll(queryTableRefs)) {
                        matchModality = MatchModality.QUERY_PARTIAL;
                        EquivalenceClasses vEC = new EquivalenceClasses();
                        for (RexNode conj : RelOptUtil.conjunctions((RexNode)viewPreds.left)) {
                            assert (conj.isA(SqlKind.EQUALS));
                            RexCall equiCond = (RexCall)conj;
                            vEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                        }
                        if (!this.compensatePartial(viewTableRefs, vEC, queryTableRefs, compensationEquiColumns)) {
                            continue;
                        }
                    } else {
                        if (!queryTableRefs.containsAll(viewTableRefs)) continue;
                        matchModality = MatchModality.VIEW_PARTIAL;
                        ViewPartialRewriting partialRewritingResult = this.compensateViewPartial(call.builder(), rexBuilder, mq, view, topProject, node, queryTableRefs, qEC, topViewProject, viewNode, viewTableRefs);
                        if (partialRewritingResult == null) continue;
                        view = partialRewritingResult.newView;
                        topViewProject = partialRewritingResult.newTopViewProject;
                        viewNode = partialRewritingResult.newViewNode;
                    }
                } else {
                    matchModality = MatchModality.COMPLETE;
                }
                ArrayListMultimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> multiMapTables = ArrayListMultimap.create();
                for (RexTableInputRef.RelTableRef queryTableRef1 : queryTableRefs) {
                    for (RexTableInputRef.RelTableRef queryTableRef2 : queryTableRefs) {
                        if (!queryTableRef1.getQualifiedName().equals(queryTableRef2.getQualifiedName())) continue;
                        multiMapTables.put(queryTableRef1, queryTableRef2);
                    }
                }
                List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> flatListMappings = this.generateTableMappings(multiMapTables);
                for (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping : flatListMappings) {
                    RelNode viewWithFilter;
                    RexNode otherCompensationPred;
                    RexNode compensationColumnsEquiPred;
                    EquivalenceClasses currQEC = EquivalenceClasses.copy(qEC);
                    if (matchModality == MatchModality.QUERY_PARTIAL) {
                        for (Map.Entry e : compensationEquiColumns.entries()) {
                            RexTableInputRef.RelTableRef queryTableRef = (RexTableInputRef.RelTableRef)queryToViewTableMapping.inverse().get(((RexTableInputRef)e.getKey()).getTableRef());
                            RexTableInputRef queryColumnRef = RexTableInputRef.of(queryTableRef, ((RexTableInputRef)e.getKey()).getIndex(), ((RexTableInputRef)e.getKey()).getType());
                            currQEC.addEquivalenceClass(queryColumnRef, (RexTableInputRef)e.getValue());
                            queryToViewTableMapping.put(((RexTableInputRef)e.getValue()).getTableRef(), ((RexTableInputRef)e.getValue()).getTableRef());
                        }
                    }
                    RexNode viewColumnsEquiPred = RexUtil.swapTableReferences(rexBuilder, (RexNode)viewPreds.left, queryToViewTableMapping.inverse());
                    EquivalenceClasses queryBasedVEC = new EquivalenceClasses();
                    for (RexNode conj : RelOptUtil.conjunctions(viewColumnsEquiPred)) {
                        assert (conj.isA(SqlKind.EQUALS));
                        RexCall equiCond = (RexCall)conj;
                        queryBasedVEC.addEquivalenceClass((RexTableInputRef)equiCond.getOperands().get(0), (RexTableInputRef)equiCond.getOperands().get(1));
                    }
                    Pair<RexNode, RexNode> compensationPreds = this.computeCompensationPredicates(rexBuilder, simplify, currQEC, queryPreds, queryBasedVEC, viewPreds, queryToViewTableMapping);
                    if (compensationPreds == null && ((Config)this.config).generateUnionRewriting()) {
                        RelNode result;
                        RelNode unionInputView;
                        compensationPreds = this.computeCompensationPredicates(rexBuilder, simplify, queryBasedVEC, viewPreds, currQEC, queryPreds, queryToViewTableMapping.inverse());
                        if (compensationPreds == null) continue;
                        compensationColumnsEquiPred = (RexNode)compensationPreds.left;
                        otherCompensationPred = (RexNode)compensationPreds.right;
                        assert (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue());
                        RelNode unionInputQuery = this.rewriteQuery(call.builder(), rexBuilder, simplify, mq, compensationColumnsEquiPred, otherCompensationPred, topProject, node, queryToViewTableMapping, queryBasedVEC, currQEC);
                        if (unionInputQuery == null || (unionInputView = this.rewriteView(call.builder(), rexBuilder, simplify, mq, matchModality, true, view, topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC)) == null || (result = this.createUnion(call.builder(), rexBuilder, topProject, unionInputQuery, unionInputView)) == null) continue;
                        call.transformTo(result);
                        continue;
                    }
                    if (compensationPreds == null) continue;
                    compensationColumnsEquiPred = (RexNode)compensationPreds.left;
                    otherCompensationPred = (RexNode)compensationPreds.right;
                    if (!compensationColumnsEquiPred.isAlwaysTrue() || !otherCompensationPred.isAlwaysTrue()) {
                        List<RexNode> viewExprs;
                        List<RexNode> list = viewExprs = topViewProject == null ? this.extractReferences(rexBuilder, view) : topViewProject.getProjects();
                        if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, view, viewNode, viewExprs, queryToViewTableMapping.inverse(), queryBasedVEC, false, compensationColumnsEquiPred)) == null || !otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = this.rewriteExpression(rexBuilder, mq, view, viewNode, viewExprs, queryToViewTableMapping.inverse(), currQEC, true, otherCompensationPred)) == null) continue;
                    }
                    RexNode viewCompensationPred = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred));
                    RelBuilder builder = call.builder().transform(c -> c.withPruneInputOfAggregate(false));
                    if (!viewCompensationPred.isAlwaysTrue()) {
                        RexNode newPred = simplify.simplifyUnknownAsFalse(viewCompensationPred);
                        viewWithFilter = builder.push(view).filter(newPred).build();
                        if (viewWithFilter.getInputs().isEmpty()) {
                            call.transformTo(viewWithFilter);
                            return;
                        }
                        Pair<RelNode, RelNode> pushedNodes = this.pushFilterToOriginalViewPlan(builder, topViewProject, viewNode, newPred);
                        topViewProject = (Project)pushedNodes.left;
                        viewNode = (RelNode)pushedNodes.right;
                    } else {
                        viewWithFilter = builder.push(view).build();
                    }
                    RelNode result = this.rewriteView(builder, rexBuilder, simplify, mq, matchModality, false, viewWithFilter, topProject, node, topViewProject, viewNode, queryToViewTableMapping, currQEC);
                    if (result == null) continue;
                    call.transformTo(result);
                }
            }
        }
    }

    protected abstract boolean isValidPlan(Project var1, RelNode var2, RelMetadataQuery var3);

    protected abstract ViewPartialRewriting compensateViewPartial(RelBuilder var1, RexBuilder var2, RelMetadataQuery var3, RelNode var4, Project var5, RelNode var6, Set<RexTableInputRef.RelTableRef> var7, EquivalenceClasses var8, Project var9, RelNode var10, Set<RexTableInputRef.RelTableRef> var11);

    protected abstract RelNode rewriteQuery(RelBuilder var1, RexBuilder var2, RexSimplify var3, RelMetadataQuery var4, RexNode var5, RexNode var6, Project var7, RelNode var8, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var9, EquivalenceClasses var10, EquivalenceClasses var11);

    protected abstract RelNode createUnion(RelBuilder var1, RexBuilder var2, RelNode var3, RelNode var4, RelNode var5);

    protected abstract RelNode rewriteView(RelBuilder var1, RexBuilder var2, RexSimplify var3, RelMetadataQuery var4, MatchModality var5, boolean var6, RelNode var7, Project var8, RelNode var9, Project var10, RelNode var11, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> var12, EquivalenceClasses var13);

    protected abstract Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder var1, RelNode var2, RelNode var3, RexNode var4);

    protected List<RexNode> extractReferences(RexBuilder rexBuilder, RelNode node) {
        ImmutableList.Builder exprs = ImmutableList.builder();
        if (node instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)node;
            for (int i = 0; i < aggregate.getGroupCount(); ++i) {
                exprs.add(rexBuilder.makeInputRef(aggregate, i));
            }
        } else {
            for (int i = 0; i < node.getRowType().getFieldCount(); ++i) {
                exprs.add(rexBuilder.makeInputRef(node, i));
            }
        }
        return exprs.build();
    }

    protected List<BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>> generateTableMappings(Multimap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> multiMapTables) {
        if (multiMapTables.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableCollection result = ImmutableList.of(HashBiMap.create());
        for (Map.Entry<RexTableInputRef.RelTableRef, Collection<RexTableInputRef.RelTableRef>> e : multiMapTables.asMap().entrySet()) {
            if (e.getValue().size() == 1) {
                RexTableInputRef.RelTableRef target = e.getValue().iterator().next();
                for (BiMap m : result) {
                    m.put(e.getKey(), target);
                }
                continue;
            }
            ImmutableList.Builder newResult = ImmutableList.builder();
            for (RexTableInputRef.RelTableRef target : e.getValue()) {
                for (BiMap m : result) {
                    if (m.containsValue(target)) continue;
                    HashBiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> newM = HashBiMap.create(m);
                    newM.put(e.getKey(), target);
                    newResult.add(newM);
                }
            }
            result = newResult.build();
        }
        return result;
    }

    protected boolean isValidRelNodePlan(RelNode node, RelMetadataQuery mq) {
        Multimap<Class<? extends RelNode>, RelNode> m = mq.getNodeTypes(node);
        if (m == null) {
            return false;
        }
        for (Map.Entry<Class<? extends RelNode>, Collection<RelNode>> e : m.asMap().entrySet()) {
            Class<? extends RelNode> c = e.getKey();
            if (!(TableScan.class.isAssignableFrom(c) || Project.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || Join.class.isAssignableFrom(c))) {
                return false;
            }
            if (!Join.class.isAssignableFrom(c)) continue;
            for (RelNode n : e.getValue()) {
                Join join = (Join)n;
                if (join.getJoinType() == JoinRelType.INNER || join.isSemiJoin()) continue;
                return false;
            }
        }
        return true;
    }

    protected Pair<RexNode, RexNode> splitPredicates(RexBuilder rexBuilder, RexNode pred) {
        ArrayList<RexNode> equiColumnsPreds = new ArrayList<RexNode>();
        ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
        block3: for (RexNode e : RelOptUtil.conjunctions(pred)) {
            switch (e.getKind()) {
                case EQUALS: {
                    RexCall eqCall = (RexCall)e;
                    if (RexUtil.isReferenceOrAccess(eqCall.getOperands().get(0), false) && RexUtil.isReferenceOrAccess(eqCall.getOperands().get(1), false)) {
                        equiColumnsPreds.add(e);
                        continue block3;
                    }
                    residualPreds.add(e);
                    continue block3;
                }
            }
            residualPreds.add(e);
        }
        return Pair.of(RexUtil.composeConjunction(rexBuilder, equiColumnsPreds), RexUtil.composeConjunction(rexBuilder, residualPreds));
    }

    protected boolean compensatePartial(Set<RexTableInputRef.RelTableRef> sourceTableRefs, EquivalenceClasses sourceEC, Set<RexTableInputRef.RelTableRef> targetTableRefs, Multimap<RexTableInputRef, RexTableInputRef> compensationEquiColumns) {
        DefaultDirectedGraph<RexTableInputRef.RelTableRef, Edge> graph = DefaultDirectedGraph.create(Edge::new);
        ArrayListMultimap<List<String>, RexTableInputRef.RelTableRef> tableVNameToTableRefs = ArrayListMultimap.create();
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : sourceTableRefs) {
            graph.addVertex(tRef);
            tableVNameToTableRefs.put(tRef.getQualifiedName(), tRef);
            if (targetTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
            List<RelReferentialConstraint> constraints = tRef.getTable().getReferentialConstraints();
            for (RelReferentialConstraint constraint : constraints) {
                Collection parentTableRefs = tableVNameToTableRefs.get(constraint.getTargetQualifiedName());
                for (RexTableInputRef.RelTableRef parentTRef : parentTableRefs) {
                    boolean canBeRewritten = true;
                    ArrayListMultimap<RexTableInputRef, RexTableInputRef> equiColumns = ArrayListMultimap.create();
                    for (int pos = 0; pos < constraint.getNumColumns(); ++pos) {
                        int foreignKeyPos = constraint.getColumnPairs().get((int)pos).source;
                        RelDataType foreignKeyColumnType = tRef.getTable().getRowType().getFieldList().get(foreignKeyPos).getType();
                        RexTableInputRef foreignKeyColumnRef = RexTableInputRef.of(tRef, foreignKeyPos, foreignKeyColumnType);
                        int uniqueKeyPos = constraint.getColumnPairs().get((int)pos).target;
                        RexTableInputRef uniqueKeyColumnRef = RexTableInputRef.of(parentTRef, uniqueKeyPos, parentTRef.getTable().getRowType().getFieldList().get(uniqueKeyPos).getType());
                        if (foreignKeyColumnType.isNullable() || !sourceEC.getEquivalenceClassesMap().containsKey(uniqueKeyColumnRef) || !sourceEC.getEquivalenceClassesMap().get(uniqueKeyColumnRef).contains(foreignKeyColumnRef)) {
                            canBeRewritten = false;
                            break;
                        }
                        equiColumns.put(foreignKeyColumnRef, uniqueKeyColumnRef);
                    }
                    if (!canBeRewritten) continue;
                    Edge edge = (Edge)graph.getEdge(tRef, parentTRef);
                    if (edge == null) {
                        edge = (Edge)graph.addEdge(tRef, parentTRef);
                    }
                    edge.equiColumns.putAll(equiColumns);
                }
            }
        }
        boolean done = false;
        do {
            ArrayList<RexTableInputRef.RelTableRef> nodesToRemove = new ArrayList<RexTableInputRef.RelTableRef>();
            for (RexTableInputRef.RelTableRef tRef : graph.vertexSet()) {
                if (graph.getInwardEdges(tRef).size() != 1 || !graph.getOutwardEdges(tRef).isEmpty()) continue;
                nodesToRemove.add(tRef);
                if (compensationEquiColumns == null || !extraTableRefs.contains(tRef)) continue;
                compensationEquiColumns.putAll(((Edge)graph.getInwardEdges((RexTableInputRef.RelTableRef)tRef).get((int)0)).equiColumns);
            }
            if (!nodesToRemove.isEmpty()) {
                graph.removeAllVertices(nodesToRemove);
                continue;
            }
            done = true;
        } while (!done);
        return Collections.disjoint(graph.vertexSet(), extraTableRefs);
    }

    protected Pair<RexNode, RexNode> computeCompensationPredicates(RexBuilder rexBuilder, RexSimplify simplify, EquivalenceClasses sourceEC, Pair<RexNode, RexNode> sourcePreds, EquivalenceClasses targetEC, Pair<RexNode, RexNode> targetPreds, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> sourceToTargetTableMapping) {
        RexNode viewPred;
        RexNode compensationColumnsEquiPred = this.generateEquivalenceClasses(rexBuilder, sourceEC, targetEC);
        if (compensationColumnsEquiPred == null) {
            return null;
        }
        RexNode queryPred = RexUtil.swapColumnReferences(rexBuilder, (RexNode)sourcePreds.right, sourceEC.getEquivalenceClassesMap());
        RexNode compensationPred = SubstitutionVisitor.splitFilter(simplify, queryPred, viewPred = RexUtil.swapTableColumnReferences(rexBuilder, (RexNode)targetPreds.right, sourceToTargetTableMapping.inverse(), sourceEC.getEquivalenceClassesMap()));
        if (compensationPred == null) {
            return null;
        }
        return Pair.of(compensationColumnsEquiPred, compensationPred);
    }

    protected RexNode generateEquivalenceClasses(RexBuilder rexBuilder, EquivalenceClasses sourceEC, EquivalenceClasses targetEC) {
        List<Set<RexTableInputRef>> targetEquivalenceClasses;
        if (sourceEC.getEquivalenceClasses().isEmpty() && targetEC.getEquivalenceClasses().isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (sourceEC.getEquivalenceClasses().isEmpty() && !targetEC.getEquivalenceClasses().isEmpty()) {
            return null;
        }
        List<Set<RexTableInputRef>> sourceEquivalenceClasses = sourceEC.getEquivalenceClasses();
        Multimap<Integer, Integer> mapping = this.extractPossibleMapping(sourceEquivalenceClasses, targetEquivalenceClasses = targetEC.getEquivalenceClasses());
        if (mapping == null) {
            return null;
        }
        RexNode compensationPredicate = rexBuilder.makeLiteral(true);
        for (int i = 0; i < sourceEquivalenceClasses.size(); ++i) {
            if (!mapping.containsKey(i)) {
                Iterator<RexTableInputRef> it = sourceEquivalenceClasses.get(i).iterator();
                RexTableInputRef e0 = it.next();
                while (it.hasNext()) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e0, it.next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
                continue;
            }
            for (int j : mapping.get(i)) {
                HashSet difference = new HashSet(sourceEquivalenceClasses.get(i));
                difference.removeAll((Collection)targetEquivalenceClasses.get(j));
                for (RexTableInputRef e : difference) {
                    RexNode equals = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, e, targetEquivalenceClasses.get(j).iterator().next());
                    compensationPredicate = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, compensationPredicate, equals);
                }
            }
        }
        return compensationPredicate;
    }

    protected Multimap<Integer, Integer> extractPossibleMapping(List<Set<RexTableInputRef>> sourceEquivalenceClasses, List<Set<RexTableInputRef>> targetEquivalenceClasses) {
        ArrayListMultimap<Integer, Integer> mapping = ArrayListMultimap.create();
        for (int i = 0; i < targetEquivalenceClasses.size(); ++i) {
            boolean foundQueryEquivalenceClass = false;
            Set<RexTableInputRef> viewEquivalenceClass = targetEquivalenceClasses.get(i);
            for (int j = 0; j < sourceEquivalenceClasses.size(); ++j) {
                Set<RexTableInputRef> queryEquivalenceClass = sourceEquivalenceClasses.get(j);
                if (!queryEquivalenceClass.containsAll(viewEquivalenceClass)) continue;
                mapping.put(j, i);
                foundQueryEquivalenceClass = true;
                break;
            }
            if (foundQueryEquivalenceClass) continue;
            return null;
        }
        return mapping;
    }

    protected RexNode rewriteExpression(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode targetNode, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, RexNode exprToRewrite) {
        List<RexNode> rewrittenExprs = this.rewriteExpressions(rexBuilder, mq, targetNode, node, nodeExprs, tableMapping, ec, swapTableColumn, ImmutableList.of(exprToRewrite));
        if (rewrittenExprs == null) {
            return null;
        }
        assert (rewrittenExprs.size() == 1);
        return rewrittenExprs.get(0);
    }

    protected List<RexNode> rewriteExpressions(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode targetNode, RelNode node, List<RexNode> nodeExprs, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, boolean swapTableColumn, List<RexNode> exprsToRewrite) {
        NodeLineage nodeLineage = swapTableColumn ? this.generateSwapTableColumnReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs) : this.generateSwapColumnTableReferencesLineage(rexBuilder, mq, node, tableMapping, ec, nodeExprs);
        ArrayList<RexNode> rewrittenExprs = new ArrayList<RexNode>(exprsToRewrite.size());
        for (RexNode exprToRewrite : exprsToRewrite) {
            RexNode rewrittenExpr = this.replaceWithOriginalReferences(rexBuilder, targetNode, nodeLineage, exprToRewrite);
            if (RexUtil.containsTableInputRef(rewrittenExpr) != null) {
                return null;
            }
            rewrittenExprs.add(rewrittenExpr);
        }
        return rewrittenExprs;
    }

    protected NodeLineage generateSwapTableColumnReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<RexNode, Integer> exprsLineage = new HashMap<RexNode, Integer>();
        HashMap<RexNode, Integer> exprsLineageLosslessCasts = new HashMap<RexNode, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            assert (s.size() == 1);
            RexNode e = RexUtil.swapTableColumnReferences(rexBuilder, s.iterator().next(), tableMapping, ec.getEquivalenceClassesMap());
            exprsLineage.put(e, i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0), i);
        }
        return new NodeLineage(exprsLineage, exprsLineageLosslessCasts);
    }

    protected NodeLineage generateSwapColumnTableReferencesLineage(RexBuilder rexBuilder, RelMetadataQuery mq, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> tableMapping, EquivalenceClasses ec, List<RexNode> nodeExprs) {
        HashMap<RexNode, Integer> exprsLineage = new HashMap<RexNode, Integer>();
        HashMap<RexNode, Integer> exprsLineageLosslessCasts = new HashMap<RexNode, Integer>();
        for (int i = 0; i < nodeExprs.size(); ++i) {
            Set<RexNode> s = mq.getExpressionLineage(node, nodeExprs.get(i));
            if (s == null) continue;
            RexNode node2 = Iterables.getOnlyElement(s);
            RexNode e = RexUtil.swapColumnTableReferences(rexBuilder, node2, ec.getEquivalenceClassesMap(), tableMapping);
            exprsLineage.put(e, i);
            if (!RexUtil.isLosslessCast(e)) continue;
            exprsLineageLosslessCasts.put(((RexCall)e).getOperands().get(0), i);
        }
        return new NodeLineage(exprsLineage, exprsLineageLosslessCasts);
    }

    protected RexNode replaceWithOriginalReferences(final RexBuilder rexBuilder, final RelNode node, final NodeLineage nodeLineage, RexNode exprToRewrite) {
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall call) {
                RexNode rw = this.replace(call);
                return rw != null ? rw : super.visitCall(call);
            }

            @Override
            public RexNode visitTableInputRef(RexTableInputRef inputRef) {
                RexNode rw = this.replace(inputRef);
                return rw != null ? rw : super.visitTableInputRef(inputRef);
            }

            private RexNode replace(RexNode e) {
                Integer pos = (Integer)nodeLineage.exprsLineage.get(e);
                if (pos != null) {
                    return rexBuilder.makeInputRef(node, (int)pos);
                }
                pos = (Integer)nodeLineage.exprsLineageLosslessCasts.get(e);
                if (pos != null) {
                    return rexBuilder.makeCast(e.getType(), rexBuilder.makeInputRef(node, (int)pos));
                }
                return null;
            }
        };
        return visitor.apply(exprToRewrite);
    }

    protected RexNode shuttleReferences(final RexBuilder rexBuilder, RexNode node, final Mapping mapping) {
        try {
            RexShuttle visitor = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int pos = mapping.getTargetOpt(inputRef.getIndex());
                    if (pos != -1) {
                        return rexBuilder.makeInputRef(inputRef.getType(), pos);
                    }
                    throw Util.FoundOne.NULL;
                }
            };
            return visitor.apply(node);
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return null;
        }
    }

    protected RexNode shuttleReferences(RexBuilder rexBuilder, RexNode expr, Multimap<RexNode, Integer> exprsLineage) {
        return this.shuttleReferences(rexBuilder, expr, exprsLineage, null, null);
    }

    protected RexNode shuttleReferences(final RexBuilder rexBuilder, RexNode expr, final Multimap<RexNode, Integer> exprsLineage, final RelNode node, final Multimap<Integer, Integer> rewritingMapping) {
        try {
            RexShuttle visitor = new RexShuttle(){

                @Override
                public RexNode visitTableInputRef(RexTableInputRef ref) {
                    Collection c = exprsLineage.get(ref);
                    if (c.isEmpty()) {
                        throw Util.FoundOne.NULL;
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null) {
                        if (!rewritingMapping.containsKey(pos)) {
                            throw Util.FoundOne.NULL;
                        }
                        pos = (Integer)rewritingMapping.get(pos).iterator().next();
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(ref.getType(), pos);
                }

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    Collection c = exprsLineage.get(inputRef);
                    if (c.isEmpty()) {
                        throw Util.FoundOne.NULL;
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null) {
                        if (!rewritingMapping.containsKey(pos)) {
                            throw Util.FoundOne.NULL;
                        }
                        pos = (Integer)rewritingMapping.get(pos).iterator().next();
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(inputRef.getType(), pos);
                }

                @Override
                public RexNode visitCall(RexCall call) {
                    Collection c = exprsLineage.get(call);
                    if (c.isEmpty()) {
                        return super.visitCall(call);
                    }
                    int pos = (Integer)c.iterator().next();
                    if (rewritingMapping != null) {
                        if (!rewritingMapping.containsKey(pos)) {
                            return super.visitCall(call);
                        }
                        pos = (Integer)rewritingMapping.get(pos).iterator().next();
                    }
                    if (node != null) {
                        return rexBuilder.makeInputRef(node, pos);
                    }
                    return rexBuilder.makeInputRef(call.getType(), pos);
                }
            };
            return visitor.apply(expr);
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return null;
        }
    }

    public static interface Config
    extends RelRule.Config {
        @ImmutableBeans.Property
        public boolean generateUnionRewriting();

        public Config withGenerateUnionRewriting(boolean var1);

        @ImmutableBeans.Property
        public HepProgram unionRewritingPullProgram();

        public Config withUnionRewritingPullProgram(HepProgram var1);

        @ImmutableBeans.Property
        public boolean fastBailOut();

        public Config withFastBailOut(boolean var1);
    }

    protected static enum MatchModality {
        COMPLETE,
        VIEW_PARTIAL,
        QUERY_PARTIAL;

    }

    protected static class ViewPartialRewriting {
        private final RelNode newView;
        private final Project newTopViewProject;
        private final RelNode newViewNode;

        private ViewPartialRewriting(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            this.newView = newView;
            this.newTopViewProject = newTopViewProject;
            this.newViewNode = newViewNode;
        }

        protected static ViewPartialRewriting of(RelNode newView, Project newTopViewProject, RelNode newViewNode) {
            return new ViewPartialRewriting(newView, newTopViewProject, newViewNode);
        }
    }

    protected static class Edge
    extends DefaultEdge {
        final Multimap<RexTableInputRef, RexTableInputRef> equiColumns = ArrayListMultimap.create();

        Edge(RexTableInputRef.RelTableRef source, RexTableInputRef.RelTableRef target) {
            super(source, target);
        }

        public String toString() {
            return "{" + this.source + " -> " + this.target + "}";
        }
    }

    protected static class NodeLineage {
        private final Map<RexNode, Integer> exprsLineage;
        private final Map<RexNode, Integer> exprsLineageLosslessCasts;

        private NodeLineage(Map<RexNode, Integer> exprsLineage, Map<RexNode, Integer> exprsLineageLosslessCasts) {
            this.exprsLineage = ImmutableMap.copyOf(exprsLineage);
            this.exprsLineageLosslessCasts = ImmutableMap.copyOf(exprsLineageLosslessCasts);
        }
    }

    protected static class EquivalenceClasses {
        private final Map<RexTableInputRef, Set<RexTableInputRef>> nodeToEquivalenceClass = new HashMap<RexTableInputRef, Set<RexTableInputRef>>();
        private Map<RexTableInputRef, Set<RexTableInputRef>> cacheEquivalenceClassesMap = ImmutableMap.of();
        private List<Set<RexTableInputRef>> cacheEquivalenceClasses = ImmutableList.of();

        protected EquivalenceClasses() {
        }

        protected void addEquivalenceClass(RexTableInputRef p1, RexTableInputRef p2) {
            this.cacheEquivalenceClassesMap = null;
            this.cacheEquivalenceClasses = null;
            Object c1 = this.nodeToEquivalenceClass.get(p1);
            Set<RexTableInputRef> c2 = this.nodeToEquivalenceClass.get(p2);
            if (c1 != null && c2 != null) {
                if (c1.size() < c2.size()) {
                    Set<RexTableInputRef> c2Temp = c2;
                    c2 = c1;
                    c1 = c2Temp;
                }
                for (RexTableInputRef newRef : c2) {
                    c1.add(newRef);
                    this.nodeToEquivalenceClass.put(newRef, (Set<RexTableInputRef>)c1);
                }
            } else if (c1 != null) {
                c1.add((RexTableInputRef)p2);
                this.nodeToEquivalenceClass.put(p2, (Set<RexTableInputRef>)c1);
            } else if (c2 != null) {
                c2.add(p1);
                this.nodeToEquivalenceClass.put(p1, c2);
            } else {
                LinkedHashSet<RexTableInputRef> equivalenceClass = new LinkedHashSet<RexTableInputRef>();
                equivalenceClass.add(p1);
                equivalenceClass.add(p2);
                this.nodeToEquivalenceClass.put(p1, equivalenceClass);
                this.nodeToEquivalenceClass.put(p2, equivalenceClass);
            }
        }

        protected Map<RexTableInputRef, Set<RexTableInputRef>> getEquivalenceClassesMap() {
            if (this.cacheEquivalenceClassesMap == null) {
                this.cacheEquivalenceClassesMap = ImmutableMap.copyOf(this.nodeToEquivalenceClass);
            }
            return this.cacheEquivalenceClassesMap;
        }

        protected List<Set<RexTableInputRef>> getEquivalenceClasses() {
            if (this.cacheEquivalenceClasses == null) {
                HashSet<RexTableInputRef> visited = new HashSet<RexTableInputRef>();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Set<RexTableInputRef> set : this.nodeToEquivalenceClass.values()) {
                    if (!Collections.disjoint(visited, set)) continue;
                    builder.add(set);
                    visited.addAll(set);
                }
                this.cacheEquivalenceClasses = builder.build();
            }
            return this.cacheEquivalenceClasses;
        }

        protected static EquivalenceClasses copy(EquivalenceClasses ec) {
            EquivalenceClasses newEc = new EquivalenceClasses();
            for (Map.Entry<RexTableInputRef, Set<RexTableInputRef>> e : ec.nodeToEquivalenceClass.entrySet()) {
                newEc.nodeToEquivalenceClass.put(e.getKey(), Sets.newLinkedHashSet((Iterable)e.getValue()));
            }
            newEc.cacheEquivalenceClassesMap = null;
            newEc.cacheEquivalenceClasses = null;
            return newEc;
        }
    }
}

