/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinInfo;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;

public abstract class SemiJoinRule
extends RelRule<Config>
implements TransformationRule {
    private static final Predicate<Join> NOT_GENERATE_NULLS_ON_LEFT = join -> !join.getJoinType().generatesNullsOnLeft();
    private static final Predicate<Aggregate> IS_EMPTY_AGGREGATE = aggregate -> aggregate.getRowType().getFieldCount() == 0;

    protected SemiJoinRule(Config config) {
        super(config);
    }

    protected void perform(RelOptRuleCall call, Project project, Join join, RelNode left, Aggregate aggregate) {
        ImmutableBitSet rightBits;
        ImmutableBitSet bits;
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (project != null ? (bits = RelOptUtil.InputFinder.bits(project.getProjects(), null)).intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount())) : join.getJoinType().projectsRight() && !IS_EMPTY_AGGREGATE.test(aggregate)) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(left);
        switch (join.getJoinType()) {
            case SEMI: 
            case INNER: {
                ArrayList<Integer> newRightKeyBuilder = new ArrayList<Integer>();
                List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
                for (int key : joinInfo.rightKeys) {
                    newRightKeyBuilder.add(aggregateKeys.get(key));
                }
                ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
                relBuilder.push(aggregate.getInput());
                RexNode newCondition = RelOptUtil.createEquiJoinCondition(relBuilder.peek(2, 0), joinInfo.leftKeys, relBuilder.peek(2, 1), newRightKeys, rexBuilder);
                relBuilder.semiJoin(newCondition);
                break;
            }
            case LEFT: {
                break;
            }
            default: {
                throw new AssertionError((Object)join.getJoinType());
            }
        }
        if (project != null) {
            relBuilder.project(project.getProjects(), project.getRowType().getFieldNames());
        }
        RelNode relNode = relBuilder.build();
        call.transformTo(relNode);
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        public SemiJoinRule toRule();
    }

    public static class JoinToSemiJoinRule
    extends SemiJoinRule {
        protected JoinToSemiJoinRule(Config config) {
            super(config);
        }

        @Deprecated
        public JoinToSemiJoinRule(Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(joinClass, aggregateClass));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            Object left = call.rel(1);
            Aggregate aggregate = (Aggregate)call.rel(2);
            this.perform(call, null, join, (RelNode)left, aggregate);
        }

        public static interface Config
        extends org.apache.hive.druid.org.apache.calcite.rel.rules.SemiJoinRule$Config {
            public static final Config DEFAULT = EMPTY.withDescription("SemiJoinRule:join").as(Config.class).withOperandFor(Join.class, Aggregate.class);

            @Override
            default public JoinToSemiJoinRule toRule() {
                return new JoinToSemiJoinRule(this);
            }

            default public Config withOperandFor(Class<Join> joinClass, Class<Aggregate> aggregateClass) {
                return this.withOperandSupplier(b -> b.operand(joinClass).predicate(NOT_GENERATE_NULLS_ON_LEFT).inputs(b2 -> b2.operand(RelNode.class).anyInputs(), b3 -> b3.operand(aggregateClass).anyInputs())).as(Config.class);
            }
        }
    }

    public static class ProjectToSemiJoinRule
    extends SemiJoinRule {
        protected ProjectToSemiJoinRule(Config config) {
            super(config);
        }

        @Deprecated
        public ProjectToSemiJoinRule(Class<Project> projectClass, Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(Config.class).withOperandFor(projectClass, joinClass, aggregateClass));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            Object left = call.rel(2);
            Aggregate aggregate = (Aggregate)call.rel(3);
            this.perform(call, project, join, (RelNode)left, aggregate);
        }

        public static interface Config
        extends org.apache.hive.druid.org.apache.calcite.rel.rules.SemiJoinRule$Config {
            public static final Config DEFAULT = EMPTY.withDescription("SemiJoinRule:project").as(Config.class).withOperandFor(Project.class, Join.class, Aggregate.class);

            @Override
            default public ProjectToSemiJoinRule toRule() {
                return new ProjectToSemiJoinRule(this);
            }

            default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Join> joinClass, Class<? extends Aggregate> aggregateClass) {
                return this.withOperandSupplier(b -> b.operand(projectClass).oneInput(b2 -> b2.operand(joinClass).predicate(NOT_GENERATE_NULLS_ON_LEFT).inputs(b3 -> b3.operand(RelNode.class).anyInputs(), b4 -> b4.operand(aggregateClass).anyInputs()))).as(Config.class);
            }
        }
    }
}

