/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;

public class ProjectRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected ProjectRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectRemoveRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (ProjectRemoveRule.isTrivial(project));
        RelNode stripped = project.getInput();
        if (stripped instanceof Project) {
            Project childProject = (Project)stripped;
            stripped = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), project.getRowType());
        }
        stripped = ProjectRemoveRule.convert(stripped, project.getConvention());
        call.transformTo(stripped);
    }

    public static RelNode strip(Project project) {
        return ProjectRemoveRule.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(Project project) {
        return RexUtil.isIdentity(project.getProjects(), project.getInput().getRowType());
    }

    @Override
    public boolean autoPruneOld() {
        return true;
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b -> b.operand(Project.class).predicate(ProjectRemoveRule::isTrivial).anyInputs()).as(Config.class);

        @Override
        default public ProjectRemoveRule toRule() {
            return new ProjectRemoveRule(this);
        }
    }
}

