/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptMaterialization;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptMaterializations;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepProgram;
import org.apache.hive.druid.org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.rules.CoreRules;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;

public class MaterializedViewFilterScanRule
extends RelRule<Config>
implements TransformationRule {
    private static final Supplier<HepProgram> PROGRAM = Suppliers.memoize(() -> new HepProgramBuilder().addRuleInstance(CoreRules.FILTER_PROJECT_TRANSPOSE).addRuleInstance(CoreRules.PROJECT_MERGE).build())::get;

    protected MaterializedViewFilterScanRule(Config config) {
        super(config);
    }

    @Deprecated
    public MaterializedViewFilterScanRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        this.apply(call, filter, scan);
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        RelOptPlanner planner = call.getPlanner();
        List<RelOptMaterialization> materializations = planner.getMaterializations();
        if (!materializations.isEmpty()) {
            RelNode root = filter.copy(filter.getTraitSet(), Collections.singletonList(scan));
            List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(root, materializations);
            for (RelOptMaterialization materialization : applicableMaterializations) {
                if (!RelOptUtil.areRowTypesEqual(scan.getRowType(), materialization.queryRel.getRowType(), false)) continue;
                RelNode target = materialization.queryRel;
                HepPlanner hepPlanner = new HepPlanner(PROGRAM.get(), planner.getContext());
                hepPlanner.setRoot(target);
                target = hepPlanner.findBestExp();
                List<RelNode> subs = new SubstitutionVisitor(target, root).go(materialization.tableRel);
                for (RelNode s : subs) {
                    call.transformTo(s);
                }
            }
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(Filter.class, TableScan.class);

        @Override
        default public MaterializedViewFilterScanRule toRule() {
            return new MaterializedViewFilterScanRule(this);
        }

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends TableScan> scanClass) {
            return this.withOperandSupplier(b0 -> b0.operand(filterClass).oneInput(b1 -> b1.operand(scanClass).noInputs())).as(Config.class);
        }
    }
}

