/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mappings;

public class JoinAssociateRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinAssociateRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinAssociateRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelSubset relC = (RelSubset)call.rel(2);
        RelOptCluster cluster = topJoin.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (relC.getConvention() != relA.getConvention()) {
            return;
        }
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet aBitSet = ImmutableBitSet.range(0, aCount);
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (!topJoin.getSystemFieldList().isEmpty()) {
            return;
        }
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> top = new ArrayList<RexNode>();
        ArrayList<RexNode> bottom = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), aBitSet, top, bottom);
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, top, bottom);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, aCount, bCount, bCount, aCount + bCount, cCount);
        List newBottomList = new RexPermuteInputsShuttle(bottomMapping, relB, relC).visitList(bottom);
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relB, relC, JoinRelType.INNER, false);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, top);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, relA, newBottomJoin, JoinRelType.INNER, false);
        call.transformTo(newTopJoin);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(Join.class, RelSubset.class);

        @Override
        default public JoinAssociateRule toRule() {
            return new JoinAssociateRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass, Class<? extends RelSubset> relSubsetClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(joinClass).anyInputs(), b2 -> b2.operand(relSubsetClass).anyInputs())).as(Config.class);
        }
    }
}

