/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.rules.TransformationRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;

public final class FilterRemoveIsNotDistinctFromRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterRemoveIsNotDistinctFromRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterRemoveIsNotDistinctFromRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter oldFilter = (Filter)call.rel(0);
        RexNode oldFilterCond = oldFilter.getCondition();
        if (RexUtil.findOperatorCall(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, oldFilterCond) == null) {
            return;
        }
        RemoveIsNotDistinctFromRexShuttle rewriteShuttle = new RemoveIsNotDistinctFromRexShuttle(oldFilter.getCluster().getRexBuilder());
        RelBuilder relBuilder = call.builder();
        RelNode newFilterRel = relBuilder.push(oldFilter.getInput()).filter(oldFilterCond.accept(rewriteShuttle)).build();
        call.transformTo(newFilterRel);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b -> b.operand(Filter.class).anyInputs()).as(Config.class);

        @Override
        default public FilterRemoveIsNotDistinctFromRule toRule() {
            return new FilterRemoveIsNotDistinctFromRule(this);
        }
    }

    private static class RemoveIsNotDistinctFromRexShuttle
    extends RexShuttle {
        final RexBuilder rexBuilder;

        RemoveIsNotDistinctFromRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall = super.visitCall(call);
            if (call.getOperator() == SqlStdOperatorTable.IS_NOT_DISTINCT_FROM) {
                RexCall tmpCall = (RexCall)newCall;
                newCall = RelOptUtil.isDistinctFrom(this.rexBuilder, (RexNode)tmpCall.operands.get(0), (RexNode)tmpCall.operands.get(1), true);
            }
            return newCall;
        }
    }
}

