/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistributions;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Exchange;
import org.apache.hive.druid.org.apache.calcite.rel.core.SortExchange;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalSortExchange;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBeans;

public class ExchangeRemoveConstantKeysRule
extends RelRule<Config>
implements SubstitutionRule {
    protected ExchangeRemoveConstantKeysRule(Config config) {
        super(config);
    }

    protected static List<Integer> simplifyDistributionKeys(RelDistribution distribution, Set<Integer> constants) {
        return distribution.getKeys().stream().filter(key -> !constants.contains(key)).collect(Collectors.toList());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    private static void matchExchange(ExchangeRemoveConstantKeysRule rule, RelOptRuleCall call) {
        RelNode input;
        Exchange exchange = (Exchange)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = exchange.getInput());
        if (predicates == null) {
            return;
        }
        HashSet<Integer> constants = new HashSet<Integer>();
        predicates.constantMap.keySet().forEach(key -> {
            if (key instanceof RexInputRef) {
                constants.add(((RexInputRef)key).getIndex());
            }
        });
        if (constants.isEmpty()) {
            return;
        }
        List<Integer> distributionKeys = ExchangeRemoveConstantKeysRule.simplifyDistributionKeys(exchange.getDistribution(), constants);
        if (distributionKeys.size() != exchange.getDistribution().getKeys().size()) {
            call.transformTo(call.builder().push(exchange.getInput()).exchange(distributionKeys.isEmpty() ? RelDistributions.SINGLETON : RelDistributions.hash(distributionKeys)).build());
            call.getPlanner().prune(exchange);
        }
    }

    private static void matchSortExchange(ExchangeRemoveConstantKeysRule rule, RelOptRuleCall call) {
        List<RelFieldCollation> fieldCollations;
        boolean collationSimplified;
        boolean hashDistribution;
        RelNode input;
        SortExchange sortExchange = (SortExchange)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(input = sortExchange.getInput());
        if (predicates == null) {
            return;
        }
        HashSet<Integer> constants = new HashSet<Integer>();
        predicates.constantMap.keySet().forEach(key -> {
            if (key instanceof RexInputRef) {
                constants.add(((RexInputRef)key).getIndex());
            }
        });
        if (constants.isEmpty()) {
            return;
        }
        List<Object> distributionKeys = new ArrayList();
        boolean distributionSimplified = false;
        boolean bl = hashDistribution = sortExchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED;
        if (hashDistribution) {
            distributionKeys = ExchangeRemoveConstantKeysRule.simplifyDistributionKeys(sortExchange.getDistribution(), constants);
            distributionSimplified = distributionKeys.size() != sortExchange.getDistribution().getKeys().size();
        }
        boolean bl2 = collationSimplified = (fieldCollations = sortExchange.getCollation().getFieldCollations().stream().filter(fc -> !constants.contains(fc.getFieldIndex())).collect(Collectors.toList())).size() != sortExchange.getCollation().getFieldCollations().size();
        if (distributionSimplified || collationSimplified) {
            RelDistribution distribution = distributionSimplified ? (distributionKeys.isEmpty() ? RelDistributions.SINGLETON : RelDistributions.hash(distributionKeys)) : sortExchange.getDistribution();
            RelCollation collation = collationSimplified ? RelCollations.of(fieldCollations) : sortExchange.getCollation();
            call.transformTo(call.builder().push(sortExchange.getInput()).sortExchange(distribution, collation).build());
            call.getPlanner().prune(sortExchange);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(LogicalExchange.class, exchange -> exchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED).withMatchHandler((x$0, x$1) -> ExchangeRemoveConstantKeysRule.access$100(x$0, x$1));
        public static final Config SORT = EMPTY.withDescription("SortExchangeRemoveConstantKeysRule").as(Config.class).withOperandFor(LogicalSortExchange.class, sortExchange -> sortExchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED || !sortExchange.getCollation().getFieldCollations().isEmpty()).withMatchHandler((x$0, x$1) -> ExchangeRemoveConstantKeysRule.access$000(x$0, x$1));

        @Override
        default public ExchangeRemoveConstantKeysRule toRule() {
            return new ExchangeRemoveConstantKeysRule(this);
        }

        @ImmutableBeans.Property
        public <R extends RelOptRule> RelRule.MatchHandler<R> matchHandler();

        public <R extends RelOptRule> Config withMatchHandler(RelRule.MatchHandler<R> var1);

        default public <R extends Exchange> Config withOperandFor(Class<R> exchangeClass, Predicate<R> predicate) {
            return this.withOperandSupplier(b -> b.operand(exchangeClass).predicate(predicate).anyInputs()).as(Config.class);
        }
    }
}

