/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelRule;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.runtime.SqlFunctions;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSplittableAggFunction;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;

public class AggregateRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected AggregateRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateRemoveRule(Class<? extends Aggregate> aggregateClass) {
        this(aggregateClass, RelFactories.LOGICAL_BUILDER);
    }

    @Deprecated
    public AggregateRemoveRule(Class<? extends Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(aggregateClass));
    }

    private static boolean isAggregateSupported(Aggregate aggregate) {
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE || aggregate.getGroupCount() == 0) {
            return false;
        }
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            if (aggregateCall.filterArg < 0 && aggregateCall.getAggregation().unwrap(SqlSplittableAggFunction.class) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode input = aggregate.getInput();
        RelMetadataQuery mq = call.getMetadataQuery();
        if (!SqlFunctions.isTrue(mq.areColumnsUnique(input, aggregate.getGroupSet()))) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            SqlAggFunction aggregation = aggCall.getAggregation();
            if (aggregation.getKind() == SqlKind.SUM0) {
                return;
            }
            SqlSplittableAggFunction splitter = Objects.requireNonNull(aggregation.unwrap(SqlSplittableAggFunction.class));
            RexNode singleton = splitter.singleton(rexBuilder, input.getRowType(), aggCall);
            projects.add(singleton);
        }
        RelNode newInput = AggregateRemoveRule.convert(input, aggregate.getTraitSet().simplify());
        relBuilder.push(newInput);
        if (!projects.isEmpty()) {
            projects.addAll(0, relBuilder.fields(aggregate.getGroupSet()));
            relBuilder.project(projects);
        } else if (newInput.getRowType().getFieldCount() > aggregate.getRowType().getFieldCount()) {
            relBuilder.project(relBuilder.fields(aggregate.getGroupSet()));
        }
        call.getPlanner().prune(aggregate);
        call.transformTo(relBuilder.build());
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).as(Config.class).withOperandFor(LogicalAggregate.class);

        @Override
        default public AggregateRemoveRule toRule() {
            return new AggregateRemoveRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass) {
            return this.withOperandSupplier(b -> b.operand(aggregateClass).predicate(x$0 -> AggregateRemoveRule.isAggregateSupported(x$0)).anyInputs()).as(Config.class);
        }
    }
}

