/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.metadata;

import java.util.concurrent.ExecutionException;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.Metadata;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class MetadataFactoryImpl
implements MetadataFactory {
    public static final UnboundMetadata<Metadata> DUMMY = (rel, mq) -> null;
    private final LoadingCache<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> cache;

    public MetadataFactoryImpl(RelMetadataProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(MetadataFactoryImpl.loader(provider));
    }

    private static CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> loader(RelMetadataProvider provider) {
        return CacheLoader.from(key -> {
            UnboundMetadata function = provider.apply((Class)key.left, (Class)key.right);
            return function != null ? function : DUMMY;
        });
    }

    @Override
    public <M extends Metadata> M query(RelNode rel, RelMetadataQuery mq, Class<M> metadataClazz) {
        try {
            Pair<Class<?>, Class<M>> key = Pair.of(rel.getClass(), metadataClazz);
            Metadata apply = this.cache.get(key).bind(rel, mq);
            return (M)((Metadata)metadataClazz.cast(apply));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

