/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.externalize;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelWriter;
import org.apache.hive.druid.org.apache.calcite.rel.externalize.RelJson;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExplainLevel;
import org.apache.hive.druid.org.apache.calcite.util.JsonBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class RelJsonWriter
implements RelWriter {
    protected final JsonBuilder jsonBuilder;
    protected final RelJson relJson;
    private final Map<RelNode, String> relIdMap = new IdentityHashMap<RelNode, String>();
    protected final List<Object> relList;
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
    private String previousId;

    public RelJsonWriter() {
        this.jsonBuilder = new JsonBuilder();
        this.relList = this.jsonBuilder.list();
        this.relJson = new RelJson(this.jsonBuilder);
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("id", null);
        map.put("relOp", this.relJson.classToTypeName(rel.getClass()));
        for (Pair<String, Object> value : values) {
            if (value.right instanceof RelNode) continue;
            this.put(map, (String)value.left, value.right);
        }
        List<Object> list = this.explainInputs(rel.getInputs());
        if (list.size() != 1 || !list.get(0).equals(this.previousId)) {
            map.put("inputs", list);
        }
        String id = Integer.toString(this.relIdMap.size());
        this.relIdMap.put(rel, id);
        map.put("id", id);
        this.relList.add(map);
        this.previousId = id;
    }

    private void put(Map<String, Object> map, String name, Object value) {
        map.put(name, this.relJson.toJson(value));
    }

    private List<Object> explainInputs(List<RelNode> inputs) {
        List<Object> list = this.jsonBuilder.list();
        for (RelNode input : inputs) {
            String id = this.relIdMap.get(input);
            if (id == null) {
                input.explain(this);
                id = this.previousId;
            }
            list.add(id);
        }
        return list;
    }

    @Override
    public final void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        this.explain_(rel, valueList);
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.ALL_ATTRIBUTES;
    }

    @Override
    public RelWriter item(String term, Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    private List<Object> getList(List<Pair<String, Object>> values, String tag) {
        for (Pair<String, Object> value : values) {
            if (!((String)value.left).equals(tag)) continue;
            return (List)value.right;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        values.add(Pair.of(tag, list));
        return list;
    }

    @Override
    public RelWriter done(RelNode node) {
        ImmutableList<Pair<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        return this;
    }

    @Override
    public boolean nest() {
        return true;
    }

    public String asString() {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("rels", this.relList);
        return this.jsonBuilder.toJsonString(map);
    }
}

