/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.core;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelWriter;
import org.apache.hive.druid.org.apache.calcite.rel.SingleRel;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexChecker;
import org.apache.hive.druid.org.apache.calcite.rex.RexFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexLocalRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexSlot;
import org.apache.hive.druid.org.apache.calcite.rex.RexWindowBound;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;
import org.apache.hive.druid.org.apache.calcite.util.Litmus;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public abstract class Window
extends SingleRel {
    public final ImmutableList<Group> groups;
    public final ImmutableList<RexLiteral> constants;

    public Window(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Group> groups) {
        super(cluster, traitSet, input);
        this.constants = ImmutableList.copyOf(constants);
        assert (rowType != null);
        this.rowType = rowType;
        this.groups = ImmutableList.copyOf(groups);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        final RelDataType childRowType = this.getInput().getRowType();
        final int childFieldCount = childRowType.getFieldCount();
        final int inputSize = childFieldCount + this.constants.size();
        AbstractList<RelDataType> inputTypes = new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return index < childFieldCount ? childRowType.getFieldList().get(index).getType() : ((RexLiteral)Window.this.constants.get(index - childFieldCount)).getType();
            }

            @Override
            public int size() {
                return inputSize;
            }
        };
        RexChecker checker = new RexChecker((List<RelDataType>)inputTypes, context, litmus);
        int count = 0;
        for (Group group : this.groups) {
            for (RexWinAggCall over : group.aggCalls) {
                ++count;
                if (checker.isValid(over)) continue;
                return litmus.fail(null, new Object[0]);
            }
        }
        if (count == 0) {
            return litmus.fail("empty", new Object[0]);
        }
        return litmus.succeed();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<Group> window : Ord.zip(this.groups)) {
            pw.item("window#" + window.i, ((Group)window.e).toString());
        }
        return pw;
    }

    public static ImmutableIntList getProjectOrdinals(final List<RexNode> exprs) {
        return ImmutableIntList.copyOf((Iterable<? extends Number>)new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return ((RexSlot)exprs.get(index)).getIndex();
            }

            @Override
            public int size() {
                return exprs.size();
            }
        });
    }

    public static RelCollation getCollation(final List<RexFieldCollation> collations) {
        return RelCollations.of((List<RelFieldCollation>)new AbstractList<RelFieldCollation>(){

            @Override
            public RelFieldCollation get(int index) {
                RexFieldCollation collation = (RexFieldCollation)collations.get(index);
                return new RelFieldCollation(((RexLocalRef)collation.left).getIndex(), collation.getDirection(), collation.getNullDirection());
            }

            @Override
            public int size() {
                return collations.size();
            }
        });
    }

    public List<RexLiteral> getConstants() {
        return this.constants;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowsIn = mq.getRowCount(this.getInput());
        int count = this.groups.size();
        for (Group group : this.groups) {
            count += group.aggCalls.size();
        }
        return planner.getCostFactory().makeCost(rowsIn, rowsIn * (double)count, 0.0);
    }

    public static class RexWinAggCall
    extends RexCall {
        public final int ordinal;
        public final boolean distinct;
        public final boolean ignoreNulls;

        @Deprecated
        public RexWinAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal, boolean distinct) {
            this(aggFun, type, operands, ordinal, distinct, false);
        }

        public RexWinAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal, boolean distinct, boolean ignoreNulls) {
            super(type, aggFun, operands);
            this.ordinal = ordinal;
            this.distinct = distinct;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RexWinAggCall that = (RexWinAggCall)o;
            return this.ordinal == that.ordinal && this.distinct == that.distinct && this.ignoreNulls == that.ignoreNulls;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Objects.hash(super.hashCode(), this.ordinal, this.distinct, this.ignoreNulls);
            }
            return this.hash;
        }

        @Override
        public RexCall clone(RelDataType type, List<RexNode> operands) {
            return super.clone(type, operands);
        }
    }

    public static class Group {
        public final ImmutableBitSet keys;
        public final boolean isRows;
        public final RexWindowBound lowerBound;
        public final RexWindowBound upperBound;
        public final RelCollation orderKeys;
        private final String digest;
        public final ImmutableList<RexWinAggCall> aggCalls;

        public Group(ImmutableBitSet keys, boolean isRows, RexWindowBound lowerBound, RexWindowBound upperBound, RelCollation orderKeys, List<RexWinAggCall> aggCalls) {
            this.keys = Objects.requireNonNull(keys);
            this.isRows = isRows;
            this.lowerBound = Objects.requireNonNull(lowerBound);
            this.upperBound = Objects.requireNonNull(upperBound);
            this.orderKeys = Objects.requireNonNull(orderKeys);
            this.aggCalls = ImmutableList.copyOf(aggCalls);
            this.digest = this.computeString();
        }

        public String toString() {
            return this.digest;
        }

        private String computeString() {
            StringBuilder buf = new StringBuilder("window(");
            int i = buf.length();
            if (!this.keys.isEmpty()) {
                buf.append("partition ");
                buf.append(this.keys);
            }
            if (!this.orderKeys.getFieldCollations().isEmpty()) {
                buf.append(buf.length() == i ? "order by " : " order by ");
                buf.append(this.orderKeys);
            }
            if (!(this.orderKeys.getFieldCollations().isEmpty() && this.lowerBound.isUnbounded() && this.lowerBound.isPreceding() && this.upperBound.isUnbounded() && this.upperBound.isFollowing() || !this.orderKeys.getFieldCollations().isEmpty() && this.lowerBound.isUnbounded() && this.lowerBound.isPreceding() && this.upperBound.isCurrentRow() && !this.isRows)) {
                buf.append(this.isRows ? " rows " : " range ");
                buf.append("between ");
                buf.append(this.lowerBound);
                buf.append(" and ");
                buf.append(this.upperBound);
            }
            if (!this.aggCalls.isEmpty()) {
                buf.append(buf.length() == i ? "aggs " : " aggs ");
                buf.append(this.aggCalls);
            }
            buf.append(")");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Group && this.digest.equals(((Group)obj).digest);
        }

        public int hashCode() {
            return this.digest.hashCode();
        }

        public RelCollation collation() {
            return this.orderKeys;
        }

        public boolean isAlwaysNonEmpty() {
            int lowerKey = this.lowerBound.getOrderKey();
            int upperKey = this.upperBound.getOrderKey();
            return lowerKey > -1 && lowerKey <= upperKey;
        }

        public List<AggregateCall> getAggregateCalls(Window windowRel) {
            final List<String> fieldNames = Util.skip(windowRel.getRowType().getFieldNames(), windowRel.getInput().getRowType().getFieldCount());
            return new AbstractList<AggregateCall>(){

                @Override
                public int size() {
                    return aggCalls.size();
                }

                @Override
                public AggregateCall get(int index) {
                    RexWinAggCall aggCall = (RexWinAggCall)aggCalls.get(index);
                    SqlAggFunction op = (SqlAggFunction)aggCall.getOperator();
                    return AggregateCall.create(op, aggCall.distinct, false, aggCall.ignoreNulls, Window.getProjectOrdinals(aggCall.getOperands()), -1, RelCollations.EMPTY, aggCall.getType(), (String)fieldNames.get(aggCall.ordinal));
                }
            };
        }
    }
}

