/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.volcano;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

class TopDownRuleQueue
extends RuleQueue {
    private final Map<RelNode, List<VolcanoRuleMatch>> matches = new HashMap<RelNode, List<VolcanoRuleMatch>>();
    private final Set<String> names = new HashSet<String>();

    TopDownRuleQueue(VolcanoPlanner planner) {
        super(planner);
    }

    @Override
    public void addMatch(VolcanoRuleMatch match) {
        Object rel = match.rel(0);
        List queue = this.matches.computeIfAbsent((RelNode)rel, (Function<RelNode, List<VolcanoRuleMatch>>)((Function<RelNode, List>)id -> new LinkedList()));
        this.addMatch(match, queue);
    }

    private void addMatch(VolcanoRuleMatch match, List<VolcanoRuleMatch> queue) {
        if (!this.names.add(match.toString())) {
            return;
        }
        if (!this.planner.isSubstituteRule(match)) {
            queue.add(0, match);
        } else {
            queue.add(match);
        }
    }

    public VolcanoRuleMatch popMatch(Pair<RelNode, Predicate<VolcanoRuleMatch>> category) {
        List<VolcanoRuleMatch> queue = this.matches.get(category.left);
        if (queue == null) {
            return null;
        }
        Iterator<VolcanoRuleMatch> iterator = queue.iterator();
        while (iterator.hasNext()) {
            VolcanoRuleMatch next = iterator.next();
            if (category.right != null && !((Predicate)category.right).test(next)) continue;
            iterator.remove();
            if (this.skipMatch(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean clear() {
        boolean empty = this.matches.isEmpty();
        this.matches.clear();
        this.names.clear();
        return !empty;
    }
}

