/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.volcano;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.HashMultimap;
import org.apache.hive.druid.com.google.common.collect.Multimap;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.hive.druid.org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class IterativeRuleQueue
extends RuleQueue {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    final MatchList matchList = new MatchList();

    IterativeRuleQueue(VolcanoPlanner planner) {
        super(planner);
    }

    @Override
    public boolean clear() {
        boolean empty = true;
        if (!this.matchList.queue.isEmpty() || !this.matchList.preQueue.isEmpty()) {
            empty = false;
        }
        this.matchList.clear();
        return !empty;
    }

    @Override
    public void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        if (!this.matchList.names.add(matchName)) {
            return;
        }
        LOGGER.trace("Rule-match queued: {}", (Object)matchName);
        this.matchList.offer(match);
        this.matchList.matchMap.put(this.planner.getSubset(match.rels[0]), match);
    }

    public VolcanoRuleMatch popMatch() {
        VolcanoRuleMatch match;
        this.dumpPlannerState();
        while (true) {
            if (this.matchList.size() == 0) {
                return null;
            }
            this.dumpRuleQueue(this.matchList);
            match = this.matchList.poll();
            if (!this.skipMatch(match)) break;
            LOGGER.debug("Skip match: {}", (Object)match);
        }
        this.matchList.matchMap.remove(this.planner.getSubset(match.rels[0]), match);
        LOGGER.debug("Pop match: {}", (Object)match);
        return match;
    }

    private void dumpRuleQueue(MatchList matchList) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append("Rule queue:");
            for (VolcanoRuleMatch rule : matchList.preQueue) {
                b.append("\n");
                b.append(rule);
            }
            for (VolcanoRuleMatch rule : matchList.queue) {
                b.append("\n");
                b.append(rule);
            }
            LOGGER.trace(b.toString());
        }
    }

    private void dumpPlannerState() {
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.planner.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
            this.planner.getRoot().getCluster().invalidateMetadataQuery();
        }
    }

    private static class MatchList {
        private final Queue<VolcanoRuleMatch> preQueue = new LinkedList<VolcanoRuleMatch>();
        private final Queue<VolcanoRuleMatch> queue = new LinkedList<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        private MatchList() {
        }

        int size() {
            return this.preQueue.size() + this.queue.size();
        }

        VolcanoRuleMatch poll() {
            VolcanoRuleMatch match = this.preQueue.poll();
            if (match == null) {
                match = this.queue.poll();
            }
            return match;
        }

        void offer(VolcanoRuleMatch match) {
            if (match.getRule() instanceof SubstitutionRule) {
                this.preQueue.offer(match);
            } else {
                this.queue.offer(match);
            }
        }

        void clear() {
            this.preQueue.clear();
            this.queue.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }
}

