/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.materialize.CachingLatticeStatisticProvider;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.hive.druid.org.apache.calcite.materialize.MaterializationService;
import org.apache.hive.druid.org.apache.calcite.schema.ScannableTable;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;

class SqlLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = SqlLatticeStatisticProvider::new;
    static final LatticeStatisticProvider.Factory CACHED_FACTORY = lattice -> {
        LatticeStatisticProvider provider = (LatticeStatisticProvider)FACTORY.apply(lattice);
        return new CachingLatticeStatisticProvider((Lattice)lattice, provider);
    };
    private final Lattice lattice;

    private SqlLatticeStatisticProvider(Lattice lattice) {
        this.lattice = Objects.requireNonNull(lattice);
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            counts.add(this.cardinality(this.lattice, column));
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }

    private double cardinality(Lattice lattice, Lattice.Column column) {
        String sql = lattice.countSql(ImmutableBitSet.of(column.ordinal));
        Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, ImmutableList.of());
        Object[] values = Iterables.getOnlyElement(((ScannableTable)table).scan(null));
        return ((Number)values[0]).doubleValue();
    }
}

