/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.materialize.LatticeRootNode;
import org.apache.hive.druid.org.apache.calcite.materialize.LatticeTable;
import org.apache.hive.druid.org.apache.calcite.materialize.Path;
import org.apache.hive.druid.org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.hive.druid.org.apache.calcite.materialize.Step;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.graph.AttributedDirectedGraph;
import org.apache.hive.druid.org.apache.calcite.util.mapping.IntPair;

class LatticeSpace {
    final SqlStatisticProvider statisticProvider;
    private final Map<List<String>, LatticeTable> tableMap = new HashMap<List<String>, LatticeTable>();
    final AttributedDirectedGraph<LatticeTable, Step> g = new AttributedDirectedGraph<LatticeTable, Step>(new Step.Factory(this));
    private final Map<List<String>, String> simpleTableNames = new HashMap<List<String>, String>();
    private final Set<String> simpleNames = new HashSet<String>();
    final Map<String, LatticeRootNode> nodeMap = new HashMap<String, LatticeRootNode>();
    final Map<ImmutableList<Step>, Path> pathMap = new HashMap<ImmutableList<Step>, Path>();
    final Map<LatticeTable, List<RexNode>> tableExpressions = new HashMap<LatticeTable, List<RexNode>>();

    LatticeSpace(SqlStatisticProvider statisticProvider) {
        this.statisticProvider = Objects.requireNonNull(statisticProvider);
    }

    String simpleName(LatticeTable table) {
        return this.simpleName(table.t.getQualifiedName());
    }

    String simpleName(RelOptTable table) {
        return this.simpleName(table.getQualifiedName());
    }

    String simpleName(List<String> table) {
        String name = this.simpleTableNames.get(table);
        if (name != null) {
            return name;
        }
        String name2 = Util.last(table);
        if (this.simpleNames.add(name2)) {
            this.simpleTableNames.put(ImmutableList.copyOf(table), name2);
            return name2;
        }
        String name3 = table.toString();
        this.simpleTableNames.put(ImmutableList.copyOf(table), name3);
        return name3;
    }

    LatticeTable register(RelOptTable t) {
        LatticeTable table = this.tableMap.get(t.getQualifiedName());
        if (table != null) {
            return table;
        }
        LatticeTable table2 = new LatticeTable(t);
        this.tableMap.put(t.getQualifiedName(), table2);
        this.g.addVertex(table2);
        return table2;
    }

    Step addEdge(LatticeTable source, LatticeTable target, List<IntPair> keys) {
        keys = LatticeSpace.sortUnique(keys);
        Step step = this.g.addEdge(source, target, keys);
        if (step != null) {
            return step;
        }
        for (Step step2 : this.g.getEdges(source, target)) {
            if (!step2.keys.equals(keys)) continue;
            return step2;
        }
        throw new AssertionError((Object)"addEdge failed, yet no edge present");
    }

    static List<IntPair> sortUnique(List<IntPair> keys) {
        if (keys.size() > 1 && !IntPair.ORDERING.isStrictlyOrdered(keys = IntPair.ORDERING.immutableSortedCopy(keys))) {
            TreeSet<IntPair> set = new TreeSet<IntPair>(IntPair.ORDERING);
            set.addAll(keys);
            keys = ImmutableList.copyOf(set);
        }
        return keys;
    }

    static List<IntPair> swap(List<IntPair> keys) {
        return LatticeSpace.sortUnique(Lists.transform(keys, IntPair.SWAP));
    }

    Path addPath(List<Step> steps) {
        ImmutableList<Step> key = ImmutableList.copyOf(steps);
        Path path = this.pathMap.get(key);
        if (path != null) {
            return path;
        }
        Path path2 = new Path(key, this.pathMap.size());
        this.pathMap.put(key, path2);
        return path2;
    }

    int registerExpression(LatticeTable table, RexNode e) {
        List expressions = this.tableExpressions.computeIfAbsent(table, t -> new ArrayList());
        int fieldCount = table.t.getRowType().getFieldCount();
        for (int i = 0; i < expressions.size(); ++i) {
            if (!((RexNode)expressions.get(i)).toString().equals(e.toString())) continue;
            return fieldCount + i;
        }
        int result = fieldCount + expressions.size();
        expressions.add(e);
        return result;
    }

    public String fieldName(LatticeTable table, int field) {
        List<RelDataTypeField> fieldList = table.t.getRowType().getFieldList();
        int fieldCount = fieldList.size();
        if (field < fieldCount) {
            return fieldList.get(field).getName();
        }
        return this.tableExpressions.get(table).get(field - fieldCount).toString();
    }
}

