/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.hive.druid.org.apache.calcite.util.Util;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final Lattice lattice;
    private final LoadingCache<Lattice.Column, Double> cache;

    CachingLatticeStatisticProvider(Lattice lattice, LatticeStatisticProvider provider) {
        this.lattice = lattice;
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(key -> provider.cardinality(ImmutableList.of(key))));
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            try {
                counts.add(this.cache.get(column));
            }
            catch (ExecutionException | UncheckedExecutionException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }
}

