/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.jdbc;

import java.sql.SQLException;
import org.apache.hive.druid.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.hive.druid.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.hive.druid.org.apache.calcite.avatica.Meta;
import org.apache.hive.druid.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.hive.druid.org.apache.calcite.linq4j.Queryable;
import org.apache.hive.druid.org.apache.calcite.server.CalciteServerStatement;

public abstract class CalciteStatement
extends AvaticaStatement {
    CalciteStatement(CalciteConnectionImpl connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super((AvaticaConnection)connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == CalciteServerStatement.class) {
            CalciteServerStatement statement;
            try {
                statement = this.getConnection().server.getStatement(this.handle);
            }
            catch (NoSuchStatementException e) {
                throw new AssertionError("invalid statement", e);
            }
            return iface.cast(statement);
        }
        return (T)super.unwrap(iface);
    }

    public CalciteConnectionImpl getConnection() {
        return (CalciteConnectionImpl)this.connection;
    }

    protected <T> CalcitePrepare.CalciteSignature<T> prepare(Queryable<T> queryable) {
        CalciteServerStatement serverStatement;
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalcitePrepare prepare = calciteConnection.prepareFactory.apply();
        try {
            serverStatement = calciteConnection.server.getStatement(this.handle);
        }
        catch (NoSuchStatementException e) {
            throw new AssertionError("invalid statement", e);
        }
        CalcitePrepare.Context prepareContext = serverStatement.createPrepareContext();
        return prepare.prepareQueryable(prepareContext, queryable);
    }

    protected void close_() {
        if (!this.closed) {
            ((CalciteConnectionImpl)this.connection).server.removeStatement(this.handle);
            super.close_();
        }
    }
}

