/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalUnion;

class EnumerableUnionRule
extends ConverterRule {
    static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalUnion.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUnionRule").withRuleFactory(EnumerableUnionRule::new);

    protected EnumerableUnionRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalUnion union = (LogicalUnion)rel;
        EnumerableConvention out = EnumerableConvention.INSTANCE;
        RelTraitSet traitSet = rel.getCluster().traitSet().replace(out);
        List<RelNode> newInputs = Lists.transform(union.getInputs(), n -> EnumerableUnionRule.convert(n, traitSet));
        return new EnumerableUnion(rel.getCluster(), traitSet, newInputs, union.all);
    }
}

