/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinInfo;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;

class EnumerableMergeJoinRule
extends ConverterRule {
    static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableMergeJoinRule").withRuleFactory(EnumerableMergeJoinRule::new);

    protected EnumerableMergeJoinRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        RexNode condition;
        LogicalJoin join = (LogicalJoin)rel;
        JoinInfo info = join.analyzeCondition();
        if (!EnumerableMergeJoin.isMergeJoinSupported(join.getJoinType())) {
            return null;
        }
        if (info.pairs().size() == 0) {
            return null;
        }
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<RelCollation> collations = new ArrayList<RelCollation>();
        int offset = 0;
        for (Ord<RelNode> ord : Ord.zip(join.getInputs())) {
            RelTraitSet traits = ((RelNode)ord.e).getTraitSet().replace(EnumerableConvention.INSTANCE);
            if (!info.pairs().isEmpty()) {
                ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
                for (int key : info.keys().get(ord.i)) {
                    fieldCollations.add(new RelFieldCollation(key, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
                }
                RelCollation collation = RelCollations.of(fieldCollations);
                collations.add(RelCollations.shift(collation, offset));
                traits = traits.replace(collation);
            }
            newInputs.add(EnumerableMergeJoinRule.convert((RelNode)ord.e, traits));
            offset += ((RelNode)ord.e).getRowType().getFieldCount();
        }
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        RelOptCluster cluster = join.getCluster();
        RelTraitSet traitSet = join.getTraitSet().replace(EnumerableConvention.INSTANCE);
        if (!collations.isEmpty()) {
            traitSet = traitSet.replace(collations);
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RexNode equi = info.getEquiCondition(left, right, rexBuilder);
        if (info.isEqui()) {
            condition = equi;
        } else {
            RexNode nonEqui = RexUtil.composeConjunction(rexBuilder, info.nonEquiConditions);
            condition = RexUtil.composeConjunction(rexBuilder, Arrays.asList(equi, nonEqui));
        }
        EnumerableMergeJoin newRel = new EnumerableMergeJoin(cluster, traitSet, left, right, condition, join.getVariablesSet(), join.getJoinType());
        return newRel;
    }
}

