/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableHashJoin;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinInfo;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;

class EnumerableJoinRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule").withRuleFactory(EnumerableJoinRule::new);

    protected EnumerableJoinRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        boolean hasEquiKeys;
        LogicalJoin join = (LogicalJoin)rel;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : join.getInputs()) {
            if (!(input.getConvention() instanceof EnumerableConvention)) {
                input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            }
            newInputs.add(input);
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        JoinInfo info = join.analyzeCondition();
        boolean bl = hasEquiKeys = !info.leftKeys.isEmpty() && !info.rightKeys.isEmpty();
        if (hasEquiKeys) {
            RexNode condition;
            RexNode equi = info.getEquiCondition(left, right, rexBuilder);
            if (info.isEqui()) {
                condition = equi;
            } else {
                RexNode nonEqui = RexUtil.composeConjunction(rexBuilder, info.nonEquiConditions);
                condition = RexUtil.composeConjunction(rexBuilder, Arrays.asList(equi, nonEqui));
            }
            return EnumerableHashJoin.create(left, right, condition, join.getVariablesSet(), join.getJoinType());
        }
        return EnumerableNestedLoopJoin.create(left, right, join.getCondition(), join.getVariablesSet(), join.getJoinType());
    }
}

