/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.plan.DeriveMode;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelNodes;
import org.apache.hive.druid.org.apache.calcite.rel.core.CorrelationId;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class EnumerableHashJoin
extends Join
implements EnumerableRel {
    protected EnumerableHashJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, ImmutableList.of(), left, right, condition, variablesSet, joinType);
    }

    @Deprecated
    protected EnumerableHashJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, traits, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
    }

    public static EnumerableHashJoin create(RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.enumerableHashJoin(mq, left, right, joinType));
        return new EnumerableHashJoin(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public EnumerableHashJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new EnumerableHashJoin(this.getCluster(), traitSet, left, right, condition, this.variablesSet, joinType);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return EnumerableTraitsUtils.passThroughTraitsForJoin(required, this.joinType, this.left.getRowType().getFieldCount(), this.getTraitSet());
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        return EnumerableTraitsUtils.deriveTraitsForJoin(childTraits, childId, this.joinType, this.getTraitSet(), this.right.getTraitSet());
    }

    @Override
    public DeriveMode getDeriveMode() {
        if (this.joinType == JoinRelType.FULL || this.joinType == JoinRelType.RIGHT) {
            return DeriveMode.PROHIBITED;
        }
        return DeriveMode.LEFT_FIRST;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        switch (this.joinType) {
            case SEMI: 
            case ANTI: {
                break;
            }
            case RIGHT: {
                rowCount = RelMdUtil.addEpsilon(rowCount);
                break;
            }
            default: {
                if (RelNodes.COMPARATOR.compare(this.left, this.right) <= 0) break;
                rowCount = RelMdUtil.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
        rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
        if (this.isSemiJoin()) {
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0).multiplyBy(0.01);
        }
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        switch (this.joinType) {
            case SEMI: 
            case ANTI: {
                return this.implementHashSemiJoin(implementor, pref);
            }
        }
        return this.implementHashJoin(implementor, pref);
    }

    private EnumerableRel.Result implementHashSemiJoin(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        RexNode nonEquiCondition;
        assert (this.joinType == JoinRelType.SEMI || this.joinType == JoinRelType.ANTI);
        Method method = this.joinType == JoinRelType.SEMI ? BuiltInMethod.SEMI_JOIN.method : BuiltInMethod.ANTI_JOIN.method;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = leftResult.physType;
        PhysType keyPhysType = leftResult.physType.project(this.joinInfo.leftKeys, JavaRowFormat.LIST);
        Expression predicate = Expressions.constant(null);
        if (!this.joinInfo.nonEquiConditions.isEmpty() && (nonEquiCondition = RexUtil.composeConjunction(this.getCluster().getRexBuilder(), this.joinInfo.nonEquiConditions, true)) != null) {
            predicate = EnumUtils.generatePredicate(implementor, this.getCluster().getRexBuilder(), this.left, this.right, leftResult.physType, rightResult.physType, nonEquiCondition);
        }
        return implementor.result(physType, builder.append(Expressions.call(method, Expressions.list(leftExpression, rightExpression, leftResult.physType.generateAccessor(this.joinInfo.leftKeys), rightResult.physType.generateAccessor(this.joinInfo.rightKeys), Util.first(keyPhysType.comparer(), Expressions.constant(null)), predicate))).toBlock());
    }

    private EnumerableRel.Result implementHashJoin(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        RexNode nonEquiCondition;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        PhysType keyPhysType = leftResult.physType.project(this.joinInfo.leftKeys, JavaRowFormat.LIST);
        Expression predicate = Expressions.constant(null);
        if (!this.joinInfo.nonEquiConditions.isEmpty() && (nonEquiCondition = RexUtil.composeConjunction(this.getCluster().getRexBuilder(), this.joinInfo.nonEquiConditions, true)) != null) {
            predicate = EnumUtils.generatePredicate(implementor, this.getCluster().getRexBuilder(), this.left, this.right, leftResult.physType, rightResult.physType, nonEquiCondition);
        }
        return implementor.result(physType, builder.append(Expressions.call(leftExpression, BuiltInMethod.HASH_JOIN.method, Expressions.list(rightExpression, leftResult.physType.generateAccessor(this.joinInfo.leftKeys), rightResult.physType.generateAccessor(this.joinInfo.rightKeys), EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType))).append(Util.first(keyPhysType.comparer(), Expressions.constant(null))).append(Expressions.constant(this.joinType.generatesNullsOnLeft())).append(Expressions.constant(this.joinType.generatesNullsOnRight())).append(predicate))).toBlock());
    }
}

