/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

public class EnumerableFilter
extends Filter
implements EnumerableRel {
    public EnumerableFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() instanceof EnumerableConvention);
    }

    public static EnumerableFilter create(RelNode input, RexNode condition) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.filter(mq, input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.filter(mq, input));
        return new EnumerableFilter(cluster, traitSet, input, condition);
    }

    @Override
    public EnumerableFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new EnumerableFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        Object collation = required.getCollation();
        if (collation == null || collation == RelCollations.EMPTY) {
            return null;
        }
        RelTraitSet traits = this.traitSet.replace((RelTrait)collation);
        return Pair.of(traits, ImmutableList.of(traits));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        Object collation = childTraits.getCollation();
        if (collation == null || collation == RelCollations.EMPTY) {
            return null;
        }
        RelTraitSet traits = this.traitSet.replace((RelTrait)collation);
        return Pair.of(traits, ImmutableList.of(traits));
    }
}

