/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;

public class DruidSchema
extends AbstractSchema {
    final String url;
    final String coordinatorUrl;
    private final boolean discoverTables;
    private Map<String, Table> tableMap = null;

    public DruidSchema(String url, String coordinatorUrl, boolean discoverTables) {
        this.url = Objects.requireNonNull(url);
        this.coordinatorUrl = Objects.requireNonNull(coordinatorUrl);
        this.discoverTables = discoverTables;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        if (!this.discoverTables) {
            return ImmutableMap.of();
        }
        if (this.tableMap == null) {
            DruidConnectionImpl connection = new DruidConnectionImpl(this.url, this.coordinatorUrl);
            Set<String> tableNames = connection.tableNames();
            this.tableMap = Maps.asMap(ImmutableSet.copyOf(tableNames), CacheBuilder.newBuilder().build(CacheLoader.from(name -> this.table((String)name, connection))));
        }
        return this.tableMap;
    }

    private Table table(String tableName, DruidConnectionImpl connection) {
        LinkedHashMap<String, SqlTypeName> fieldMap = new LinkedHashMap<String, SqlTypeName>();
        LinkedHashSet<String> metricNameSet = new LinkedHashSet<String>();
        HashMap<String, List<ComplexMetric>> complexMetrics = new HashMap<String, List<ComplexMetric>>();
        connection.metadata(tableName, "__time", null, fieldMap, metricNameSet, complexMetrics);
        return DruidTable.create(this, tableName, null, fieldMap, metricNameSet, "__time", complexMetrics);
    }
}

