/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.calcite.DataContext;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.BinaryOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.CeilOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DirectOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidJson;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidJsonFilter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidRules;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlCastConverter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ExtractOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.FloorOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularities;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularity;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.NaryOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.QueryType;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.SubstringOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.UnaryPrefixOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.UnarySuffixOperatorConversion;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.VirtualColumn;
import org.apache.hive.druid.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.hive.druid.org.apache.calcite.interpreter.BindableRel;
import org.apache.hive.druid.org.apache.calcite.interpreter.Bindables;
import org.apache.hive.druid.org.apache.calcite.interpreter.Compiler;
import org.apache.hive.druid.org.apache.calcite.interpreter.InterpretableRel;
import org.apache.hive.druid.org.apache.calcite.interpreter.Node;
import org.apache.hive.druid.org.apache.calcite.interpreter.Sink;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.AbstractRelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelWriter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.runtime.Hook;
import org.apache.hive.druid.org.apache.calcite.schema.ScannableTable;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Litmus;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.joda.time.Interval;

public class DruidQuery
extends AbstractRelNode
implements BindableRel {
    public static final List<DruidSqlOperatorConverter> DEFAULT_OPERATORS_LIST = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new DirectOperatorConversion(SqlStdOperatorTable.EXP, "exp"))).add(new DirectOperatorConversion(SqlStdOperatorTable.CONCAT, "concat"))).add(new DirectOperatorConversion(SqlStdOperatorTable.DIVIDE_INTEGER, "div"))).add(new DirectOperatorConversion(SqlStdOperatorTable.LIKE, "like"))).add(new DirectOperatorConversion(SqlStdOperatorTable.LN, "log"))).add(new DirectOperatorConversion(SqlStdOperatorTable.SQRT, "sqrt"))).add(new DirectOperatorConversion(SqlStdOperatorTable.LOWER, "lower"))).add(new DirectOperatorConversion(SqlStdOperatorTable.LOG10, "log10"))).add(new DirectOperatorConversion(SqlStdOperatorTable.REPLACE, "replace"))).add(new DirectOperatorConversion(SqlStdOperatorTable.UPPER, "upper"))).add(new DirectOperatorConversion(SqlStdOperatorTable.POWER, "pow"))).add(new DirectOperatorConversion(SqlStdOperatorTable.ABS, "abs"))).add(new DirectOperatorConversion(SqlStdOperatorTable.SIN, "sin"))).add(new DirectOperatorConversion(SqlStdOperatorTable.COS, "cos"))).add(new DirectOperatorConversion(SqlStdOperatorTable.TAN, "tan"))).add(new DirectOperatorConversion(SqlStdOperatorTable.CASE, "case_searched"))).add(new DirectOperatorConversion(SqlStdOperatorTable.CHAR_LENGTH, "strlen"))).add(new DirectOperatorConversion(SqlStdOperatorTable.CHARACTER_LENGTH, "strlen"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.EQUALS, "=="))).add(new BinaryOperatorConversion(SqlStdOperatorTable.NOT_EQUALS, "!="))).add(new NaryOperatorConverter(SqlStdOperatorTable.OR, "||"))).add(new NaryOperatorConverter(SqlStdOperatorTable.AND, "&&"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.LESS_THAN, "<"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "<="))).add(new BinaryOperatorConversion(SqlStdOperatorTable.GREATER_THAN, ">"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ">="))).add(new BinaryOperatorConversion(SqlStdOperatorTable.PLUS, "+"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.MINUS, "-"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.MULTIPLY, "*"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.DIVIDE, "/"))).add(new BinaryOperatorConversion(SqlStdOperatorTable.MOD, "%"))).add(new DruidSqlCastConverter())).add(new ExtractOperatorConversion())).add(new UnaryPrefixOperatorConversion(SqlStdOperatorTable.NOT, "!"))).add(new UnaryPrefixOperatorConversion(SqlStdOperatorTable.UNARY_MINUS, "-"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_FALSE, "<= 0"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_NOT_TRUE, "<= 0"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_TRUE, "> 0"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_NOT_FALSE, "> 0"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_NULL, "== null"))).add(new UnarySuffixOperatorConversion(SqlStdOperatorTable.IS_NOT_NULL, "!= null"))).add(new FloorOperatorConversion())).add(new CeilOperatorConversion())).add(new SubstringOperatorConversion())).build();
    protected QuerySpec querySpec;
    final RelOptTable table;
    final DruidTable druidTable;
    final ImmutableList<Interval> intervals;
    final ImmutableList<RelNode> rels;
    final Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap;
    private static final Pattern VALID_SIG = Pattern.compile("sf?p?(a?|ah|ah?o)l?");
    private static final String EXTRACT_COLUMN_NAME_PREFIX = "extract";
    private static final String FLOOR_COLUMN_NAME_PREFIX = "floor";
    protected static final String DRUID_QUERY_FETCH = "druid.query.fetch";
    private static final int DAYS_IN_TEN_YEARS = 3650;

    protected DruidQuery(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        super(cluster, traitSet);
        this.table = table;
        this.druidTable = druidTable;
        this.intervals = ImmutableList.copyOf(intervals);
        this.rels = ImmutableList.copyOf(rels);
        this.converterOperatorMap = Objects.requireNonNull(converterOperatorMap, "Operator map cannot be null");
        assert (this.isValid(Litmus.THROW, null));
    }

    static boolean isValidSignature(String signature) {
        return VALID_SIG.matcher(signature).matches();
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels) {
        ImmutableMap.Builder<SqlOperator, DruidSqlOperatorConverter> mapBuilder = ImmutableMap.builder();
        for (DruidSqlOperatorConverter converter : DEFAULT_OPERATORS_LIST) {
            mapBuilder.put(converter.calciteOperator(), converter);
        }
        return DruidQuery.create(cluster, traitSet, table, druidTable, druidTable.intervals, rels, mapBuilder.build());
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        return DruidQuery.create(cluster, traitSet, table, druidTable, druidTable.intervals, rels, converterOperatorMap);
    }

    private static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        return new DruidQuery(cluster, traitSet, table, druidTable, intervals, rels, converterOperatorMap);
    }

    public static DruidQuery extendQuery(DruidQuery query, RelNode r) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return DruidQuery.create(query.getCluster(), r.getTraitSet().replace(query.getConvention()), query.getTable(), query.druidTable, query.intervals, (List<RelNode>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(query.rels)).add(r)).build()), query.getOperatorConversionMap());
    }

    public static DruidQuery extendQuery(DruidQuery query, List<Interval> intervals) {
        return DruidQuery.create(query.getCluster(), query.getTraitSet(), query.getTable(), query.druidTable, intervals, query.rels, query.getOperatorConversionMap());
    }

    private static boolean needUtcTimeExtract(RexNode rexNode) {
        return rexNode.getType().getSqlTypeName() == SqlTypeName.DATE || rexNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP || rexNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    }

    protected static Pair<String, ExtractionFunction> toDruidColumn(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        TimeExtractionFunction extractionFunction;
        String columnName;
        switch (rexNode.getKind()) {
            case INPUT_REF: {
                columnName = DruidQuery.extractColumnName(rexNode, rowType, druidQuery);
                if (DruidQuery.needUtcTimeExtract(rexNode)) {
                    extractionFunction = TimeExtractionFunction.createDefault(DateTimeUtils.UTC_ZONE.getID());
                    break;
                }
                extractionFunction = null;
                break;
            }
            case EXTRACT: {
                Granularity granularity = DruidDateTimeUtils.extractGranularity(rexNode, druidQuery.getConnectionConfig().timeZone());
                if (granularity == null) {
                    return Pair.of(null, null);
                }
                if (!TimeExtractionFunction.isValidTimeExtract((RexCall)rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode extractValueNode = ((RexCall)rexNode).getOperands().get(1);
                if (extractValueNode.getType().getSqlTypeName() == SqlTypeName.DATE || extractValueNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP) {
                    extractionFunction = TimeExtractionFunction.createExtractFromGranularity(granularity, DateTimeUtils.UTC_ZONE.getID());
                    columnName = DruidQuery.extractColumnName(extractValueNode, rowType, druidQuery);
                    break;
                }
                if (extractValueNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                    extractionFunction = TimeExtractionFunction.createExtractFromGranularity(granularity, druidQuery.getConnectionConfig().timeZone());
                    columnName = DruidQuery.extractColumnName(extractValueNode, rowType, druidQuery);
                    break;
                }
                return Pair.of(null, null);
            }
            case FLOOR: {
                Granularity granularity = DruidDateTimeUtils.extractGranularity(rexNode, druidQuery.getConnectionConfig().timeZone());
                if (granularity == null) {
                    return Pair.of(null, null);
                }
                if (!TimeExtractionFunction.isValidTimeFloor((RexCall)rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode floorValueNode = ((RexCall)rexNode).getOperands().get(0);
                if (DruidQuery.needUtcTimeExtract(floorValueNode)) {
                    extractionFunction = TimeExtractionFunction.createFloorFromGranularity(granularity, DateTimeUtils.UTC_ZONE.getID());
                    columnName = DruidQuery.extractColumnName(floorValueNode, rowType, druidQuery);
                    break;
                }
                return Pair.of(null, null);
            }
            case CAST: {
                if (!DruidQuery.isValidLeafCast(rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode operand0 = ((RexCall)rexNode).getOperands().get(0);
                columnName = DruidQuery.extractColumnName(operand0, rowType, druidQuery);
                if (DruidQuery.needUtcTimeExtract(rexNode)) {
                    extractionFunction = TimeExtractionFunction.translateCastToTimeExtract(rexNode, TimeZone.getTimeZone(druidQuery.getConnectionConfig().timeZone()));
                    if (extractionFunction != null) break;
                    return Pair.of(null, null);
                }
                extractionFunction = null;
                break;
            }
            default: {
                return Pair.of(null, null);
            }
        }
        return Pair.of(columnName, extractionFunction);
    }

    private static boolean isValidLeafCast(RexNode rexNode) {
        assert (rexNode.isA(SqlKind.CAST));
        RexNode input = ((RexCall)rexNode).getOperands().get(0);
        if (!input.isA(SqlKind.INPUT_REF)) {
            return false;
        }
        SqlTypeName toTypeName = rexNode.getType().getSqlTypeName();
        if (toTypeName.getFamily() == SqlTypeFamily.CHARACTER) {
            return true;
        }
        if (toTypeName.getFamily() == SqlTypeFamily.NUMERIC) {
            return true;
        }
        if (toTypeName.getFamily() == SqlTypeFamily.TIMESTAMP || toTypeName.getFamily() == SqlTypeFamily.DATETIME) {
            return true;
        }
        return toTypeName.getFamily().contains(input.getType());
    }

    @Nullable
    protected static String extractColumnName(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        if (rexNode.getKind() == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = rowType.getFieldNames().get(ref.getIndex());
            if (columnName == null) {
                return null;
            }
            if (query.getDruidTable().timestampFieldName.equals(columnName)) {
                return "__time";
            }
            return columnName;
        }
        return null;
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    String signature() {
        StringBuilder b = new StringBuilder();
        boolean flag = false;
        for (RelNode rel : this.rels) {
            b.append((char)(rel instanceof TableScan ? 115 : (rel instanceof Project && flag ? 111 : (rel instanceof Filter && flag ? 104 : (rel instanceof Aggregate ? 97 : (rel instanceof Filter ? 102 : (rel instanceof Sort ? 108 : (rel instanceof Project ? 112 : 33))))))));
            flag = flag || rel instanceof Aggregate;
        }
        return b.toString();
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!super.isValid(litmus, context)) {
            return false;
        }
        String signature = this.signature();
        if (!DruidQuery.isValidSignature(signature)) {
            return litmus.fail("invalid signature [{}]", signature);
        }
        if (this.rels.isEmpty()) {
            return litmus.fail("must have at least one rel", new Object[0]);
        }
        for (int i = 0; i < this.rels.size(); ++i) {
            Filter filter;
            DruidJsonFilter druidJsonFilter;
            Aggregate aggregate;
            RelNode r = (RelNode)this.rels.get(i);
            if (i == 0) {
                if (!(r instanceof TableScan)) {
                    return litmus.fail("first rel must be TableScan, was ", r);
                }
                if (r.getTable() == this.table) continue;
                return litmus.fail("first rel must be based on table table", new Object[0]);
            }
            List<RelNode> inputs = r.getInputs();
            if (inputs.size() != 1 || inputs.get(0) != this.rels.get(i - 1)) {
                return litmus.fail("each rel must have a single input", new Object[0]);
            }
            if (r instanceof Aggregate && (aggregate = (Aggregate)r).getGroupSets().size() != 1) {
                return litmus.fail("no grouping sets", new Object[0]);
            }
            if (r instanceof Filter && (druidJsonFilter = DruidJsonFilter.toDruidFilters((filter = (Filter)r).getCondition(), filter.getInput().getRowType(), this)) == null) {
                return litmus.fail("invalid filter [{}]", filter.getCondition());
            }
            if (!(r instanceof Sort)) continue;
            Sort sort = (Sort)r;
            if (sort.offset == null || RexLiteral.intValue(sort.offset) == 0) continue;
            return litmus.fail("offset not supported", new Object[0]);
        }
        return true;
    }

    protected Map<SqlOperator, DruidSqlOperatorConverter> getOperatorConversionMap() {
        return this.converterOperatorMap;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createStructType(Pair.right(Util.last(this.rels).getRowType().getFieldList()), this.getQuerySpec().fieldNames);
    }

    public TableScan getTableScan() {
        return (TableScan)this.rels.get(0);
    }

    public RelNode getTopNode() {
        return Util.last(this.rels);
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        for (RelNode rel : this.rels) {
            if (rel instanceof TableScan) {
                TableScan tableScan = (TableScan)rel;
                pw.item("table", tableScan.getTable().getQualifiedName());
                pw.item("intervals", this.intervals);
                continue;
            }
            if (rel instanceof Filter) {
                pw.item("filter", ((Filter)rel).getCondition());
                continue;
            }
            if (rel instanceof Project) {
                if (((Project)rel).getInput() instanceof Aggregate) {
                    pw.item("post_projects", ((Project)rel).getProjects());
                    continue;
                }
                pw.item("projects", ((Project)rel).getProjects());
                continue;
            }
            if (rel instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)rel;
                pw.item("groups", aggregate.getGroupSet()).item("aggs", aggregate.getAggCallList());
                continue;
            }
            if (rel instanceof Sort) {
                Sort sort = (Sort)rel;
                for (Ord<RelFieldCollation> ord : Ord.zip(sort.collation.getFieldCollations())) {
                    pw.item("sort" + ord.i, ((RelFieldCollation)ord.e).getFieldIndex());
                }
                for (Ord<RelFieldCollation> ord : Ord.zip(sort.collation.getFieldCollations())) {
                    pw.item("dir" + ord.i, ((RelFieldCollation)ord.e).shortString());
                }
                pw.itemIf("fetch", sort.fetch, sort.fetch != null);
                continue;
            }
            throw new AssertionError((Object)("rel type not supported in Druid query " + rel));
        }
        return pw;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return Util.last(this.rels).computeSelfCost(planner, mq).multiplyBy(RelMdUtil.linear(this.querySpec.fieldNames.size(), 2, 100, 1.0, 2.0)).multiplyBy(this.getQueryTypeCostMultiplier()).multiplyBy(this.rels.size() > 1 && this.rels.get(1) instanceof Filter ? 0.5 : 1.0).multiplyBy(Util.last(this.rels) instanceof Sort ? 0.1 : 1.0).multiplyBy(this.getIntervalCostMultiplier());
    }

    private double getIntervalCostMultiplier() {
        int days = 0;
        for (Interval interval : this.intervals) {
            days = (int)((long)days + interval.toDuration().getStandardDays());
        }
        return RelMdUtil.linear(days, 1, 3650, 0.1, 1.0);
    }

    private double getQueryTypeCostMultiplier() {
        switch (this.querySpec.queryType) {
            case SELECT: {
                return 0.1;
            }
            case GROUP_BY: {
                return 0.08;
            }
            case TIMESERIES: {
                return 0.06;
            }
            case TOP_N: {
                return 0.04;
            }
        }
        return 0.2;
    }

    @Override
    public void register(RelOptPlanner planner) {
        for (RelOptRule rule : DruidRules.RULES) {
            planner.addRule(rule);
        }
        for (RelOptRule rule : Bindables.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<Object[]> bind(DataContext dataContext) {
        return this.table.unwrap(ScannableTable.class).scan(dataContext);
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        return new DruidQueryNode(implementor.compiler, this);
    }

    public QuerySpec getQuerySpec() {
        if (this.querySpec == null) {
            this.querySpec = this.deriveQuerySpec();
            assert (this.querySpec != null) : this;
        }
        return this.querySpec;
    }

    protected QuerySpec deriveQuerySpec() {
        RelDataType rowType = this.table.getRowType();
        int i = 1;
        Filter filterRel = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            filterRel = (Filter)this.rels.get(i++);
        }
        Project project = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            project = (Project)this.rels.get(i++);
        }
        ImmutableBitSet groupSet = null;
        List<AggregateCall> aggCalls = null;
        List<String> aggNames = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)this.rels.get(i++);
            groupSet = aggregate.getGroupSet();
            aggCalls = aggregate.getAggCallList();
            aggNames = Util.skip(aggregate.getRowType().getFieldNames(), groupSet.cardinality());
        }
        Filter havingFilter = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            havingFilter = (Filter)this.rels.get(i++);
        }
        Project postProject = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            postProject = (Project)this.rels.get(i++);
        }
        ArrayList<Integer> collationIndexes = null;
        ArrayList<RelFieldCollation.Direction> collationDirections = null;
        ImmutableBitSet.Builder numericCollationBitSetBuilder = ImmutableBitSet.builder();
        Integer fetch = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Sort) {
            Sort sort = (Sort)this.rels.get(i++);
            collationIndexes = new ArrayList<Integer>();
            collationDirections = new ArrayList<RelFieldCollation.Direction>();
            for (RelFieldCollation fCol : sort.collation.getFieldCollations()) {
                collationIndexes.add(fCol.getFieldIndex());
                collationDirections.add(fCol.getDirection());
                if (sort.getRowType().getFieldList().get(fCol.getFieldIndex()).getType().getFamily() != SqlTypeFamily.NUMERIC) continue;
                numericCollationBitSetBuilder.set(fCol.getFieldIndex());
            }
            Integer n = fetch = sort.fetch != null ? Integer.valueOf(RexLiteral.intValue(sort.fetch)) : null;
        }
        if (i != this.rels.size()) {
            throw new AssertionError((Object)"could not implement all rels");
        }
        return this.getQuery(rowType, filterRel, project, groupSet, aggCalls, aggNames, collationIndexes, collationDirections, numericCollationBitSetBuilder.build(), fetch, postProject, havingFilter);
    }

    public QueryType getQueryType() {
        return this.getQuerySpec().queryType;
    }

    public String getQueryString() {
        return this.getQuerySpec().queryString;
    }

    protected CalciteConnectionConfig getConnectionConfig() {
        return this.getCluster().getPlanner().getContext().unwrap(CalciteConnectionConfig.class);
    }

    @Nullable
    private static DruidJsonFilter computeFilter(@Nullable Filter filterRel, DruidQuery druidQuery) {
        if (filterRel == null) {
            return null;
        }
        RexNode filter = filterRel.getCondition();
        RelDataType inputRowType = filterRel.getInput().getRowType();
        if (filter != null) {
            return DruidJsonFilter.toDruidFilters(filter, inputRowType, druidQuery);
        }
        return null;
    }

    @Nullable
    protected static Pair<List<String>, List<VirtualColumn>> computeProjectAsScan(@Nullable Project projectRel, RelDataType inputRowType, DruidQuery druidQuery) {
        if (projectRel == null) {
            return null;
        }
        HashSet<String> usedFieldNames = new HashSet<String>();
        ImmutableList.Builder virtualColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder projectedColumnsBuilder = ImmutableList.builder();
        List<RexNode> projects = projectRel.getProjects();
        for (RexNode project : projects) {
            boolean needExtractForOperand;
            Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(project, inputRowType, druidQuery);
            boolean bl = needExtractForOperand = project instanceof RexCall && ((RexCall)project).getOperands().stream().anyMatch(DruidQuery::needUtcTimeExtract);
            if (druidColumn.left == null || druidColumn.right != null || needExtractForOperand) {
                String expression = DruidExpressions.toDruidExpression(project, inputRowType, druidQuery);
                if (expression == null) {
                    return null;
                }
                String virColName = SqlValidatorUtil.uniquify("vc", usedFieldNames, SqlValidatorUtil.EXPR_SUGGESTER);
                virtualColumnsBuilder.add(VirtualColumn.builder().withName(virColName).withExpression(expression).withType(DruidExpressions.EXPRESSION_TYPES.get((Object)project.getType().getSqlTypeName())).build());
                usedFieldNames.add(virColName);
                projectedColumnsBuilder.add(virColName);
                continue;
            }
            if (usedFieldNames.contains(druidColumn.left)) {
                String virColName = SqlValidatorUtil.uniquify("vc", usedFieldNames, SqlValidatorUtil.EXPR_SUGGESTER);
                virtualColumnsBuilder.add(VirtualColumn.builder().withName(virColName).withExpression(DruidExpressions.fromColumn((String)druidColumn.left)).withType(DruidExpressions.EXPRESSION_TYPES.get((Object)project.getType().getSqlTypeName())).build());
                usedFieldNames.add(virColName);
                projectedColumnsBuilder.add(virColName);
                continue;
            }
            projectedColumnsBuilder.add(druidColumn.left);
            usedFieldNames.add((String)druidColumn.left);
        }
        return Pair.of(projectedColumnsBuilder.build(), virtualColumnsBuilder.build());
    }

    @Nullable
    protected static Pair<List<DimensionSpec>, List<VirtualColumn>> computeProjectGroupSet(@Nullable Project projectNode, ImmutableBitSet groupSet, RelDataType inputRowType, DruidQuery druidQuery) {
        ArrayList<DefaultDimensionSpec> dimensionSpecList = new ArrayList<DefaultDimensionSpec>();
        ArrayList<VirtualColumn> virtualColumnList = new ArrayList<VirtualColumn>();
        HashSet<String> usedFieldNames = new HashSet<String>();
        for (int groupKey : groupSet) {
            DimensionSpec dimensionSpec;
            RexNode project = projectNode == null ? RexInputRef.of(groupKey, inputRowType) : projectNode.getProjects().get(groupKey);
            Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(project, inputRowType, druidQuery);
            if (druidColumn.left != null && druidColumn.right == null) {
                dimensionSpec = new DefaultDimensionSpec((String)druidColumn.left, (String)druidColumn.left, DruidExpressions.EXPRESSION_TYPES.get((Object)project.getType().getSqlTypeName()));
                usedFieldNames.add((String)druidColumn.left);
            } else if (druidColumn.left != null && druidColumn.right != null) {
                String columnPrefix = project.getKind() == SqlKind.EXTRACT ? "extract_" + Objects.requireNonNull(DruidDateTimeUtils.extractGranularity((RexNode)project, (String)druidQuery.getConnectionConfig().timeZone()).getType().lowerName) : (project.getKind() == SqlKind.FLOOR ? "floor_" + Objects.requireNonNull(DruidDateTimeUtils.extractGranularity((RexNode)project, (String)druidQuery.getConnectionConfig().timeZone()).getType().lowerName) : EXTRACT_COLUMN_NAME_PREFIX);
                String uniqueExtractColumnName = SqlValidatorUtil.uniquify(columnPrefix, usedFieldNames, SqlValidatorUtil.EXPR_SUGGESTER);
                dimensionSpec = new ExtractionDimensionSpec((String)druidColumn.left, (ExtractionFunction)druidColumn.right, uniqueExtractColumnName);
                usedFieldNames.add(uniqueExtractColumnName);
            } else {
                String expression = DruidExpressions.toDruidExpression(project, inputRowType, druidQuery);
                if (Strings.isNullOrEmpty(expression)) {
                    return null;
                }
                String name = SqlValidatorUtil.uniquify("vc", usedFieldNames, SqlValidatorUtil.EXPR_SUGGESTER);
                VirtualColumn vc = new VirtualColumn(name, expression, DruidExpressions.EXPRESSION_TYPES.get((Object)project.getType().getSqlTypeName()));
                virtualColumnList.add(vc);
                dimensionSpec = new DefaultDimensionSpec(name, name, DruidExpressions.EXPRESSION_TYPES.get((Object)project.getType().getSqlTypeName()));
                usedFieldNames.add(name);
            }
            dimensionSpecList.add((DefaultDimensionSpec)dimensionSpec);
        }
        return Pair.of(dimensionSpecList, virtualColumnList);
    }

    @Nullable
    protected static List<JsonAggregation> computeDruidJsonAgg(List<AggregateCall> aggCalls, List<String> aggNames, @Nullable Project project, DruidQuery druidQuery) {
        ArrayList<JsonAggregation> aggregations = new ArrayList<JsonAggregation>();
        for (Pair<AggregateCall, String> agg : Pair.zip(aggCalls, aggNames)) {
            String expression;
            String fieldName;
            AggregateCall aggCall = (AggregateCall)agg.left;
            RelDataType type = aggCall.getType();
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            boolean isNotAcceptedType = SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)sqlTypeName) || SqlTypeFamily.INTEGER.getTypeNames().contains((Object)sqlTypeName) ? false : !SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains((Object)sqlTypeName) || type.getScale() != 0 && !druidQuery.getConnectionConfig().approximateDecimal();
            if (isNotAcceptedType) {
                return null;
            }
            RexNode filterNode = project != null && aggCall.hasFilter() ? project.getProjects().get(aggCall.filterArg) : null;
            if (aggCall.getArgList().size() == 0) {
                fieldName = null;
                expression = null;
            } else {
                int index = Iterables.getOnlyElement(aggCall.getArgList());
                if (project == null) {
                    fieldName = druidQuery.table.getRowType().getFieldNames().get(index);
                    expression = null;
                } else {
                    RexNode rexNode = project.getProjects().get(index);
                    RelDataType inputRowType = project.getInput().getRowType();
                    if (rexNode.isA(SqlKind.INPUT_REF)) {
                        expression = null;
                        fieldName = DruidQuery.extractColumnName(rexNode, inputRowType, druidQuery);
                    } else {
                        expression = DruidExpressions.toDruidExpression(rexNode, inputRowType, druidQuery);
                        if (Strings.isNullOrEmpty(expression)) {
                            return null;
                        }
                        fieldName = null;
                    }
                }
                assert (expression == null ^ fieldName == null);
            }
            JsonAggregation jsonAggregation = DruidQuery.getJsonAggregation((String)agg.right, (AggregateCall)agg.left, filterNode, fieldName, expression, druidQuery);
            if (jsonAggregation == null) {
                return null;
            }
            aggregations.add(jsonAggregation);
        }
        return aggregations;
    }

    protected QuerySpec getQuery(RelDataType rowType, Filter filter, Project project, ImmutableBitSet groupSet, List<AggregateCall> aggCalls, List<String> aggNames, List<Integer> collationIndexes, List<RelFieldCollation.Direction> collationDirections, ImmutableBitSet numericCollationIndexes, Integer fetch, Project postProject, Filter havingFilter) {
        ArrayList<String> postAggregateStageFieldNames;
        DruidJsonFilter jsonFilter = DruidQuery.computeFilter(filter, this);
        if (groupSet == null) {
            List scanColumnNames;
            assert (aggCalls == null);
            assert (aggNames == null);
            assert (collationIndexes == null || collationIndexes.isEmpty());
            assert (collationDirections == null || collationDirections.isEmpty());
            ArrayList<VirtualColumn> virtualColumnList = new ArrayList<VirtualColumn>();
            if (project != null) {
                Pair<List<String>, List<VirtualColumn>> projectResult = DruidQuery.computeProjectAsScan(project, project.getInput().getRowType(), this);
                scanColumnNames = (List)projectResult.left;
                virtualColumnList.addAll((Collection)projectResult.right);
            } else {
                scanColumnNames = rowType.getFieldNames();
            }
            ScanQuery scanQuery = new ScanQuery(this.druidTable.dataSource, this.intervals, jsonFilter, virtualColumnList, scanColumnNames, fetch);
            return new QuerySpec(QueryType.SCAN, scanQuery.toQuery(), scanColumnNames);
        }
        assert (aggCalls != null);
        assert (aggNames != null);
        assert (aggCalls.size() == aggNames.size());
        ArrayList<JsonExpressionPostAgg> postAggs = new ArrayList<JsonExpressionPostAgg>();
        RelDataType aggInputRowType = this.table.getRowType();
        ArrayList<String> aggregateStageFieldNames = new ArrayList<String>();
        Pair<List<DimensionSpec>, List<VirtualColumn>> projectGroupSet = DruidQuery.computeProjectGroupSet(project, groupSet, aggInputRowType, this);
        List groupByKeyDims = (List)projectGroupSet.left;
        List virtualColumnList = (List)projectGroupSet.right;
        for (Object dim : groupByKeyDims) {
            aggregateStageFieldNames.add(dim.getOutputName());
        }
        List<JsonAggregation> aggregations = DruidQuery.computeDruidJsonAgg(aggCalls, aggNames, project, this);
        for (JsonAggregation jsonAgg : aggregations) {
            aggregateStageFieldNames.add(jsonAgg.name);
        }
        DruidJsonFilter havingJsonFilter = havingFilter != null ? DruidJsonFilter.toDruidFilters(havingFilter.getCondition(), havingFilter.getInput().getRowType(), this) : null;
        if (postProject != null) {
            ArrayList<String> postProjectDimListBuilder = new ArrayList<String>();
            RelDataType postAggInputRowType = this.getCluster().getTypeFactory().createStructType(Pair.right(postProject.getInput().getRowType().getFieldList()), aggregateStageFieldNames);
            HashSet<String> existingAggFieldsNames = new HashSet<String>(aggregateStageFieldNames);
            ImmutableMap existingProjects = Maps.uniqueIndex(aggregateStageFieldNames, DruidExpressions::fromColumn);
            for (Pair<RexNode, String> pair : postProject.getNamedProjects()) {
                RexNode postProjectRexNode = (RexNode)pair.left;
                String expression = DruidExpressions.toDruidExpression(postProjectRexNode, postAggInputRowType, this);
                String existingFieldName = (String)existingProjects.get(expression);
                if (existingFieldName != null) {
                    postProjectDimListBuilder.add(existingFieldName);
                    continue;
                }
                String uniquelyProjectFieldName = SqlValidatorUtil.uniquify((String)pair.right, existingAggFieldsNames, SqlValidatorUtil.EXPR_SUGGESTER);
                postAggs.add(new JsonExpressionPostAgg(uniquelyProjectFieldName, expression, null));
                postProjectDimListBuilder.add(uniquelyProjectFieldName);
                existingAggFieldsNames.add(uniquelyProjectFieldName);
            }
            postAggregateStageFieldNames = postProjectDimListBuilder;
        } else {
            postAggregateStageFieldNames = null;
        }
        ArrayList<String> queryOutputFieldNames = postAggregateStageFieldNames == null ? aggregateStageFieldNames : postAggregateStageFieldNames;
        JsonLimit limit = this.computeSort(fetch, collationIndexes, collationDirections, numericCollationIndexes, queryOutputFieldNames);
        String timeSeriesQueryString = this.planAsTimeSeries(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (timeSeriesQueryString != null) {
            String timeExtractColumn;
            String string = timeExtractColumn = groupByKeyDims.isEmpty() ? null : ((DimensionSpec)groupByKeyDims.get(0)).getOutputName();
            if (timeExtractColumn != null) {
                List<String> timeseriesFieldNames = Lists.transform(queryOutputFieldNames, input -> {
                    if (timeExtractColumn.equals(input)) {
                        return "timestamp";
                    }
                    return input;
                });
                return new QuerySpec(QueryType.TIMESERIES, timeSeriesQueryString, timeseriesFieldNames);
            }
            return new QuerySpec(QueryType.TIMESERIES, timeSeriesQueryString, queryOutputFieldNames);
        }
        String topNQuery = this.planAsTopN(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (topNQuery != null) {
            return new QuerySpec(QueryType.TOP_N, topNQuery, queryOutputFieldNames);
        }
        String groupByQuery = this.planAsGroupBy(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (groupByQuery == null) {
            throw new IllegalStateException("Cannot plan Druid Query");
        }
        return new QuerySpec(QueryType.GROUP_BY, groupByQuery, queryOutputFieldNames);
    }

    @Nonnull
    private JsonLimit computeSort(@Nullable Integer fetch, List<Integer> collationIndexes, List<RelFieldCollation.Direction> collationDirections, ImmutableBitSet numericCollationIndexes, List<String> queryOutputFieldNames) {
        ImmutableCollection collations;
        if (collationIndexes != null) {
            assert (collationDirections != null);
            ImmutableList.Builder colBuilder = ImmutableList.builder();
            for (Pair<Integer, RelFieldCollation.Direction> p : Pair.zip(collationIndexes, collationDirections)) {
                String dimensionOrder = numericCollationIndexes.get((Integer)p.left) ? "numeric" : "lexicographic";
                colBuilder.add(new JsonCollation(queryOutputFieldNames.get((Integer)p.left), p.right == RelFieldCollation.Direction.DESCENDING ? "descending" : "ascending", dimensionOrder));
            }
            collations = colBuilder.build();
        } else {
            collations = null;
        }
        return new JsonLimit("default", fetch, (List)((Object)collations));
    }

    @Nullable
    private String planAsTimeSeries(List<DimensionSpec> groupByKeyDims, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, DruidJsonFilter havingFilter) {
        Granularity timeseriesGranularity;
        String sortDirection;
        if (havingFilter != null) {
            return null;
        }
        if (groupByKeyDims.size() > 1) {
            return null;
        }
        if (limit.limit != null) {
            return null;
        }
        if (limit.collations != null && limit.collations.size() > 1) {
            return null;
        }
        if (limit.collations != null && limit.collations.size() == 1) {
            if (groupByKeyDims.isEmpty() || !limit.collations.get((int)0).dimension.equals(groupByKeyDims.get(0).getOutputName())) {
                return null;
            }
            sortDirection = limit.collations.get((int)0).direction;
        } else {
            sortDirection = null;
        }
        if (groupByKeyDims.size() == 1) {
            DimensionSpec dimensionSpec = Iterables.getOnlyElement(groupByKeyDims);
            Granularity granularity = ExtractionDimensionSpec.toQueryGranularity(dimensionSpec);
            boolean hasExpressionOnTopOfTimeExtract = false;
            for (JsonExpressionPostAgg postAgg : postAggregations) {
                if (!(postAgg instanceof JsonExpressionPostAgg) || !postAgg.expression.contains(groupByKeyDims.get(0).getOutputName())) continue;
                hasExpressionOnTopOfTimeExtract = true;
            }
            Granularity granularity2 = timeseriesGranularity = hasExpressionOnTopOfTimeExtract ? null : granularity;
            if (timeseriesGranularity == null) {
                return null;
            }
        } else {
            timeseriesGranularity = Granularities.all();
        }
        boolean skipEmptyBuckets = Granularities.all() != timeseriesGranularity;
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "timeseries");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            generator.writeBooleanField("descending", sortDirection != null && sortDirection.equals("descending"));
            DruidQuery.writeField(generator, "granularity", timeseriesGranularity);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.size() > 0 ? virtualColumnList : null);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.size() > 0 ? postAggregations : null);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            generator.writeFieldName("context");
            generator.writeStartObject();
            generator.writeBooleanField("skipEmptyBuckets", skipEmptyBuckets);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    @Nullable
    private String planAsTopN(List<DimensionSpec> groupByKeyDims, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, DruidJsonFilter havingFilter) {
        if (havingFilter != null) {
            return null;
        }
        if (!this.getConnectionConfig().approximateTopN() || groupByKeyDims.size() != 1 || limit.limit == null || limit.collations == null || limit.collations.size() != 1) {
            return null;
        }
        if (limit.collations.get((int)0).dimension.equals(groupByKeyDims.get(0).getOutputName())) {
            return null;
        }
        if (limit.collations.get((int)0).direction.equals("ascending")) {
            return null;
        }
        String topNMetricColumnName = limit.collations.get((int)0).dimension;
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "topN");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            DruidQuery.writeField(generator, "granularity", Granularities.all());
            DruidQuery.writeField(generator, "dimension", groupByKeyDims.get(0));
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.size() > 0 ? virtualColumnList : null);
            generator.writeStringField("metric", topNMetricColumnName);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.size() > 0 ? postAggregations : null);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            generator.writeNumberField("threshold", limit.limit);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    @Nullable
    private String planAsGroupBy(List<DimensionSpec> groupByKeyDims, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, DruidJsonFilter havingFilter) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "groupBy");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            DruidQuery.writeField(generator, "granularity", Granularities.all());
            DruidQuery.writeField(generator, "dimensions", groupByKeyDims);
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.size() > 0 ? virtualColumnList : null);
            DruidQuery.writeFieldIf(generator, "limitSpec", limit);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.size() > 0 ? postAggregations : null);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            DruidQuery.writeFieldIf(generator, "having", havingFilter == null ? null : new DruidJsonFilter.JsonDimHavingFilter(havingFilter));
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    @Nullable
    private static JsonAggregation getJsonAggregation(String name, AggregateCall aggCall, RexNode filterNode, String fieldName, String aggExpression, DruidQuery druidQuery) {
        JsonAggregation aggregation;
        boolean fractional;
        RelDataType type = aggCall.getType();
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        CalciteConnectionConfig config = druidQuery.getConnectionConfig();
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)sqlTypeName)) {
            fractional = true;
        } else if (SqlTypeFamily.INTEGER.getTypeNames().contains((Object)sqlTypeName)) {
            fractional = false;
        } else if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains((Object)sqlTypeName)) {
            assert (sqlTypeName == SqlTypeName.DECIMAL);
            fractional = type.getScale() != 0;
        } else {
            return null;
        }
        ComplexMetric complexMetric = druidQuery.druidTable.resolveComplexMetric(fieldName, aggCall);
        switch (aggCall.getAggregation().getKind()) {
            case COUNT: {
                if (aggCall.isDistinct()) {
                    if (aggCall.isApproximate() || config.approximateDistinctCount()) {
                        if (complexMetric == null) {
                            aggregation = new JsonCardinalityAggregation("cardinality", name, ImmutableList.of(fieldName));
                            break;
                        }
                        aggregation = new JsonAggregation(complexMetric.getMetricType(), name, complexMetric.getMetricName(), null);
                        break;
                    }
                    return null;
                }
                if (aggCall.getArgList().size() == 1 && !aggCall.isDistinct()) {
                    DruidJsonFilter matchNulls = fieldName == null ? new DruidJsonFilter.JsonExpressionFilter(aggExpression + " == null") : DruidJsonFilter.getSelectorFilter(fieldName, null, null);
                    aggregation = new JsonFilteredAggregation(DruidJsonFilter.toNotDruidFilter(matchNulls), new JsonAggregation("count", name, fieldName, aggExpression));
                    break;
                }
                if (!aggCall.isDistinct()) {
                    aggregation = new JsonAggregation("count", name, fieldName, aggExpression);
                    break;
                }
                aggregation = null;
                break;
            }
            case SUM: 
            case SUM0: {
                aggregation = new JsonAggregation(fractional ? "doubleSum" : "longSum", name, fieldName, aggExpression);
                break;
            }
            case MIN: {
                aggregation = new JsonAggregation(fractional ? "doubleMin" : "longMin", name, fieldName, aggExpression);
                break;
            }
            case MAX: {
                aggregation = new JsonAggregation(fractional ? "doubleMax" : "longMax", name, fieldName, aggExpression);
                break;
            }
            default: {
                return null;
            }
        }
        if (aggregation == null) {
            return null;
        }
        if (filterNode != null) {
            DruidJsonFilter druidFilter = DruidJsonFilter.toDruidFilters(filterNode, druidQuery.table.getRowType(), druidQuery);
            if (druidFilter == null) {
                return null;
            }
            return new JsonFilteredAggregation(druidFilter, aggregation);
        }
        return aggregation;
    }

    protected static void writeField(JsonGenerator generator, String fieldName, Object o) throws IOException {
        generator.writeFieldName(fieldName);
        DruidQuery.writeObject(generator, o);
    }

    protected static void writeFieldIf(JsonGenerator generator, String fieldName, Object o) throws IOException {
        if (o != null) {
            DruidQuery.writeField(generator, fieldName, o);
        }
    }

    protected static void writeArray(JsonGenerator generator, List<?> elements) throws IOException {
        generator.writeStartArray();
        for (Object o : elements) {
            DruidQuery.writeObject(generator, o);
        }
        generator.writeEndArray();
    }

    protected static void writeObject(JsonGenerator generator, Object o) throws IOException {
        if (o instanceof String) {
            String s = (String)o;
            generator.writeString(s);
        } else if (o instanceof Interval) {
            generator.writeString(o.toString());
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            generator.writeNumber(i);
        } else if (o instanceof List) {
            DruidQuery.writeArray(generator, (List)o);
        } else if (o instanceof DruidJson) {
            ((DruidJson)o).write(generator);
        } else {
            throw new AssertionError((Object)("not a json object: " + o));
        }
    }

    static String metadataQuery(String dataSourceName, List<Interval> intervals) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "segmentMetadata");
            generator.writeStringField("dataSource", dataSourceName);
            generator.writeBooleanField("merge", true);
            generator.writeBooleanField("lenientAggregatorMerge", true);
            generator.writeArrayFieldStart("analysisTypes");
            generator.writeString("aggregators");
            generator.writeEndArray();
            DruidQuery.writeFieldIf(generator, "intervals", intervals);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    protected int getTimestampFieldIndex() {
        return Iterables.indexOf(this.getRowType().getFieldList(), input -> this.druidTable.timestampFieldName.equals(input.getName()));
    }

    protected static abstract class JsonPostAggregation
    implements DruidJson {
        final String type;
        String name;

        private JsonPostAggregation(String name, String type) {
            this.type = type;
            this.name = name;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class JsonFilteredAggregation
    extends JsonAggregation {
        final DruidJsonFilter filter;
        final JsonAggregation aggregation;

        private JsonFilteredAggregation(DruidJsonFilter filter, JsonAggregation aggregation) {
            super("filtered", aggregation.name, aggregation.fieldName, null);
            this.filter = filter;
            this.aggregation = aggregation;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeField(generator, "filter", this.filter);
            DruidQuery.writeField(generator, "aggregator", this.aggregation);
            generator.writeEndObject();
        }
    }

    private static class JsonCardinalityAggregation
    extends JsonAggregation {
        final List<String> fieldNames;

        private JsonCardinalityAggregation(String type, String name, List<String> fieldNames) {
            super(type, name, null, null);
            this.fieldNames = fieldNames;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldNames", this.fieldNames);
            generator.writeEndObject();
        }
    }

    private static class JsonCollation
    implements DruidJson {
        final String dimension;
        final String direction;
        final String dimensionOrder;

        private JsonCollation(String dimension, String direction, String dimensionOrder) {
            this.dimension = dimension;
            this.direction = direction;
            this.dimensionOrder = dimensionOrder;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeFieldIf(generator, "direction", this.direction);
            DruidQuery.writeFieldIf(generator, "dimensionOrder", this.dimensionOrder);
            generator.writeEndObject();
        }
    }

    private static class JsonLimit
    implements DruidJson {
        final String type;
        final Integer limit;
        final List<JsonCollation> collations;

        private JsonLimit(String type, Integer limit, List<JsonCollation> collations) {
            this.type = type;
            this.limit = limit;
            this.collations = collations;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeFieldIf(generator, "limit", this.limit);
            DruidQuery.writeFieldIf(generator, "columns", this.collations);
            generator.writeEndObject();
        }
    }

    private static class JsonExpressionPostAgg
    extends JsonPostAggregation {
        private final String expression;
        private final String ordering;

        private JsonExpressionPostAgg(String name, String expression, String ordering) {
            super(name, "expression");
            this.expression = expression;
            this.ordering = ordering;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            DruidQuery.writeFieldIf(generator, "expression", this.expression);
            DruidQuery.writeFieldIf(generator, "ordering", this.ordering);
            generator.writeEndObject();
        }
    }

    private static class JsonAggregation
    implements DruidJson {
        final String type;
        final String name;
        final String fieldName;
        final String expression;

        private JsonAggregation(String type, String name, String fieldName, String expression) {
            this.type = type;
            this.name = name;
            this.fieldName = fieldName;
            this.expression = expression;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldName", this.fieldName);
            DruidQuery.writeFieldIf(generator, "expression", this.expression);
            generator.writeEndObject();
        }
    }

    private static class DruidQueryNode
    implements Node {
        private final Sink sink;
        private final DruidQuery query;
        private final QuerySpec querySpec;

        DruidQueryNode(Compiler interpreter, DruidQuery query) {
            this.query = query;
            this.sink = interpreter.sink(query);
            this.querySpec = query.getQuerySpec();
            Hook.QUERY_PLAN.run(this.querySpec);
        }

        @Override
        public void run() throws InterruptedException {
            ArrayList<ColumnMetaData.Rep> fieldTypes = new ArrayList<ColumnMetaData.Rep>();
            for (RelDataTypeField field : this.query.getRowType().getFieldList()) {
                fieldTypes.add(this.getPrimitive(field));
            }
            DruidConnectionImpl connection = new DruidConnectionImpl(this.query.druidTable.schema.url, this.query.druidTable.schema.coordinatorUrl);
            boolean limitQuery = DruidQueryNode.containsLimit(this.querySpec);
            DruidConnectionImpl.Page page = new DruidConnectionImpl.Page();
            do {
                String queryString = this.querySpec.getQueryString(page.pagingIdentifier, page.offset);
                connection.request(this.querySpec.queryType, queryString, this.sink, this.querySpec.fieldNames, fieldTypes, page);
            } while (!limitQuery && page.pagingIdentifier != null && page.totalRowCount > 0);
        }

        private static boolean containsLimit(QuerySpec querySpec) {
            return querySpec.queryString.contains("\"context\":{\"druid.query.fetch\":true");
        }

        private ColumnMetaData.Rep getPrimitive(RelDataTypeField field) {
            switch (field.getType().getSqlTypeName()) {
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP: {
                    return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
                }
                case BIGINT: {
                    return ColumnMetaData.Rep.LONG;
                }
                case INTEGER: {
                    return ColumnMetaData.Rep.INTEGER;
                }
                case SMALLINT: {
                    return ColumnMetaData.Rep.SHORT;
                }
                case TINYINT: {
                    return ColumnMetaData.Rep.BYTE;
                }
                case REAL: {
                    return ColumnMetaData.Rep.FLOAT;
                }
                case DOUBLE: 
                case FLOAT: {
                    return ColumnMetaData.Rep.DOUBLE;
                }
            }
            return null;
        }
    }

    public static class QuerySpec {
        final QueryType queryType;
        final String queryString;
        final List<String> fieldNames;

        QuerySpec(QueryType queryType, String queryString, List<String> fieldNames) {
            this.queryType = Objects.requireNonNull(queryType);
            this.queryString = Objects.requireNonNull(queryString);
            this.fieldNames = ImmutableList.copyOf(fieldNames);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.queryType, this.queryString, this.fieldNames});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QuerySpec && this.queryType == ((QuerySpec)obj).queryType && this.queryString.equals(((QuerySpec)obj).queryString) && this.fieldNames.equals(((QuerySpec)obj).fieldNames);
        }

        public String toString() {
            return "{queryType: " + (Object)((Object)this.queryType) + ", queryString: " + this.queryString + ", fieldNames: " + this.fieldNames + "}";
        }

        public String getQueryString(String pagingIdentifier, int offset) {
            if (pagingIdentifier == null) {
                return this.queryString;
            }
            return this.queryString.replace("\"threshold\":", "\"pagingIdentifiers\":{\"" + pagingIdentifier + "\":" + offset + "},\"threshold\":");
        }
    }

    private static class ScanQuery {
        private String dataSource;
        private List<Interval> intervals;
        private DruidJsonFilter jsonFilter;
        private List<VirtualColumn> virtualColumnList;
        private List<String> columns;
        private Integer fetchLimit;

        ScanQuery(String dataSource, List<Interval> intervals, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<String> columns, Integer fetchLimit) {
            this.dataSource = dataSource;
            this.intervals = intervals;
            this.jsonFilter = jsonFilter;
            this.virtualColumnList = virtualColumnList;
            this.columns = columns;
            this.fetchLimit = fetchLimit;
        }

        @Nonnull
        public String toQuery() {
            StringWriter sw = new StringWriter();
            try {
                JsonFactory factory = new JsonFactory();
                JsonGenerator generator = factory.createGenerator(sw);
                generator.writeStartObject();
                generator.writeStringField("queryType", "scan");
                generator.writeStringField("dataSource", this.dataSource);
                DruidQuery.writeField(generator, "intervals", this.intervals);
                DruidQuery.writeFieldIf(generator, "filter", this.jsonFilter);
                DruidQuery.writeFieldIf(generator, "virtualColumns", this.virtualColumnList.size() > 0 ? this.virtualColumnList : null);
                DruidQuery.writeField(generator, "columns", this.columns);
                generator.writeStringField("resultFormat", "compactedList");
                if (this.fetchLimit != null) {
                    generator.writeNumberField("limit", this.fetchLimit);
                }
                generator.writeEndObject();
                generator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return sw.toString();
        }
    }
}

