/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.io.IOException;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidType;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ExtractionFunction;

public class DefaultDimensionSpec
implements DimensionSpec {
    private final String dimension;
    private final String outputName;
    private final DruidType outputType;

    public DefaultDimensionSpec(String dimension, String outputName, DruidType outputType) {
        this.dimension = Objects.requireNonNull(dimension);
        this.outputName = Objects.requireNonNull(outputName);
        this.outputType = outputType == null ? DruidType.STRING : outputType;
    }

    public DefaultDimensionSpec(String dimension) {
        this(dimension, dimension, null);
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "default");
        generator.writeStringField("dimension", this.dimension);
        generator.writeStringField("outputName", this.outputName);
        generator.writeStringField("outputType", this.outputType.name());
        generator.writeEndObject();
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public DruidType getOutputType() {
        return this.outputType;
    }

    @Override
    public ExtractionFunction getExtractionFn() {
        return null;
    }

    @Override
    public String getDimension() {
        return this.dimension;
    }
}

