/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidType;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;

public class ComplexMetric {
    private final String metricName;
    private final DruidType type;

    public ComplexMetric(String metricName, DruidType type) {
        this.validate(type);
        this.metricName = metricName;
        this.type = type;
    }

    private void validate(DruidType type) {
        if (!type.isComplex()) {
            throw new IllegalArgumentException("Druid type: " + (Object)((Object)type) + " is not complex");
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public DruidType getDruidType() {
        return this.type;
    }

    public String getMetricType() {
        switch (this.type) {
            case HYPER_UNIQUE: {
                return "hyperUnique";
            }
            case THETA_SKETCH: {
                return "thetaSketch";
            }
        }
        throw new AssertionError((Object)("Type: " + (Object)((Object)this.type) + " does not have an associated metric type"));
    }

    public boolean canBeUsed(AggregateCall call) {
        switch (this.type) {
            case HYPER_UNIQUE: 
            case THETA_SKETCH: {
                return call != null && call.getAggregation().getKind() == SqlKind.COUNT && call.isDistinct();
            }
        }
        return false;
    }
}

