/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateTimeSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(DateTime.class, format, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public DateTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new DateTimeSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, DateTime value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(DateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        boolean numeric;
        boolean bl = numeric = this._serializationShape(provider) != 1;
        if (!this.writeWithZoneId(provider)) {
            if (numeric) {
                gen.writeNumber(value.getMillis());
            } else {
                gen.writeString(this._format.createFormatter(provider).print((ReadableInstant)value));
            }
        } else {
            if (numeric) {
                gen.writeNumber(value.getMillis());
                return;
            }
            StringBuilder sb = new StringBuilder(40).append(this._format.createFormatter(provider).withOffsetParsed().print((ReadableInstant)value));
            sb = sb.append('[').append(value.getZone()).append(']');
            gen.writeString(sb.toString());
        }
    }
}

