/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.json.AvroParseSpec;
import org.apache.hadoop.hive.druid.json.AvroStreamInputRowParser;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.ExprNodeDynamicValueEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToString;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Interner;
import org.apache.hive.druid.com.google.common.collect.Interners;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.hive.druid.org.apache.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.NullableNumericAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.expression.LikeExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.RegexpExtractExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampCeilExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampFormatExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampParseExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TimestampShiftExprMacro;
import org.apache.hive.druid.org.apache.druid.query.expression.TrimExprMacro;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilterHolder;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.OrDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparator;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMergerV9;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidStorageHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DruidStorageHandlerUtils.class);
    private static final int NUM_RETRIES = 8;
    private static final int SECONDS_BETWEEN_RETRIES = 2;
    private static final int DEFAULT_FS_BUFFER_SIZE = 262144;
    private static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private static final String SMILE_CONTENT_TYPE = "application/x-jackson-smile";
    static final String INDEX_ZIP = "index.zip";
    private static final String DESCRIPTOR_JSON = "descriptor.json";
    private static final Interval DEFAULT_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"1900-01-01", (Chronology)ISOChronology.getInstanceUTC()), (ReadableInstant)new DateTime((Object)"3000-01-01", (Chronology)ISOChronology.getInstanceUTC())).withChronology((Chronology)ISOChronology.getInstanceUTC());
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    public static final ObjectMapper SMILE_MAPPER = new DefaultObjectMapper(new SmileFactory());
    private static final int DEFAULT_MAX_TRIES = 10;
    public static final IndexIO INDEX_IO;
    public static final IndexMergerV9 INDEX_MERGER_V9;
    private static final Interner<DataSegment> DATA_SEGMENT_INTERNER;
    private static Set<TypeInfo> druidSupportedTypeInfos;
    private static Set<TypeInfo> stringTypeInfos;

    private DruidStorageHandlerUtils() {
    }

    public static Request createSmileRequest(String address, Query query) {
        try {
            return new Request(HttpMethod.POST, new URL(String.format("%s/druid/v2/", "http://" + address))).setContent(SMILE_MAPPER.writeValueAsBytes(query)).setHeader("Content-Type", SMILE_CONTENT_TYPE);
        }
        catch (MalformedURLException e) {
            LOG.error("URL Malformed  address {}", (Object)address);
            throw new RuntimeException(e);
        }
        catch (JsonProcessingException e) {
            LOG.error("can not Serialize the Query [{}]", (Object)query.toString());
            throw new RuntimeException(e);
        }
    }

    public static InputStream submitRequest(HttpClient client, Request request) throws IOException {
        try {
            return (InputStream)client.go(request, new InputStreamResponseHandler()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    static StringFullResponseHolder getResponseFromCurrentLeader(HttpClient client, Request request, StringFullResponseHandler fullResponseHandler) throws ExecutionException, InterruptedException {
        StringFullResponseHolder responseHolder = (StringFullResponseHolder)client.go(request, fullResponseHandler).get();
        if (HttpResponseStatus.TEMPORARY_REDIRECT.equals(responseHolder.getStatus())) {
            URL redirectUrl;
            String redirectUrlStr = responseHolder.getResponse().headers().get("Location");
            LOG.debug("Request[%s] received redirect response to location [%s].", (Object)request.getUrl(), (Object)redirectUrlStr);
            try {
                redirectUrl = new URL(redirectUrlStr);
            }
            catch (MalformedURLException ex) {
                throw new ExecutionException(String.format("Malformed redirect location is found in response from url[%s], new location[%s].", request.getUrl(), redirectUrlStr), ex);
            }
            responseHolder = (StringFullResponseHolder)client.go(DruidStorageHandlerUtils.withUrl(request, redirectUrl), fullResponseHandler).get();
        }
        return responseHolder;
    }

    private static Request withUrl(Request old, URL url) {
        Request req = new Request(old.getMethod(), url);
        req.addHeaderValues(old.getHeaders());
        if (old.hasContent()) {
            req.setContent(old.getContent());
        }
        return req;
    }

    public static List<DataSegment> getCreatedSegments(Path taskDir, Configuration conf) throws IOException {
        FileStatus[] fss;
        ImmutableList.Builder publishedSegmentsBuilder = ImmutableList.builder();
        FileSystem fs = taskDir.getFileSystem(conf);
        for (FileStatus fileStatus : fss = fs.listStatus(taskDir)) {
            DataSegment segment = JSON_MAPPER.readValue((InputStream)fs.open(fileStatus.getPath()), DataSegment.class);
            publishedSegmentsBuilder.add(segment);
        }
        return publishedSegmentsBuilder.build();
    }

    public static void writeSegmentDescriptor(FileSystem outputFS, DataSegment segment, Path descriptorPath) throws IOException {
        DataPusher descriptorPusher = (DataPusher)RetryProxy.create(DataPusher.class, () -> {
            if (outputFS.exists(descriptorPath) && !outputFS.delete(descriptorPath, false)) {
                throw new IOException(String.format("Failed to delete descriptor at [%s]", descriptorPath));
            }
            try (FSDataOutputStream descriptorOut = outputFS.create(descriptorPath, true, 262144);){
                JSON_MAPPER.writeValue((OutputStream)descriptorOut, (Object)segment);
                descriptorOut.flush();
            }
        }, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)8, (long)2L, (TimeUnit)TimeUnit.SECONDS));
        descriptorPusher.push();
    }

    static Collection<String> getAllDataSourceNames(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig) {
        return connector.getDBI().withHandle(handle -> handle.createQuery(String.format("SELECT DISTINCT(datasource) FROM %s WHERE used = true", metadataStorageTablesConfig.getSegmentsTable())).fold(Lists.newArrayList(), (druidDataSources, stringObjectMap, foldController, statementContext) -> {
            druidDataSources.add(MapUtils.getString(stringObjectMap, "datasource"));
            return druidDataSources;
        }));
    }

    static boolean disableDataSource(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        try {
            if (!DruidStorageHandlerUtils.getAllDataSourceNames(connector, metadataStorageTablesConfig).contains(dataSource)) {
                LOG.warn("Cannot delete data source {}, does not exist", (Object)dataSource);
                return false;
            }
            connector.getDBI().withHandle(handle -> {
                DruidStorageHandlerUtils.disableDataSourceWithHandle(handle, metadataStorageTablesConfig, dataSource);
                return null;
            });
        }
        catch (Exception e) {
            LOG.error(String.format("Error removing dataSource %s", dataSource), (Throwable)e);
            return false;
        }
        return true;
    }

    static List<DataSegment> publishSegmentsAndCommit(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource, List<DataSegment> segments, boolean overwrite, Configuration conf, DataSegmentPusher dataSegmentPusher) throws CallbackFailedException {
        return connector.getDBI().inTransaction((handle, transactionStatus) -> {
            VersionedIntervalTimeline<Object, Object> timeline;
            if (overwrite) {
                DruidStorageHandlerUtils.disableDataSourceWithHandle(handle, metadataStorageTablesConfig, dataSource);
                timeline = new VersionedIntervalTimeline(Ordering.natural());
            } else {
                if (segments.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                Interval indexedInterval = JodaUtils.umbrellaInterval(segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
                LOG.info("Building timeline for umbrella Interval [{}]", (Object)indexedInterval);
                timeline = DruidStorageHandlerUtils.getTimelineForIntervalWithHandle(handle, dataSource, indexedInterval, metadataStorageTablesConfig);
            }
            ArrayList<DataSegment> finalSegmentsToPublish = Lists.newArrayList();
            for (DataSegment segment : segments) {
                String newVersion;
                ShardSpec newShardSpec;
                List<TimelineObjectHolder<Object, Object>> existingChunks = timeline.lookup(segment.getInterval());
                if (existingChunks.size() > 1) {
                    throw new IllegalStateException(String.format("Cannot allocate new segment for dataSource[%s], interval[%s], already have [%,d] chunks. Not possible to append new segment.", dataSource, segment.getInterval(), existingChunks.size()));
                }
                SegmentIdWithShardSpec max = null;
                if (!existingChunks.isEmpty()) {
                    TimelineObjectHolder<Object, Object> existingHolder = Iterables.getOnlyElement(existingChunks);
                    for (PartitionChunk<Object> partitionChunk : existingHolder.getObject()) {
                        if (max != null && max.getShardSpec().getPartitionNum() >= ((DataSegment)partitionChunk.getObject()).getShardSpec().getPartitionNum()) continue;
                        max = SegmentIdWithShardSpec.fromDataSegment((DataSegment)partitionChunk.getObject());
                    }
                }
                if (max == null) {
                    newShardSpec = segment.getShardSpec();
                    newVersion = segment.getVersion();
                } else {
                    newShardSpec = DruidStorageHandlerUtils.getNextPartitionShardSpec(max.getShardSpec());
                    newVersion = max.getVersion();
                }
                DataSegment publishedSegment = DruidStorageHandlerUtils.publishSegmentWithShardSpec(segment, newShardSpec, newVersion, DruidStorageHandlerUtils.getPath(segment).getFileSystem(conf), dataSegmentPusher);
                finalSegmentsToPublish.add(publishedSegment);
                timeline.add(publishedSegment.getInterval(), publishedSegment.getVersion(), publishedSegment.getShardSpec().createChunk(publishedSegment));
            }
            PreparedBatch batch = handle.prepareBatch(String.format("INSERT INTO %1$s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", metadataStorageTablesConfig.getSegmentsTable()));
            for (DataSegment segment : finalSegmentsToPublish) {
                batch.add(new ImmutableMap.Builder<String, String>().put("id", segment.getId().toString()).put("dataSource", segment.getDataSource()).put("created_date", new DateTime().toString()).put("start", segment.getInterval().getStart().toString()).put("end", segment.getInterval().getEnd().toString()).put("partitioned", (String)((Object)Boolean.valueOf(!(segment.getShardSpec() instanceof NoneShardSpec)))).put("version", segment.getVersion()).put("used", (String)((Object)Boolean.valueOf(true))).put("payload", (String)JSON_MAPPER.writeValueAsBytes(segment)).build());
                LOG.info("Published {}", (Object)segment.getId().toString());
            }
            batch.execute();
            return finalSegmentsToPublish;
        });
    }

    private static void disableDataSourceWithHandle(Handle handle, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).bind("dataSource", dataSource)).execute();
    }

    static List<DataSegment> getDataSegmentList(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        return connector.retryTransaction((handle, status) -> ((org.skife.jdbi.v2.Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).setFetchSize(DruidStorageHandlerUtils.getStreamingFetchSize(connector)).bind("dataSource", dataSource)).map(ByteArrayMapper.FIRST).fold(new ArrayList(), (accumulator, payload, control, ctx) -> {
            try {
                DataSegment segment = DATA_SEGMENT_INTERNER.intern(JSON_MAPPER.readValue((byte[])payload, DataSegment.class));
                accumulator.add(segment);
                return accumulator;
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }), 3, 10);
    }

    private static int getStreamingFetchSize(SQLMetadataConnector connector) {
        if (connector instanceof MySQLConnector) {
            return Integer.MIN_VALUE;
        }
        return 100;
    }

    public static Path makeSegmentDescriptorOutputPath(DataSegment pushedSegment, Path segmentsDescriptorDir) {
        return new Path(segmentsDescriptorDir, String.format("%s.json", pushedSegment.getId().toString().replace(":", "")));
    }

    public static String createScanAllQuery(String dataSourceName, List<String> columns) throws JsonProcessingException {
        Druids.ScanQueryBuilder scanQueryBuilder = Druids.newScanQueryBuilder();
        List<Interval> intervals = Collections.singletonList(DEFAULT_INTERVAL);
        ScanQuery scanQuery = scanQueryBuilder.dataSource(dataSourceName).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).intervals(new MultipleIntervalSegmentSpec(intervals)).columns(columns).build();
        return JSON_MAPPER.writeValueAsString(scanQuery);
    }

    @Nullable
    static Boolean getBooleanProperty(Table table, String propertyName) {
        String val = DruidStorageHandlerUtils.getTableProperty(table, propertyName);
        if (val == null) {
            return null;
        }
        return Boolean.parseBoolean(val);
    }

    static boolean getBooleanProperty(Table table, String propertyName, boolean defaultVal) {
        Boolean val = DruidStorageHandlerUtils.getBooleanProperty(table, propertyName);
        return val == null ? defaultVal : val;
    }

    @Nullable
    static Integer getIntegerProperty(Table table, String propertyName) {
        String val = DruidStorageHandlerUtils.getTableProperty(table, propertyName);
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Exception while parsing property[%s] with Value [%s] as Integer", propertyName, val));
        }
    }

    static int getIntegerProperty(Table table, String propertyName, int defaultVal) {
        Integer val = DruidStorageHandlerUtils.getIntegerProperty(table, propertyName);
        return val == null ? defaultVal : val;
    }

    @Nullable
    static Long getLongProperty(Table table, String propertyName) {
        String val = DruidStorageHandlerUtils.getTableProperty(table, propertyName);
        if (val == null) {
            return null;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Exception while parsing property[%s] with Value [%s] as Long", propertyName, val));
        }
    }

    @Nullable
    static Period getPeriodProperty(Table table, String propertyName) {
        String val = DruidStorageHandlerUtils.getTableProperty(table, propertyName);
        if (val == null) {
            return null;
        }
        try {
            return Period.parse((String)val);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Exception while parsing property[%s] with Value [%s] as Period", propertyName, val));
        }
    }

    @Nullable
    public static List<String> getListProperty(Table table, String propertyName) {
        String[] vals;
        ArrayList<String> rv = new ArrayList<String>();
        String values = DruidStorageHandlerUtils.getTableProperty(table, propertyName);
        if (values == null) {
            return null;
        }
        for (String val : vals = values.trim().split(",")) {
            if (!StringUtils.isNotBlank(val)) continue;
            rv.add(val);
        }
        return rv;
    }

    static String getTableProperty(Table table, String propertyName) {
        return (String)table.getParameters().get(propertyName);
    }

    private static VersionedIntervalTimeline<String, DataSegment> getTimelineForIntervalWithHandle(Handle handle, String dataSource, Interval interval, MetadataStorageTablesConfig dbTables) throws IOException {
        org.skife.jdbi.v2.Query sql = (org.skife.jdbi.v2.Query)((org.skife.jdbi.v2.Query)((org.skife.jdbi.v2.Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE used = true AND dataSource = ? AND start <= ? AND \"end\" >= ?", dbTables.getSegmentsTable())).bind(0, dataSource)).bind(1, interval.getEnd().toString())).bind(2, interval.getStart().toString());
        VersionedIntervalTimeline<String, DataSegment> timeline = new VersionedIntervalTimeline<String, DataSegment>(Ordering.natural());
        try (Iterator dbSegments = sql.map(ByteArrayMapper.FIRST).iterator();){
            while (dbSegments.hasNext()) {
                byte[] payload = (byte[])dbSegments.next();
                DataSegment segment = JSON_MAPPER.readValue(payload, DataSegment.class);
                timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
            }
        }
        return timeline;
    }

    public static DataSegmentPusher createSegmentPusherForDirectory(String segmentDirectory, Configuration configuration) throws IOException {
        HdfsDataSegmentPusherConfig hdfsDataSegmentPusherConfig = new HdfsDataSegmentPusherConfig();
        hdfsDataSegmentPusherConfig.setStorageDirectory(segmentDirectory);
        return new HdfsDataSegmentPusher(hdfsDataSegmentPusherConfig, configuration, JSON_MAPPER);
    }

    private static DataSegment publishSegmentWithShardSpec(DataSegment segment, ShardSpec shardSpec, String version, FileSystem fs, DataSegmentPusher dataSegmentPusher) throws IOException {
        boolean retry = true;
        DataSegment.Builder dataSegmentBuilder = new DataSegment.Builder(segment).version(version);
        Path finalPath = null;
        while (retry) {
            retry = false;
            dataSegmentBuilder.shardSpec(shardSpec);
            Path intermediatePath = DruidStorageHandlerUtils.getPath(segment);
            finalPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(dataSegmentBuilder.build(), INDEX_ZIP));
            fs.mkdirs(finalPath.getParent());
            if (fs.rename(intermediatePath, finalPath)) continue;
            if (fs.exists(finalPath)) {
                shardSpec = DruidStorageHandlerUtils.getNextPartitionShardSpec(shardSpec);
                retry = true;
                continue;
            }
            throw new IOException(String.format("Failed to rename intermediate segment[%s] to final segment[%s] is not present.", intermediatePath, finalPath));
        }
        DataSegment dataSegment = dataSegmentBuilder.loadSpec(dataSegmentPusher.makeLoadSpec(finalPath.toUri())).build();
        DruidStorageHandlerUtils.writeSegmentDescriptor(fs, dataSegment, new Path(finalPath.getParent(), DESCRIPTOR_JSON));
        return dataSegment;
    }

    private static ShardSpec getNextPartitionShardSpec(ShardSpec shardSpec) {
        if (shardSpec instanceof LinearShardSpec) {
            return new LinearShardSpec(shardSpec.getPartitionNum() + 1);
        }
        if (shardSpec instanceof NumberedShardSpec) {
            return new NumberedShardSpec(shardSpec.getPartitionNum(), ((NumberedShardSpec)shardSpec).getPartitions());
        }
        throw new IllegalStateException(String.format("Cannot expand shard spec [%s]", shardSpec));
    }

    static Path getPath(DataSegment dataSegment) {
        return new Path(String.valueOf(Objects.requireNonNull(dataSegment.getLoadSpec()).get("path")));
    }

    public static GranularitySpec getGranularitySpec(Configuration configuration, Properties tableProperties) {
        String segmentGranularity = tableProperties.getProperty("druid.segment.granularity") != null ? tableProperties.getProperty("druid.segment.granularity") : HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_INDEXING_GRANULARITY);
        boolean rollup = tableProperties.getProperty("druid.rollup") != null ? Boolean.parseBoolean(tableProperties.getProperty("druid.segment.granularity")) : HiveConf.getBoolVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_ROLLUP);
        return new UniformGranularitySpec(Granularity.fromString(segmentGranularity), Granularity.fromString(tableProperties.getProperty("druid.query.granularity") == null ? "NONE" : tableProperties.getProperty("druid.query.granularity")), rollup, null);
    }

    public static IndexSpec getIndexSpec(Configuration jc) {
        BitmapSerdeFactory bitmapSerdeFactory = "concise".equals(HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BITMAP_FACTORY_TYPE)) ? new ConciseBitmapSerdeFactory() : new RoaringBitmapSerdeFactory(true);
        return new IndexSpec(bitmapSerdeFactory, IndexSpec.DEFAULT_DIMENSION_COMPRESSION, IndexSpec.DEFAULT_METRIC_COMPRESSION, IndexSpec.DEFAULT_LONG_ENCODING);
    }

    public static Pair<List<DimensionSchema>, AggregatorFactory[]> getDimensionsAndAggregates(List<String> columnNames, List<TypeInfo> columnTypes) {
        ArrayList<StringDimensionSchema> dimensions = new ArrayList<StringDimensionSchema>();
        ImmutableList.Builder aggregatorFactoryBuilder = ImmutableList.builder();
        block8: for (int i = 0; i < columnTypes.size(); ++i) {
            NullableNumericAggregatorFactory af;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)columnTypes.get(i)).getPrimitiveCategory();
            switch (primitiveCategory) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    af = new LongSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case FLOAT: {
                    af = new FloatSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case DOUBLE: {
                    af = new DoubleSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case DECIMAL: {
                    throw new UnsupportedOperationException(String.format("Druid does not support decimal column type cast column [%s] to double", columnNames.get(i)));
                }
                case TIMESTAMP: {
                    String tColumnName = columnNames.get(i);
                    if (tColumnName.equals("__time_granularity") || tColumnName.equals("__time")) continue block8;
                    throw new IllegalArgumentException("Dimension " + tColumnName + " does not have STRING type: " + primitiveCategory);
                }
                case TIMESTAMPLOCALTZ: {
                    String tLocalTZColumnName = columnNames.get(i);
                    if (tLocalTZColumnName.equals("__time")) continue block8;
                    throw new IllegalArgumentException("Dimension " + tLocalTZColumnName + " does not have STRING type: " + primitiveCategory);
                }
                default: {
                    String dColumnName = columnNames.get(i);
                    if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)primitiveCategory) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                        throw new IllegalArgumentException("Dimension " + dColumnName + " does not have STRING type: " + primitiveCategory);
                    }
                    dimensions.add(new StringDimensionSchema(dColumnName));
                    continue block8;
                }
            }
            aggregatorFactoryBuilder.add(af);
        }
        ImmutableCollection aggregatorFactories = aggregatorFactoryBuilder.build();
        return Pair.of(dimensions, aggregatorFactories.toArray(new AggregatorFactory[0]));
    }

    public static Query addDynamicFilters(Query query, ExprNodeGenericFuncDesc filterExpr, Configuration conf, boolean resolveDynamicValues) {
        List<VirtualColumn> virtualColumns = Arrays.asList(DruidStorageHandlerUtils.getVirtualColumns(query).getVirtualColumns());
        Query rv = query;
        DimFilter joinReductionFilter = DruidStorageHandlerUtils.toDruidFilter((ExprNodeDesc)filterExpr, conf, virtualColumns, resolveDynamicValues);
        if (joinReductionFilter != null) {
            String type = query.getType();
            AndDimFilter filter = new AndDimFilter(joinReductionFilter, query.getFilter());
            switch (type) {
                case "timeseries": {
                    rv = Druids.TimeseriesQueryBuilder.copy((TimeseriesQuery)query).filters(filter).virtualColumns(VirtualColumns.create(virtualColumns)).build();
                    break;
                }
                case "topN": {
                    rv = new TopNQueryBuilder((TopNQuery)query).filters(filter).virtualColumns(VirtualColumns.create(virtualColumns)).build();
                    break;
                }
                case "groupBy": {
                    rv = new GroupByQuery.Builder((GroupByQuery)query).setDimFilter(filter).setVirtualColumns(VirtualColumns.create(virtualColumns)).build();
                    break;
                }
                case "scan": {
                    rv = Druids.ScanQueryBuilder.copy((ScanQuery)query).filters(filter).virtualColumns(VirtualColumns.create(virtualColumns)).build();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Query type " + type);
                }
            }
        }
        return rv;
    }

    @Nullable
    private static DimFilter toDruidFilter(ExprNodeDesc filterExpr, Configuration configuration, List<VirtualColumn> virtualColumns, boolean resolveDynamicValues) {
        String col;
        List child;
        DimFilter filter;
        ArrayList<DimFilter> delegates;
        Iterator iterator;
        if (filterExpr == null) {
            return null;
        }
        Class<? extends GenericUDF> genericUDFClass = DruidStorageHandlerUtils.getGenericUDFClassFromExprDesc(filterExpr);
        if (FunctionRegistry.isOpAnd((ExprNodeDesc)filterExpr)) {
            iterator = filterExpr.getChildren().iterator();
            delegates = Lists.newArrayList();
            while (iterator.hasNext()) {
                filter = DruidStorageHandlerUtils.toDruidFilter((ExprNodeDesc)iterator.next(), configuration, virtualColumns, resolveDynamicValues);
                if (filter == null) continue;
                delegates.add(filter);
            }
            if (!delegates.isEmpty()) {
                return new AndDimFilter(delegates);
            }
        }
        if (FunctionRegistry.isOpOr((ExprNodeDesc)filterExpr)) {
            iterator = filterExpr.getChildren().iterator();
            delegates = Lists.newArrayList();
            while (iterator.hasNext()) {
                filter = DruidStorageHandlerUtils.toDruidFilter((ExprNodeDesc)iterator.next(), configuration, virtualColumns, resolveDynamicValues);
                if (filter == null) continue;
                delegates.add(filter);
            }
            if (!delegates.isEmpty()) {
                return new OrDimFilter(delegates);
            }
        } else if (GenericUDFBetween.class == genericUDFClass) {
            child = filterExpr.getChildren();
            col = DruidStorageHandlerUtils.extractColName((ExprNodeDesc)child.get(1), virtualColumns);
            if (col != null) {
                try {
                    StringComparator comparator = stringTypeInfos.contains(((ExprNodeDesc)child.get(1)).getTypeInfo()) ? StringComparators.LEXICOGRAPHIC : StringComparators.NUMERIC;
                    String lower = DruidStorageHandlerUtils.evaluate((ExprNodeDesc)child.get(2), configuration, resolveDynamicValues);
                    String upper = DruidStorageHandlerUtils.evaluate((ExprNodeDesc)child.get(3), configuration, resolveDynamicValues);
                    return new BoundDimFilter(col, lower, upper, false, false, null, null, comparator);
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (GenericUDFInBloomFilter.class == genericUDFClass && (col = DruidStorageHandlerUtils.extractColName((ExprNodeDesc)(child = filterExpr.getChildren()).get(0), virtualColumns)) != null) {
            try {
                BloomKFilter bloomFilter = DruidStorageHandlerUtils.evaluateBloomFilter((ExprNodeDesc)child.get(1), configuration, resolveDynamicValues);
                return new BloomDimFilter(col, BloomKFilterHolder.fromBloomKFilter(bloomFilter), null);
            }
            catch (IOException | HiveException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String evaluate(ExprNodeDesc desc, Configuration configuration, boolean resolveDynamicValue) throws HiveException {
        ExprNodeEvaluator exprNodeEvaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)desc, (Configuration)configuration);
        if (exprNodeEvaluator instanceof ExprNodeDynamicValueEvaluator && !resolveDynamicValue) {
            return desc.getExprStringForExplain();
        }
        return exprNodeEvaluator.evaluate(null).toString();
    }

    private static BloomKFilter evaluateBloomFilter(ExprNodeDesc desc, Configuration configuration, boolean resolveDynamicValue) throws HiveException, IOException {
        if (!resolveDynamicValue) {
            return new BloomKFilter(1L);
        }
        BytesWritable bw = (BytesWritable)ExprNodeEvaluatorFactory.get((ExprNodeDesc)desc, (Configuration)configuration).evaluate(null);
        return BloomKFilter.deserialize(ByteBuffer.wrap(bw.getBytes()));
    }

    @Nullable
    public static String extractColName(ExprNodeDesc expr, List<VirtualColumn> virtualColumns) {
        if (!druidSupportedTypeInfos.contains(expr.getTypeInfo())) {
            return null;
        }
        if (expr instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)expr).getColumn();
        }
        ExprNodeGenericFuncDesc funcDesc = null;
        if (expr instanceof ExprNodeGenericFuncDesc) {
            funcDesc = (ExprNodeGenericFuncDesc)expr;
        }
        if (null == funcDesc) {
            return null;
        }
        GenericUDF udf = funcDesc.getGenericUDF();
        if (funcDesc.getChildren().size() == 1 && funcDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
            return null;
        }
        String columnName = ((ExprNodeColumnDesc)funcDesc.getChildren().get(0)).getColumn();
        ValueType targetType = null;
        if (udf instanceof GenericUDFBridge) {
            Class udfClass = ((GenericUDFBridge)udf).getUdfClass();
            if (udfClass.equals(UDFToDouble.class)) {
                targetType = ValueType.DOUBLE;
            } else if (udfClass.equals(UDFToFloat.class)) {
                targetType = ValueType.FLOAT;
            } else if (udfClass.equals(UDFToLong.class)) {
                targetType = ValueType.LONG;
            }
        } else if (udf instanceof GenericUDFToString) {
            targetType = ValueType.STRING;
        }
        if (targetType == null) {
            return null;
        }
        String virtualColumnExpr = DruidQuery.format("CAST(%s, '%s')", columnName, targetType.toString());
        for (VirtualColumn column : virtualColumns) {
            if (!(column instanceof ExpressionVirtualColumn) || !((ExpressionVirtualColumn)column).getExpression().equals(virtualColumnExpr)) continue;
            return column.getOutputName();
        }
        Set<String> usedColumnNames = virtualColumns.stream().map(col -> col.getOutputName()).collect(Collectors.toSet());
        String name = SqlValidatorUtil.uniquify("vc", usedColumnNames, SqlValidatorUtil.EXPR_SUGGESTER);
        ExpressionVirtualColumn expressionVirtualColumn = new ExpressionVirtualColumn(name, virtualColumnExpr, targetType, ExprMacroTable.nil());
        virtualColumns.add(expressionVirtualColumn);
        return name;
    }

    public static VirtualColumns getVirtualColumns(Query query) {
        String type;
        switch (type = query.getType()) {
            case "timeseries": {
                return ((TimeseriesQuery)query).getVirtualColumns();
            }
            case "topN": {
                return ((TopNQuery)query).getVirtualColumns();
            }
            case "groupBy": {
                return ((GroupByQuery)query).getVirtualColumns();
            }
            case "scan": {
                return ((ScanQuery)query).getVirtualColumns();
            }
        }
        throw new UnsupportedOperationException("Unsupported Query type " + query);
    }

    @Nullable
    private static Class<? extends GenericUDF> getGenericUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        return genericFuncDesc.getGenericUDF().getClass();
    }

    static {
        NullHandling.initializeForTests();
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)new ExprMacroTable(ImmutableList.of(new LikeExprMacro(), new RegexpExtractExprMacro(), new TimestampCeilExprMacro(), new TimestampExtractExprMacro(), new TimestampFormatExprMacro(), new TimestampParseExprMacro(), new TimestampShiftExprMacro(), new TimestampFloorExprMacro(), new TrimExprMacro.BothTrimExprMacro(), new TrimExprMacro.LeftTrimExprMacro(), new TrimExprMacro.RightTrimExprMacro()))).addValue(ObjectMapper.class, (Object)JSON_MAPPER).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        JSON_MAPPER.setInjectableValues(injectableValues);
        SMILE_MAPPER.setInjectableValues(injectableValues);
        JSON_MAPPER.registerSubtypes(new NamedType(LinearShardSpec.class, "linear"));
        JSON_MAPPER.registerSubtypes(new NamedType(NumberedShardSpec.class, "numbered"));
        JSON_MAPPER.registerSubtypes(new NamedType(AvroParseSpec.class, "avro"));
        SMILE_MAPPER.registerSubtypes(new NamedType(AvroParseSpec.class, "avro"));
        JSON_MAPPER.registerSubtypes(new NamedType(AvroStreamInputRowParser.class, "avro_stream"));
        SMILE_MAPPER.registerSubtypes(new NamedType(AvroStreamInputRowParser.class, "avro_stream"));
        BloomFilterSerializersModule bloomFilterSerializersModule = new BloomFilterSerializersModule();
        JSON_MAPPER.registerModule(bloomFilterSerializersModule);
        SMILE_MAPPER.registerModule(bloomFilterSerializersModule);
        JSON_MAPPER.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            EmittingLogger.registerEmitter(new ServiceEmitter("druid-hive-indexer", InetAddress.getLocalHost().getHostName(), new NoopEmitter()));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
        INDEX_IO = new IndexIO(JSON_MAPPER, new DruidProcessingConfig(){

            @Override
            public String getFormatString() {
                return "%s-%s";
            }
        });
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, TmpFileSegmentWriteOutMediumFactory.instance());
        DATA_SEGMENT_INTERNER = Interners.newWeakInterner();
        druidSupportedTypeInfos = ImmutableSet.of(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.charTypeInfo, TypeInfoFactory.varcharTypeInfo, TypeInfoFactory.byteTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo, new TypeInfo[]{TypeInfoFactory.shortTypeInfo, TypeInfoFactory.doubleTypeInfo});
        stringTypeInfos = ImmutableSet.of(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.charTypeInfo, TypeInfoFactory.varcharTypeInfo);
    }

    public static interface DataPusher {
        public void push() throws IOException;
    }
}

