/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.Serializable;
import org.apache.hadoop.hive.druid.json.KafkaSupervisorReport;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;

public class DruidStorageHandlerInfo
implements StorageHandlerInfo {
    static final StorageHandlerInfo UNREACHABLE = (StorageHandlerInfo & Serializable)() -> "Druid Overlord is Unreachable, Runtime Status : unknown";
    private final KafkaSupervisorReport kafkaSupervisorReport;

    DruidStorageHandlerInfo(KafkaSupervisorReport kafkaSupervisorReport) {
        this.kafkaSupervisorReport = kafkaSupervisorReport;
    }

    public String formatAsText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Druid Storage Handler Runtime Status for ").append(this.kafkaSupervisorReport.getId()).append("\n").append("kafkaPartitions=").append(this.kafkaSupervisorReport.getPayload().getPartitions()).append("\n").append("activeTasks=").append(this.kafkaSupervisorReport.getPayload().getActiveTasks()).append("\n").append("publishingTasks=").append(this.kafkaSupervisorReport.getPayload().getPublishingTasks());
        if (this.kafkaSupervisorReport.getPayload().getLatestOffsets() != null) {
            sb.append("\n").append("latestOffsets=").append(this.kafkaSupervisorReport.getPayload().getLatestOffsets());
        }
        if (this.kafkaSupervisorReport.getPayload().getMinimumLag() != null) {
            sb.append("\n").append("minimumLag=").append(this.kafkaSupervisorReport.getPayload().getMinimumLag());
        }
        if (this.kafkaSupervisorReport.getPayload().getAggregateLag() != null) {
            sb.append("\n").append("aggregateLag=").append(this.kafkaSupervisorReport.getPayload().getAggregateLag());
        }
        if (this.kafkaSupervisorReport.getPayload().getOffsetsLastUpdated() != null) {
            sb.append("\n").append("lastUpdateTime=").append(this.kafkaSupervisorReport.getPayload().getOffsetsLastUpdated());
        }
        return sb.toString();
    }
}

