/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

abstract class TDCacheable
implements Cacheable {
    protected TableDescriptor td;
    protected final DataDictionaryImpl dd;

    TDCacheable(DataDictionaryImpl dd) {
        this.dd = dd;
    }

    @Override
    public void clean(boolean forRemove) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public TableDescriptor getTableDescriptor() {
        return this.td;
    }

    protected boolean checkConsistency(TableDescriptor uncachedTD, Object identity, HeaderPrintWriter reportInconsistent) throws StandardException {
        boolean retval = true;
        if (uncachedTD == null) {
            reportInconsistent.println("Inconsistent NameTDCacheable: identity = " + identity + ", uncached table descriptor not found.");
            retval = false;
        } else if (!(uncachedTD.getHeapConglomerateId() == this.td.getHeapConglomerateId() && uncachedTD.getUUID().equals(this.td.getUUID()) && uncachedTD.getSchemaName().equals(this.td.getSchemaName()) && uncachedTD.getName().equals(this.td.getName()) && uncachedTD.getTableType() == this.td.getTableType())) {
            reportInconsistent.println("Inconsistent NameTDCacheable: identity = " + identity + ", cached TD = " + this.td + ", uncached TD = " + uncachedTD);
            retval = false;
        }
        return retval;
    }
}

