/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import com.google.common.annotations.VisibleForTesting;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.saml.HttpSamlAuthenticationException;
import org.apache.hive.service.auth.saml.ISAMLAuthTokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlAuthTokenGenerator
implements ISAMLAuthTokenGenerator {
    private final long ttlMs;
    private final SecureRandom rand = new SecureRandom();
    private final byte[] signatureSecret = Long.toString(this.rand.nextLong()).getBytes();
    private static final String USER = "u";
    private static final String SEPARATOR = "=";
    private static final String ATTR_SEPARATOR = ";";
    private static final String ID = "id";
    private static final String CREATE_TIME = "time";
    public static final String RELAY_STATE = "rs";
    private static final String SIGN = "sg";
    private static HiveSamlAuthTokenGenerator INSTANCE;
    private static final Logger LOG;

    public static synchronized ISAMLAuthTokenGenerator get(HiveConf conf) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new HiveSamlAuthTokenGenerator(conf);
        return INSTANCE;
    }

    private HiveSamlAuthTokenGenerator(HiveConf conf) {
        this.ttlMs = conf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_CALLBACK_TOKEN_TTL, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    static synchronized void shutdown() {
        INSTANCE = null;
    }

    @Override
    public String get(String username, String relayStateKey) {
        String id = String.valueOf(this.rand.nextLong());
        String time = String.valueOf(System.currentTimeMillis());
        LOG.debug("Generating token for user {} with id {} and time {}", new Object[]{username, id, time});
        String tokenStr = this.getTokenStr(username, id, time, relayStateKey);
        return this.encode(this.sign(tokenStr));
    }

    private String encode(String token) {
        return Base64.getEncoder().encodeToString(token.getBytes());
    }

    private String decode(String encodedToken) {
        return new String(Base64.getDecoder().decode(encodedToken));
    }

    private String getTokenStr(String username, String id, String timestamp, String relayStateKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(USER).append(SEPARATOR).append(username).append(ATTR_SEPARATOR);
        sb.append(ID).append(SEPARATOR).append(id).append(ATTR_SEPARATOR);
        sb.append(CREATE_TIME).append(SEPARATOR).append(timestamp).append(ATTR_SEPARATOR);
        sb.append(RELAY_STATE).append(SEPARATOR).append(relayStateKey);
        return sb.toString();
    }

    private String getSign(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input.getBytes());
            md.update(this.signatureSecret);
            byte[] digest = md.digest();
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String sign(String input) {
        return input + ATTR_SEPARATOR + SIGN + SEPARATOR + this.getSign(input);
    }

    @Override
    public String validate(String encodedToken) throws HttpSamlAuthenticationException {
        HashMap<String, String> keyValue;
        String token = this.decode(encodedToken);
        if (!HiveSamlAuthTokenGenerator.parse(token, keyValue = new HashMap<String, String>())) {
            throw new HttpSamlAuthenticationException("Invalid token");
        }
        String tokenStr = this.getTokenStr((String)keyValue.get(USER), (String)keyValue.get(ID), (String)keyValue.get(CREATE_TIME), (String)keyValue.get(RELAY_STATE));
        String signature = this.getSign(tokenStr);
        if (!this.signatureMatches((String)keyValue.get(SIGN), signature)) {
            throw new HttpSamlAuthenticationException("Token could not be verified");
        }
        if (this.isExpired(System.currentTimeMillis(), Long.parseLong((String)keyValue.get(CREATE_TIME)))) {
            throw new HttpSamlAuthenticationException("Token is expired");
        }
        return (String)keyValue.get(USER);
    }

    private boolean isExpired(long currentTime, long tokenTime) {
        LOG.debug("Checking if the token is expired or not. CurrentTime = {}, tokenExpiryTime = {} TTL = {}", new Object[]{currentTime, tokenTime, this.ttlMs});
        if (currentTime >= tokenTime) {
            return currentTime - tokenTime > this.ttlMs;
        }
        return false;
    }

    private boolean signatureMatches(String origSign, String derivedSign) {
        return !MessageDigest.isEqual(origSign.getBytes(), derivedSign.getBytes());
    }

    public static boolean parse(String token, Map<String, String> kv) {
        String[] splits = token.split(ATTR_SEPARATOR);
        if (splits.length != 5) {
            return false;
        }
        for (String split : splits) {
            String[] pair = split.split(SEPARATOR);
            if (pair.length != 2) {
                return false;
            }
            kv.put(pair[0], pair[1]);
        }
        return kv.containsKey(USER) && kv.containsKey(CREATE_TIME) && kv.containsKey(ID) && kv.containsKey(SIGN) && kv.containsKey(RELAY_STATE);
    }

    static {
        LOG = LoggerFactory.getLogger(HiveSamlAuthTokenGenerator.class);
    }
}

