/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyUserSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUserSupport.class);
    private static final String CONF_PROXYUSER_PREFIX = "webhcat.proxyuser.";
    private static final String CONF_GROUPS_SUFFIX = ".groups";
    private static final String CONF_HOSTS_SUFFIX = ".hosts";
    private static final Set<String> WILD_CARD = Collections.unmodifiableSet(new HashSet(0));
    private static final Map<String, Set<String>> proxyUserGroups = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> proxyUserHosts = new HashMap<String, Set<String>>();

    ProxyUserSupport() {
    }

    static void processProxyuserConfig(AppConfig conf) {
        Iterator iterator = conf.iterator();
        while (iterator.hasNext()) {
            Set<String> hosts;
            String proxyUser;
            Map.Entry confEnt = (Map.Entry)iterator.next();
            if (((String)confEnt.getKey()).startsWith(CONF_PROXYUSER_PREFIX) && ((String)confEnt.getKey()).endsWith(CONF_GROUPS_SUFFIX)) {
                Set<String> groups;
                proxyUser = ((String)confEnt.getKey()).substring(CONF_PROXYUSER_PREFIX.length(), ((String)confEnt.getKey()).lastIndexOf(CONF_GROUPS_SUFFIX));
                if ("*".equals(confEnt.getValue())) {
                    groups = WILD_CARD;
                    LOG.debug("User [{}] is authorized to do doAs any user.", (Object)proxyUser);
                } else if (confEnt.getValue() != null && ((String)confEnt.getValue()).trim().length() > 0) {
                    groups = new HashSet<String>(Arrays.asList(((String)confEnt.getValue()).trim().split(",")));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User [" + proxyUser + "] is authorized to do doAs for users in the following groups: [" + ((String)confEnt.getValue()).trim() + "]");
                    }
                } else {
                    groups = Collections.emptySet();
                    LOG.debug("User [{}] is authorized to do doAs for users in the following groups: []", (Object)proxyUser);
                }
                proxyUserGroups.put(proxyUser, groups);
                continue;
            }
            if (!((String)confEnt.getKey()).startsWith(CONF_PROXYUSER_PREFIX) || !((String)confEnt.getKey()).endsWith(CONF_HOSTS_SUFFIX)) continue;
            proxyUser = ((String)confEnt.getKey()).substring(CONF_PROXYUSER_PREFIX.length(), ((String)confEnt.getKey()).lastIndexOf(CONF_HOSTS_SUFFIX));
            if ("*".equals(confEnt.getValue())) {
                hosts = WILD_CARD;
                LOG.debug("User [{}] is authorized to do doAs from any host.", (Object)proxyUser);
            } else if (confEnt.getValue() != null && ((String)confEnt.getValue()).trim().length() > 0) {
                String[] hostValues = ((String)confEnt.getValue()).trim().split(",");
                hosts = new HashSet<String>();
                for (String hostname : hostValues) {
                    String nhn = ProxyUserSupport.normalizeHostname(hostname);
                    if (nhn == null) continue;
                    hosts.add(nhn);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User [" + proxyUser + "] is authorized to do doAs from the following hosts: [" + ((String)confEnt.getValue()).trim() + "]");
                }
            } else {
                hosts = Collections.emptySet();
                LOG.debug("User [{}] is authorized to do doAs from the following hosts: []", (Object)proxyUser);
            }
            proxyUserHosts.put(proxyUser, hosts);
        }
    }

    static void validate(String proxyUser, String proxyHost, String doAsUser) throws NotAuthorizedException {
        ProxyUserSupport.assertNotEmpty(proxyUser, "proxyUser", "If you're attempting to use user-impersonation via a proxy user, please make sure that webhcat.proxyuser.#USER#.hosts and webhcat.proxyuser.#USER#.groups are configured correctly");
        ProxyUserSupport.assertNotEmpty(proxyHost, "proxyHost", "If you're attempting to use user-impersonation via a proxy user, please make sure that webhcat.proxyuser." + proxyUser + CONF_HOSTS_SUFFIX + " and " + CONF_PROXYUSER_PREFIX + proxyUser + CONF_GROUPS_SUFFIX + " are configured correctly");
        ProxyUserSupport.assertNotEmpty(doAsUser, "doAs");
        LOG.debug(MessageFormat.format("Authorization check proxyuser [{0}] host [{1}] doAs [{2}]", proxyUser, proxyHost, doAsUser));
        if (!proxyUserHosts.containsKey(proxyUser)) {
            throw new NotAuthorizedException(MessageFormat.format("User [{0}] not defined as proxyuser", proxyUser));
        }
        proxyHost = ProxyUserSupport.normalizeHostname(proxyHost);
        ProxyUserSupport.validateRequestorHost(proxyUser, proxyHost);
        ProxyUserSupport.validateGroup(proxyUser, doAsUser);
    }

    private static void validateRequestorHost(String proxyUser, String hostname) throws NotAuthorizedException {
        Set<String> validHosts = proxyUserHosts.get(proxyUser);
        if (validHosts == WILD_CARD) {
            return;
        }
        if (validHosts == null || !validHosts.contains(hostname)) {
            throw new NotAuthorizedException(MessageFormat.format("Unauthorized host [{0}] for proxyuser [{1}]", hostname, proxyUser));
        }
    }

    private static void validateGroup(String proxyUser, String doAsUser) throws NotAuthorizedException {
        Set<String> validGroups = proxyUserGroups.get(proxyUser);
        if (validGroups == WILD_CARD) {
            return;
        }
        if (validGroups == null || validGroups.isEmpty()) {
            throw new NotAuthorizedException(MessageFormat.format("Unauthorized proxyuser [{0}] for doAsUser [{1}], not in proxyuser groups", proxyUser, doAsUser));
        }
        Groups groupsInfo = new Groups((Configuration)Main.getAppConfigInstance());
        try {
            List userGroups = groupsInfo.getGroups(doAsUser);
            for (String g : validGroups) {
                if (!userGroups.contains(g)) continue;
                return;
            }
        }
        catch (IOException ex) {
            LOG.warn(MessageFormat.format("Unable to get list of groups for doAsUser [{0}].", doAsUser), (Throwable)ex);
        }
        throw new NotAuthorizedException(MessageFormat.format("Unauthorized proxyuser [{0}] for doAsUser [{1}], not in proxyuser groups", proxyUser, doAsUser));
    }

    private static String normalizeHostname(String name) {
        try {
            InetAddress address = InetAddress.getByName("localhost".equalsIgnoreCase(name) ? null : name);
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            LOG.warn(MessageFormat.format("Unable to normalize hostname [{0}]", name));
            return null;
        }
    }

    private static String assertNotEmpty(String str, String name) {
        return ProxyUserSupport.assertNotEmpty(str, name, null);
    }

    private static String assertNotEmpty(String str, String name, String info) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null" + (info == null ? "" : ", " + info));
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty" + (info == null ? "" : ", " + info));
        }
        return str;
    }
}

