/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobCallable<T>
implements Callable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JobCallable.class);
    private JobState jobState = JobState.STARTED;
    public T returnResult = null;

    public boolean setJobStateFailed() {
        return this.setStateAndResult(JobState.FAILED, null);
    }

    public boolean setJobStateCompleted(T result) {
        return this.setStateAndResult(JobState.COMPLETED, result);
    }

    private synchronized boolean setStateAndResult(JobState jobState, T result) {
        if (this.jobState == JobState.STARTED) {
            this.jobState = jobState;
            this.returnResult = result;
            return true;
        }
        LOG.info("Failed to set job state to " + (Object)((Object)jobState) + " due to job state " + (Object)((Object)this.jobState) + ". Expected state is " + (Object)((Object)JobState.STARTED));
        return false;
    }

    @Override
    public T call() throws Exception {
        T result = this.execute();
        if (!this.setJobStateCompleted(result)) {
            this.cleanup();
            return null;
        }
        return this.returnResult;
    }

    public abstract T execute() throws Exception;

    public void cleanup() {
    }

    public static enum JobState {
        STARTED,
        FAILED,
        COMPLETED;

    }
}

