/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.ExecBean;
import org.apache.hive.hcatalog.templeton.ExecService;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.MaxByteArrayOutputStream;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecServiceImpl
implements ExecService {
    private static final Logger LOG = LoggerFactory.getLogger(ExecServiceImpl.class);
    private static AppConfig appConf = Main.getAppConfigInstance();
    private static volatile ExecServiceImpl theSingleton;
    private static final Object WindowsProcessLaunchLock;
    private Semaphore avail = new Semaphore(appConf.getInt("templeton.exec.max-procs", 16));

    public static synchronized ExecServiceImpl getInstance() {
        if (theSingleton == null) {
            theSingleton = new ExecServiceImpl();
        }
        return theSingleton;
    }

    private ExecServiceImpl() {
    }

    @Override
    public ExecBean run(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, BusyException, ExecuteException, IOException {
        boolean acquired = false;
        try {
            acquired = this.avail.tryAcquire();
            if (acquired) {
                ExecBean execBean = this.runUnlimited(program, args, env);
                return execBean;
            }
            throw new BusyException();
        }
        finally {
            if (acquired) {
                this.avail.release();
            }
        }
    }

    @Override
    public ExecBean runUnlimited(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, ExecuteException, IOException {
        try {
            return this.auxRun(program, args, env);
        }
        catch (IOException e) {
            File cwd = new File(".");
            if (cwd.canRead() && cwd.canWrite()) {
                throw e;
            }
            throw new IOException("Invalid permissions on Templeton directory: " + cwd.getCanonicalPath());
        }
    }

    private ExecBean auxRun(String program, List<String> args, Map<String, String> env) throws NotAuthorizedException, ExecuteException, IOException {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValues(null);
        int nbytes = appConf.getInt("templeton.exec.max-output-bytes", -1);
        MaxByteArrayOutputStream outStream = new MaxByteArrayOutputStream(nbytes);
        MaxByteArrayOutputStream errStream = new MaxByteArrayOutputStream(nbytes);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream));
        int timeout = appConf.getInt("templeton.exec.timeout", 0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        executor.setWatchdog(watchdog);
        CommandLine cmd = this.makeCommandLine(program, args);
        LOG.info("Running: " + cmd);
        ExecBean res = new ExecBean();
        res.exitcode = executor.execute(cmd, this.execEnv(env));
        String enc = appConf.get("templeton.exec.encoding");
        res.stdout = outStream.toString(enc);
        res.stderr = errStream.toString(enc);
        try {
            watchdog.checkException();
        }
        catch (Exception ex) {
            LOG.error("Command: " + cmd + " failed. res=" + res, (Throwable)ex);
        }
        if (watchdog.killedProcess()) {
            String msg = " was terminated due to timeout(" + timeout + "ms).  See " + "templeton.exec.timeout" + " property";
            LOG.warn("Command: " + cmd + msg + " res=" + res);
            res.stderr = res.stderr + " Command " + msg;
        }
        if (res.exitcode != 0) {
            LOG.info("Command: " + cmd + " failed. res=" + res);
        }
        return res;
    }

    private CommandLine makeCommandLine(String program, List<String> args) throws NotAuthorizedException, IOException {
        String path = this.validateProgram(program);
        CommandLine cmd = new CommandLine(path);
        if (args != null) {
            for (String arg : args) {
                cmd.addArgument(arg, false);
            }
        }
        return cmd;
    }

    public Map<String, String> execEnv(Map<String, String> env) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : appConf.getStrings("templeton.exec.envs")) {
            String val = System.getenv(key);
            if (val == null) continue;
            res.put(key, val);
        }
        if (env != null) {
            res.putAll(env);
        }
        for (Map.Entry entry : res.entrySet()) {
            LOG.info("Env " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return res;
    }

    public String validateProgram(String path) throws NotAuthorizedException, IOException {
        File f = new File(path);
        if (f.canExecute()) {
            return f.getCanonicalPath();
        }
        throw new NotAuthorizedException("Unable to access program: " + path);
    }

    static {
        WindowsProcessLaunchLock = new Object();
    }
}

