/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;
import org.apache.orc.tools.json.UnionType;

class StructType
extends HiveType {
    private static final String COL_PREFIX = "_col";
    private static final Comparator<String> FIELD_COMPARATOR = (left, right) -> {
        if (left == null) {
            if (right != null) return -1;
            return 0;
        }
        if (right == null) {
            return 1;
        }
        if (left.startsWith(COL_PREFIX)) {
            if (!right.startsWith(COL_PREFIX)) return 1;
            try {
                int leftInt = Integer.parseInt(left.substring(COL_PREFIX.length()));
                int rightInt = Integer.parseInt(right.substring(COL_PREFIX.length()));
                return Integer.compare(leftInt, rightInt);
            }
            catch (Exception exception) {
                return left.compareTo((String)right);
            }
        } else {
            if (!right.startsWith(COL_PREFIX)) return left.compareTo((String)right);
            return 1;
        }
    };
    final Map<String, HiveType> fields = new TreeMap<String, HiveType>(FIELD_COMPARATOR);

    StructType() {
        super(HiveType.Kind.STRUCT);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("struct<");
        boolean first = true;
        for (Map.Entry<String, HiveType> field : this.fields.entrySet()) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(field.getKey());
            buf.append(':');
            buf.append(field.getValue().toString());
        }
        buf.append(">");
        return buf.toString();
    }

    public StructType addField(String name, HiveType fieldType) {
        this.fields.put(name, fieldType);
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.fields.equals(((StructType)other).fields);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() * 3;
        for (Map.Entry<String, HiveType> pair : this.fields.entrySet()) {
            result += pair.getKey().hashCode() * 17 + pair.getValue().hashCode();
        }
        return result;
    }

    @Override
    public boolean subsumes(HiveType other) {
        return other.kind == HiveType.Kind.NULL || other.kind == HiveType.Kind.STRUCT;
    }

    @Override
    public void merge(HiveType other) {
        if (other.getClass() == StructType.class) {
            StructType otherStruct = (StructType)other;
            for (Map.Entry<String, HiveType> pair : otherStruct.fields.entrySet()) {
                HiveType ourField = this.fields.get(pair.getKey());
                if (ourField == null) {
                    this.fields.put(pair.getKey(), pair.getValue());
                    continue;
                }
                if (ourField.subsumes(pair.getValue())) {
                    ourField.merge(pair.getValue());
                    continue;
                }
                if (pair.getValue().subsumes(ourField)) {
                    pair.getValue().merge(ourField);
                    this.fields.put(pair.getKey(), pair.getValue());
                    continue;
                }
                this.fields.put(pair.getKey(), new UnionType(ourField, pair.getValue()));
            }
        }
    }

    @Override
    public void printFlat(PrintStream out, String prefix) {
        prefix = prefix + ".";
        for (Map.Entry<String, HiveType> field : this.fields.entrySet()) {
            field.getValue().printFlat(out, prefix + field.getKey());
        }
    }

    @Override
    public TypeDescription getSchema() {
        TypeDescription result = TypeDescription.createStruct();
        for (Map.Entry<String, HiveType> child : this.fields.entrySet()) {
            result.addField(child.getKey(), child.getValue().getSchema());
        }
        return result;
    }
}

