/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;

class StringType
extends HiveType {
    StringType(HiveType.Kind kind) {
        super(kind);
    }

    public String toString() {
        switch (this.kind) {
            case BINARY: {
                return "binary";
            }
            case STRING: {
                return "string";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case TIMESTAMP_INSTANT: {
                return "timestamp with local time zone";
            }
            case DATE: {
                return "date";
            }
        }
        throw new IllegalArgumentException("Unknown kind " + (Object)((Object)this.kind));
    }

    @Override
    public boolean subsumes(HiveType other) {
        return other.getClass() == StringType.class || other.kind == HiveType.Kind.NULL;
    }

    @Override
    public void merge(HiveType other) {
        if (other.getClass() == StringType.class && this.kind != other.kind) {
            this.kind = HiveType.Kind.STRING;
        }
    }

    @Override
    public TypeDescription getSchema() {
        switch (this.kind) {
            case BINARY: {
                return TypeDescription.createBinary();
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case TIMESTAMP: {
                return TypeDescription.createTimestamp();
            }
            case TIMESTAMP_INSTANT: {
                return TypeDescription.createTimestampInstant();
            }
            case DATE: {
                return TypeDescription.createDate();
            }
        }
        throw new IllegalArgumentException("Unknown kind " + (Object)((Object)this.kind));
    }
}

