/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonStreamParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.TypeDescription;
import org.apache.orc.TypeDescriptionPrettyPrint;
import org.apache.orc.tools.json.BooleanType;
import org.apache.orc.tools.json.HiveType;
import org.apache.orc.tools.json.ListType;
import org.apache.orc.tools.json.MapType;
import org.apache.orc.tools.json.NullType;
import org.apache.orc.tools.json.NumericType;
import org.apache.orc.tools.json.StringType;
import org.apache.orc.tools.json.StructType;
import org.apache.orc.tools.json.UnionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFinder {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSchemaFinder.class);
    private static final Pattern HEX_PATTERN = Pattern.compile("^([0-9a-fA-F][0-9a-fA-F])+$");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^[\"]?([0-9]{4}[-/][0-9]{2}[-/][0-9]{2})[T ]([0-9]{2}:[0-9]{2}:[0-9]{2})(( [-+]?|[-+])([0-9]{2}(:[0-9]{2})?)|Z)?[\"]?$");
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("^-?(?<int>[0-9]+)([.](?<fraction>[0-9]+))?$");
    private static final int INDENT = 2;
    private static final int MAX_DECIMAL_DIGITS = 38;
    static final BigInteger MIN_LONG = new BigInteger("-9223372036854775808");
    static final BigInteger MAX_LONG = new BigInteger("9223372036854775807");
    private HiveType mergedType = null;
    private long records = 0L;

    static HiveType pickType(JsonElement json) {
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = (JsonPrimitive)json;
            if (prim.isBoolean()) {
                return new BooleanType();
            }
            if (prim.isNumber()) {
                double value;
                Matcher matcher = DECIMAL_PATTERN.matcher(prim.getAsString());
                if (matcher.matches()) {
                    int scale;
                    int intDigits = matcher.group("int").length();
                    String fraction = matcher.group("fraction");
                    int n = scale = fraction == null ? 0 : fraction.length();
                    if (scale == 0) {
                        BigInteger val;
                        if (intDigits < 19) {
                            long value2 = prim.getAsLong();
                            if (value2 >= -128L && value2 < 128L) {
                                return new NumericType(HiveType.Kind.BYTE, intDigits, scale);
                            }
                            if (value2 >= -32768L && value2 < 32768L) {
                                return new NumericType(HiveType.Kind.SHORT, intDigits, scale);
                            }
                            if (value2 >= Integer.MIN_VALUE && value2 < 0x80000000L) {
                                return new NumericType(HiveType.Kind.INT, intDigits, scale);
                            }
                            return new NumericType(HiveType.Kind.LONG, intDigits, scale);
                        }
                        if (intDigits == 19 && (val = prim.getAsBigInteger()).compareTo(MIN_LONG) >= 0 && val.compareTo(MAX_LONG) <= 0) {
                            return new NumericType(HiveType.Kind.LONG, intDigits, scale);
                        }
                    }
                    if (intDigits + scale <= 38) {
                        return new NumericType(HiveType.Kind.DECIMAL, intDigits, scale);
                    }
                }
                if ((value = prim.getAsDouble()) >= (double)1.4E-45f && value <= 3.4028234663852886E38) {
                    return new NumericType(HiveType.Kind.FLOAT, 0, 0);
                }
                return new NumericType(HiveType.Kind.DOUBLE, 0, 0);
            }
            String str = prim.getAsString();
            if (TIMESTAMP_PATTERN.matcher(str).matches()) {
                return new StringType(HiveType.Kind.TIMESTAMP);
            }
            if (HEX_PATTERN.matcher(str).matches()) {
                return new StringType(HiveType.Kind.BINARY);
            }
            return new StringType(HiveType.Kind.STRING);
        }
        if (json.isJsonNull()) {
            return new NullType();
        }
        if (json.isJsonArray()) {
            ListType result = new ListType();
            result.elementType = new NullType();
            for (JsonElement child : (JsonArray)json) {
                HiveType sub = JsonSchemaFinder.pickType(child);
                if (result.elementType.subsumes(sub)) {
                    result.elementType.merge(sub);
                    continue;
                }
                if (sub.subsumes(result.elementType)) {
                    sub.merge(result.elementType);
                    result.elementType = sub;
                    continue;
                }
                result.elementType = new UnionType(result.elementType, sub);
            }
            return result;
        }
        JsonObject obj = (JsonObject)json;
        StructType result = new StructType();
        for (Map.Entry field : obj.entrySet()) {
            String fieldName = (String)field.getKey();
            HiveType type = JsonSchemaFinder.pickType((JsonElement)field.getValue());
            result.fields.put(fieldName, type);
        }
        return result;
    }

    static HiveType mergeType(HiveType previous, HiveType type) {
        if (previous == null) {
            return type;
        }
        if (type == null) {
            return previous;
        }
        if (previous.subsumes(type)) {
            previous.merge(type);
        } else if (type.subsumes(previous)) {
            type.merge(previous);
            previous = type;
        } else {
            previous = new UnionType(previous, type);
        }
        return previous;
    }

    static void printType(PrintStream out, HiveType type, int margin) {
        if (type == null) {
            out.print("void");
        } else if (type.kind.isPrimitive) {
            out.print(type.toString());
        } else {
            switch (type.kind) {
                case STRUCT: {
                    out.println("struct <");
                    boolean first = true;
                    for (Map.Entry<String, HiveType> field : ((StructType)type).fields.entrySet()) {
                        if (!first) {
                            out.println(",");
                        } else {
                            first = false;
                        }
                        for (int i = 0; i < margin; ++i) {
                            out.print(' ');
                        }
                        out.print(field.getKey());
                        out.print(": ");
                        JsonSchemaFinder.printType(out, field.getValue(), margin + 2);
                    }
                    out.print(">");
                    break;
                }
                case LIST: {
                    out.print("array <");
                    JsonSchemaFinder.printType(out, ((ListType)type).elementType, margin + 2);
                    out.print(">");
                    break;
                }
                case UNION: {
                    out.print("uniontype <");
                    boolean first = true;
                    for (HiveType child : ((UnionType)type).children) {
                        if (!first) {
                            out.print(',');
                        } else {
                            first = false;
                        }
                        JsonSchemaFinder.printType(out, child, margin + 2);
                    }
                    out.print(">");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown kind " + (Object)((Object)type.kind));
                }
            }
        }
    }

    static void printAsTable(PrintStream out, StructType type) {
        out.println("create table tbl (");
        boolean first = true;
        for (Map.Entry<String, HiveType> field : type.fields.entrySet()) {
            if (!first) {
                out.println(",");
            } else {
                first = false;
            }
            for (int i = 0; i < 2; ++i) {
                out.print(' ');
            }
            out.print(field.getKey());
            out.print(" ");
            JsonSchemaFinder.printType(out, field.getValue(), 4);
        }
        out.println();
        out.println(")");
    }

    public void addFile(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStreamReader reader = filename.endsWith(".gz") ? new InputStreamReader((InputStream)new GZIPInputStream(inputStream), StandardCharsets.UTF_8) : new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        this.addFile(reader, filename);
    }

    public void addFile(Reader reader, String filename) {
        JsonStreamParser parser = new JsonStreamParser(reader);
        try {
            while (parser.hasNext()) {
                this.mergedType = JsonSchemaFinder.mergeType(this.mergedType, JsonSchemaFinder.pickType(parser.next()));
                ++this.records;
            }
        }
        catch (JsonParseException e) {
            this.printParseExceptionMsg(e, filename);
        }
    }

    private void printParseExceptionMsg(JsonParseException e, String filename) {
        System.err.printf("A JsonParseException was thrown while processing the %dth record of file %s.%n", this.records + 1L, filename);
        String pattern = "at line (\\d+) column (\\d+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(e.getMessage());
        if (m.find()) {
            int line = Integer.parseInt(m.group(1));
            int column = Integer.parseInt(m.group(2));
            if (line == 1 && column == 1) {
                System.err.printf("File %s is empty.%n", filename);
                System.exit(1);
            }
        }
        System.err.printf("Please check the file.%n%n%s%n", ExceptionUtils.getStackTrace((Throwable)e));
        System.exit(1);
    }

    HiveType makeHiveType(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanType();
            }
            case BYTE: {
                return new NumericType(HiveType.Kind.BYTE, 3, 0);
            }
            case SHORT: {
                return new NumericType(HiveType.Kind.SHORT, 5, 0);
            }
            case INT: {
                return new NumericType(HiveType.Kind.INT, 10, 0);
            }
            case LONG: {
                return new NumericType(HiveType.Kind.LONG, 19, 0);
            }
            case FLOAT: {
                return new NumericType(HiveType.Kind.FLOAT, 0, 0);
            }
            case DOUBLE: {
                return new NumericType(HiveType.Kind.DOUBLE, 0, 0);
            }
            case DECIMAL: {
                int scale = schema.getScale();
                int intDigits = schema.getPrecision() - scale;
                return new NumericType(HiveType.Kind.DECIMAL, intDigits, scale);
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return new StringType(HiveType.Kind.STRING);
            }
            case TIMESTAMP: {
                return new StringType(HiveType.Kind.TIMESTAMP);
            }
            case TIMESTAMP_INSTANT: {
                return new StringType(HiveType.Kind.TIMESTAMP_INSTANT);
            }
            case DATE: {
                return new StringType(HiveType.Kind.DATE);
            }
            case BINARY: {
                return new StringType(HiveType.Kind.BINARY);
            }
            case LIST: {
                return new ListType(this.makeHiveType((TypeDescription)schema.getChildren().get(0)));
            }
            case STRUCT: {
                StructType result = new StructType();
                List fields = schema.getFieldNames();
                List children = schema.getChildren();
                for (int i = 0; i < fields.size(); ++i) {
                    result.addField((String)fields.get(i), this.makeHiveType((TypeDescription)children.get(i)));
                }
                return result;
            }
            case UNION: {
                UnionType result = new UnionType();
                for (TypeDescription child : schema.getChildren()) {
                    result.addType(this.makeHiveType(child));
                }
                return result;
            }
            case MAP: {
                return new MapType(this.makeHiveType((TypeDescription)schema.getChildren().get(0)), this.makeHiveType((TypeDescription)schema.getChildren().get(1)));
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    public void addSchema(TypeDescription schema) {
        this.mergedType = JsonSchemaFinder.mergeType(this.mergedType, this.makeHiveType(schema));
    }

    public TypeDescription getSchema() {
        return this.mergedType.getSchema();
    }

    public static void main(Configuration conf, String[] args) throws Exception {
        JsonSchemaFinder result = new JsonSchemaFinder();
        CommandLine cli = JsonSchemaFinder.parseArguments(args);
        for (String filename : cli.getArgs()) {
            System.err.println("Reading file " + filename);
            result.addFile(filename);
        }
        System.err.println(result.records + " records read");
        System.err.println();
        if (cli.hasOption('f')) {
            result.mergedType.printFlat(System.out, "root");
        } else if (cli.hasOption('t')) {
            JsonSchemaFinder.printAsTable(System.out, (StructType)result.mergedType);
        } else if (cli.hasOption('p')) {
            TypeDescriptionPrettyPrint.print((PrintStream)System.out, (TypeDescription)result.getSchema());
        } else {
            System.out.println(result.getSchema());
        }
    }

    static CommandLine parseArguments(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("Provide help").build());
        options.addOption(Option.builder((String)"f").longOpt("flat").desc("Print types as flat list of types").build());
        options.addOption(Option.builder((String)"t").longOpt("table").desc("Print types as Hive table declaration").build());
        options.addOption(Option.builder((String)"p").longOpt("pretty").desc("Pretty print the schema").build());
        CommandLine cli = new DefaultParser().parse(options, args);
        if (cli.hasOption('h') || cli.getArgs().length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("json-schema", options);
            System.exit(1);
        }
        return cli;
    }

    public static void main(String[] args) throws Exception {
        JsonSchemaFinder.main(new Configuration(), args);
    }
}

