/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;

public class RowCount {
    public static void main(Configuration conf, String[] args) throws IOException {
        int bad = 0;
        for (String root : args) {
            Path rootPath = new Path(root);
            FileSystem fs = rootPath.getFileSystem(conf);
            RemoteIterator itr = fs.listFiles(rootPath, true);
            while (itr.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)itr.next();
                if (!status.isFile() || !status.getPath().getName().endsWith(".orc")) continue;
                Path filename = status.getPath();
                try {
                    Reader reader = OrcFile.createReader((Path)filename, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                    Throwable throwable = null;
                    try {
                        System.out.println(String.format("%s %d", filename.toString(), reader.getNumberOfRows()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    ++bad;
                    System.err.println("Failed to read " + filename);
                }
            }
        }
        System.exit(bad == 0 ? 0 : 1);
    }

    public static void main(String[] args) throws IOException {
        RowCount.main(new Configuration(), args);
    }
}

