/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.tools.ColumnSizes;
import org.apache.orc.tools.FileDump;
import org.apache.orc.tools.KeyTool;
import org.apache.orc.tools.PrintData;
import org.apache.orc.tools.PrintVersion;
import org.apache.orc.tools.RowCount;
import org.apache.orc.tools.ScanData;
import org.apache.orc.tools.convert.ConvertTool;
import org.apache.orc.tools.json.JsonSchemaFinder;

public class Driver {
    static Options createOptions() {
        Options result = new Options();
        result.addOption(Option.builder((String)"h").longOpt("help").desc("Print help message").build());
        result.addOption(Option.builder((String)"D").longOpt("define").desc("Set a configuration property").numberOfArgs(2).valueSeparator().build());
        return result;
    }

    public static void main(String[] args) throws Exception {
        DriverOptions options = new DriverOptions(args);
        if (options.command == null) {
            System.err.println("ORC Java Tools");
            System.err.println();
            System.err.println("usage: java -jar orc-tools-*.jar [--help] [--define X=Y] <command> <args>");
            System.err.println();
            System.err.println("Commands:");
            System.err.println("   convert - convert CSV and JSON files to ORC");
            System.err.println("   count - recursively find *.orc and print the number of rows");
            System.err.println("   data - print the data from the ORC file");
            System.err.println("   json-schema - scan JSON files to determine their schema");
            System.err.println("   key - print information about the keys");
            System.err.println("   meta - print the metadata about the ORC file");
            System.err.println("   scan - scan the ORC file");
            System.err.println("   sizes - list size on disk of each column");
            System.err.println("   version - print the version of this ORC tool");
            System.err.println();
            System.err.println("To get more help, provide -h to the command");
            System.exit(1);
        }
        Configuration conf = new Configuration();
        Properties confSettings = options.genericOptions.getOptionProperties("D");
        for (Map.Entry<Object, Object> pair : confSettings.entrySet()) {
            conf.set(pair.getKey().toString(), pair.getValue().toString());
        }
        switch (options.command) {
            case "convert": {
                ConvertTool.main(conf, options.commandArgs);
                break;
            }
            case "count": {
                RowCount.main(conf, options.commandArgs);
                break;
            }
            case "data": {
                PrintData.main(conf, options.commandArgs);
                break;
            }
            case "json-schema": {
                JsonSchemaFinder.main(conf, options.commandArgs);
                break;
            }
            case "key": {
                KeyTool.main(conf, options.commandArgs);
                break;
            }
            case "meta": {
                FileDump.main(conf, options.commandArgs);
                break;
            }
            case "scan": {
                ScanData.main(conf, options.commandArgs);
                break;
            }
            case "sizes": {
                ColumnSizes.main(conf, options.commandArgs);
                break;
            }
            case "version": {
                PrintVersion.main(conf, options.commandArgs);
                break;
            }
            default: {
                System.err.println("Unknown subcommand: " + options.command);
                System.exit(1);
            }
        }
    }

    static class DriverOptions {
        final CommandLine genericOptions;
        final String command;
        final String[] commandArgs;

        DriverOptions(String[] args) throws ParseException {
            this.genericOptions = new DefaultParser().parse(Driver.createOptions(), args, true);
            String[] unprocessed = this.genericOptions.getArgs();
            if (unprocessed.length == 0) {
                this.command = null;
                this.commandArgs = new String[0];
            } else {
                this.command = unprocessed[0];
                if (this.genericOptions.hasOption('h')) {
                    this.commandArgs = new String[]{"-h"};
                } else {
                    this.commandArgs = new String[unprocessed.length - 1];
                    System.arraycopy(unprocessed, 1, this.commandArgs, 0, this.commandArgs.length);
                }
            }
        }
    }
}

