/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;

public class ColumnSizes {
    final Configuration conf;
    final TypeDescription schema;
    final long[] columnSizes;
    int goodFiles = 0;
    long rows = 0L;
    long padding = 0L;
    long totalSize = 0L;
    long stripeFooterSize = 0L;
    long fileFooterSize = 0L;
    long stripeIndex = 0L;
    long stripeData = 0L;

    public ColumnSizes(Configuration conf, LocatedFileStatus file) throws IOException {
        this.conf = conf;
        try (Reader reader = OrcFile.createReader((Path)file.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));){
            this.schema = reader.getSchema();
            this.columnSizes = new long[this.schema.getMaximumId() + 1];
            this.addReader(file, reader);
        }
    }

    private void checkStripes(LocatedFileStatus file, Reader reader) {
        long offset = "ORC".length();
        this.fileFooterSize += offset;
        for (StripeInformation stripe : reader.getStripes()) {
            this.padding += stripe.getOffset() - offset;
            this.stripeIndex += stripe.getIndexLength();
            this.stripeData += stripe.getDataLength();
            this.stripeFooterSize += stripe.getFooterLength();
            offset = stripe.getOffset() + stripe.getLength();
        }
        this.fileFooterSize += file.getLen() - offset;
    }

    private boolean addReader(LocatedFileStatus file, Reader reader) {
        TypeDescription newSchema = reader.getSchema();
        if (this.schema.equals((Object)newSchema)) {
            ++this.goodFiles;
            this.rows += reader.getNumberOfRows();
            this.totalSize += file.getLen();
            this.checkStripes(file, reader);
            ColumnStatistics[] colStats = reader.getStatistics();
            for (int c = 0; c < colStats.length && c < this.columnSizes.length; ++c) {
                int n = c;
                this.columnSizes[n] = this.columnSizes[n] + colStats[c].getBytesOnDisk();
                this.stripeData -= colStats[c].getBytesOnDisk();
            }
        } else {
            System.err.println("Ignoring " + file.getPath() + " because of schema mismatch: " + newSchema);
            return false;
        }
        return true;
    }

    public boolean addFile(LocatedFileStatus file) throws IOException {
        try (Reader reader = OrcFile.createReader((Path)file.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));){
            boolean bl = this.addReader(file, reader);
            return bl;
        }
    }

    private void printResults(PrintStream out) {
        ArrayList<StringLongPair> sizes = new ArrayList<StringLongPair>(this.columnSizes.length + 5);
        for (int column = 0; column < this.columnSizes.length; ++column) {
            if (this.columnSizes[column] <= 0L) continue;
            sizes.add(new StringLongPair(this.schema.findSubtype(column).getFullFieldName(), this.columnSizes[column]));
        }
        if (this.padding > 0L) {
            sizes.add(new StringLongPair("_padding", this.padding));
        }
        if (this.stripeFooterSize > 0L) {
            sizes.add(new StringLongPair("_stripe_footer", this.stripeFooterSize));
        }
        if (this.fileFooterSize > 0L) {
            sizes.add(new StringLongPair("_file_footer", this.fileFooterSize));
        }
        if (this.stripeIndex > 0L) {
            sizes.add(new StringLongPair("_index", this.stripeIndex));
        }
        if (this.stripeData > 0L) {
            sizes.add(new StringLongPair("_data", this.stripeData));
        }
        sizes.sort((x, y) -> x.size != y.size ? Long.compare(y.size, x.size) : x.name.compareTo(y.name));
        out.println("Percent  Bytes/Row  Name");
        for (StringLongPair item : sizes) {
            out.println(String.format("  %-5.2f  %-9.2f  %s", 100.0 * (double)item.size / (double)this.totalSize, (double)item.size / (double)this.rows, item.name));
        }
    }

    public static void main(Configuration conf, String[] args) throws IOException {
        ColumnSizes result = null;
        int badFiles = 0;
        for (String root : args) {
            Path rootPath = new Path(root);
            FileSystem fs = rootPath.getFileSystem(conf);
            RemoteIterator itr = fs.listFiles(rootPath, true);
            while (itr.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)itr.next();
                if (!status.isFile() || !status.getPath().getName().endsWith(".orc")) continue;
                try {
                    if (result == null) {
                        result = new ColumnSizes(conf, status);
                        continue;
                    }
                    if (result.addFile(status)) continue;
                    ++badFiles;
                }
                catch (IOException err) {
                    ++badFiles;
                    System.err.println("Failed to read " + status.getPath());
                }
            }
        }
        if (result == null) {
            System.err.println("No files found");
        } else {
            super.printResults(System.out);
        }
        if (badFiles > 0) {
            System.err.println(badFiles + " bad ORC files found.");
            System.exit(1);
        }
    }

    public static void main(String[] args) throws IOException {
        ColumnSizes.main(new Configuration(), args);
    }

    private static class StringLongPair {
        final String name;
        final long size;

        StringLongPair(String name, long size) {
            this.name = name;
            this.size = size;
        }
    }
}

