/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hive.streaming.AbstractStreamingTransaction;
import org.apache.hive.streaming.HiveStreamingConnection;
import org.apache.hive.streaming.StreamingException;
import org.apache.hive.streaming.TransactionError;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBatch
extends AbstractStreamingTransaction {
    private static final Logger LOG = LoggerFactory.getLogger((String)TransactionBatch.class.getName());
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 60000;
    protected Set<String> createdPartitions = null;
    private String username;
    private HiveStreamingConnection conn;
    private ScheduledExecutorService scheduledExecutorService;
    private String partNameForLock = null;
    private LockRequest lockRequest = null;
    private final ReentrantLock transactionLock = new ReentrantLock();
    private final AtomicLong minTxnId;
    private final long maxTxnId;
    private String agentInfo;
    private int numTxns;
    private final long tableId;
    private HiveStreamingConnection.TxnState[] txnStatus;
    private long lastTxnUsed;

    public TransactionBatch(HiveStreamingConnection conn) throws StreamingException {
        boolean success = false;
        try {
            if (conn.isPartitionedTable() && !conn.isDynamicPartitioning()) {
                List partKeys = conn.getTable().getPartitionKeys();
                this.partNameForLock = Warehouse.makePartName((List)partKeys, conn.getStaticPartitionValues());
            }
            this.conn = conn;
            this.username = conn.getUsername();
            this.recordWriter = conn.getRecordWriter();
            this.agentInfo = conn.getAgentInfo();
            this.numTxns = conn.getTransactionBatchSize();
            this.tableId = conn.getTable().getTTable().getId();
            List<Long> txnIds = this.openTxnImpl(this.username, this.numTxns);
            this.txnToWriteIds = this.allocateWriteIdsImpl(txnIds);
            assert (this.txnToWriteIds.size() == this.numTxns);
            this.txnStatus = new HiveStreamingConnection.TxnState[this.numTxns];
            for (int i = 0; i < this.txnStatus.length; ++i) {
                assert (((TxnToWriteId)this.txnToWriteIds.get(i)).getTxnId() == txnIds.get(i).longValue());
                this.txnStatus[i] = HiveStreamingConnection.TxnState.OPEN;
            }
            this.state = HiveStreamingConnection.TxnState.INACTIVE;
            this.recordWriter.init(conn, ((TxnToWriteId)this.txnToWriteIds.get(0)).getWriteId(), ((TxnToWriteId)this.txnToWriteIds.get(this.numTxns - 1)).getWriteId(), conn.getStatementId());
            this.minTxnId = new AtomicLong(txnIds.get(0));
            this.maxTxnId = txnIds.get(txnIds.size() - 1);
            this.setupHeartBeatThread();
            success = true;
        }
        catch (TException e) {
            throw new StreamingException(conn.toString(), e);
        }
        finally {
            this.markDead(success);
        }
    }

    private void setupHeartBeatThread() {
        long heartBeatInterval;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveStreamingConnection-Heartbeat-Thread").build();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        try {
            heartBeatInterval = DbTxnManager.getHeartbeatInterval((Configuration)this.conn.getConf());
        }
        catch (LockException e) {
            heartBeatInterval = 60000L;
        }
        long initialDelay = (long)((double)heartBeatInterval * 0.75 * Math.random());
        LOG.info("Starting heartbeat thread with interval: {} ms initialDelay: {} ms for agentInfo: {}", new Object[]{heartBeatInterval, initialDelay, this.conn.getAgentInfo()});
        HeartbeatRunnable runnable = new HeartbeatRunnable(this.conn, this.minTxnId, this.maxTxnId, this.transactionLock, this.isTxnClosed);
        this.scheduledExecutorService.scheduleWithFixedDelay(runnable, initialDelay, heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    private List<Long> openTxnImpl(String user, int numTxns) throws TException {
        return this.conn.getMSC().openTxns(user, numTxns).getTxn_ids();
    }

    private List<TxnToWriteId> allocateWriteIdsImpl(List<Long> txnIds) throws TException {
        return this.conn.getMSC().allocateTableWriteIdsBatch(txnIds, this.conn.getDatabase(), this.conn.getTable().getTableName());
    }

    public String toString() {
        if (this.txnToWriteIds == null || this.txnToWriteIds.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(" TxnStatus[");
        for (HiveStreamingConnection.TxnState state : this.txnStatus) {
            sb.append(state == null ? "N" : state);
        }
        sb.append("] LastUsed ").append(JavaUtils.txnIdToString((long)this.lastTxnUsed));
        return "TxnId/WriteIds=[" + ((TxnToWriteId)this.txnToWriteIds.get(0)).getTxnId() + "/" + ((TxnToWriteId)this.txnToWriteIds.get(0)).getWriteId() + "..." + ((TxnToWriteId)this.txnToWriteIds.get(this.txnToWriteIds.size() - 1)).getTxnId() + "/" + ((TxnToWriteId)this.txnToWriteIds.get(this.txnToWriteIds.size() - 1)).getWriteId() + "] on connection = " + this.conn + "; " + sb;
    }

    @Override
    public void beginNextTransaction() throws StreamingException {
        this.checkIsClosed();
        this.beginNextTransactionImpl();
    }

    private void beginNextTransactionImpl() throws StreamingException {
        this.beginNextTransactionImpl("No more transactions available in next batch for connection: " + this.conn + " user: " + this.username);
        this.lastTxnUsed = this.getCurrentTxnId();
        this.lockRequest = TransactionBatch.createLockRequest(this.conn, this.partNameForLock, this.username, this.getCurrentTxnId(), this.agentInfo);
        this.createdPartitions = Sets.newHashSet();
        try {
            LockResponse res = this.conn.getMSC().lock(this.lockRequest);
            if (res.getState() != LockState.ACQUIRED) {
                throw new TransactionError("Unable to acquire lock on " + this.conn);
            }
        }
        catch (TException e) {
            throw new TransactionError("Unable to acquire lock on " + this.conn, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Set<String> partitions, String key, String value) throws StreamingException {
        this.checkIsClosed();
        boolean success = false;
        try {
            this.commitImpl(partitions, key, value);
            success = true;
        }
        finally {
            this.markDead(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitImpl(Set<String> partitions, String key, String value) throws StreamingException {
        try {
            if (key == null && value != null || key != null && value == null) {
                throw new StreamingException(String.format("If key is set, the value should be as well and vice versa, key, value = %s, %s", key, value));
            }
            this.recordWriter.flush();
            TxnToWriteId txnToWriteId = (TxnToWriteId)this.txnToWriteIds.get(this.currentTxnIndex);
            if (this.conn.isDynamicPartitioning()) {
                ArrayList<String> partNames = new ArrayList<String>(this.recordWriter.getPartitions());
                this.createdPartitions.addAll(partNames);
                if (partitions != null) {
                    partNames.addAll(partitions);
                }
                if (!partNames.isEmpty()) {
                    this.conn.getMSC().addDynamicPartitions(txnToWriteId.getTxnId(), txnToWriteId.getWriteId(), this.conn.getDatabase(), this.conn.getTable().getTableName(), partNames, DataOperationType.INSERT);
                }
            }
            if (this.currentTxnIndex + 1 >= this.txnToWriteIds.size()) {
                this.recordWriter.close();
                this.conn.addWriteNotificationEvents();
            }
            this.transactionLock.lock();
            try {
                if (key != null) {
                    this.conn.getMSC().commitTxnWithKeyValue(txnToWriteId.getTxnId(), this.tableId, key, value);
                } else {
                    this.conn.getMSC().commitTxn(txnToWriteId.getTxnId());
                }
                if (this.currentTxnIndex + 1 < this.txnToWriteIds.size()) {
                    this.minTxnId.set(((TxnToWriteId)this.txnToWriteIds.get(this.currentTxnIndex + 1)).getTxnId());
                } else {
                    this.minTxnId.set(-1L);
                }
            }
            finally {
                this.transactionLock.unlock();
            }
            this.state = HiveStreamingConnection.TxnState.COMMITTED;
            this.txnStatus[this.currentTxnIndex] = HiveStreamingConnection.TxnState.COMMITTED;
        }
        catch (NoSuchTxnException e) {
            throw new TransactionError("Invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
        }
        catch (TxnAbortedException e) {
            throw new TransactionError("Aborted transaction cannot be committed", (Exception)((Object)e));
        }
        catch (TException e) {
            throw new TransactionError("Unable to commitTransaction transaction" + this.getCurrentTxnId(), (Exception)((Object)e));
        }
    }

    @Override
    public void abort() throws StreamingException {
        if (this.isTxnClosed.get()) {
            return;
        }
        this.abort(false);
    }

    private void abort(boolean abortAllRemaining) throws StreamingException {
        this.abortImpl(abortAllRemaining);
    }

    private void abortImpl(boolean abortAllRemaining) throws StreamingException {
        if (this.minTxnId == null) {
            return;
        }
        this.transactionLock.lock();
        try {
            if (abortAllRemaining) {
                int minOpenTxnIndex;
                this.minTxnId.set(-1L);
                this.currentTxnIndex = minOpenTxnIndex = Math.max(this.currentTxnIndex + (this.state == HiveStreamingConnection.TxnState.ABORTED || this.state == HiveStreamingConnection.TxnState.COMMITTED ? 1 : 0), 0);
                while (this.currentTxnIndex < this.txnToWriteIds.size()) {
                    AbortTxnRequest abortTxnRequest = new AbortTxnRequest(((TxnToWriteId)this.txnToWriteIds.get(this.currentTxnIndex)).getTxnId());
                    abortTxnRequest.setErrorCode(TxnErrorMsg.ABORT_ROLLBACK.getErrorCode());
                    this.conn.getMSC().rollbackTxn(abortTxnRequest);
                    this.txnStatus[this.currentTxnIndex] = HiveStreamingConnection.TxnState.ABORTED;
                    ++this.currentTxnIndex;
                }
                --this.currentTxnIndex;
            } else {
                if (this.currentTxnIndex + 1 < this.txnToWriteIds.size()) {
                    this.minTxnId.set(((TxnToWriteId)this.txnToWriteIds.get(this.currentTxnIndex + 1)).getTxnId());
                } else {
                    this.minTxnId.set(-1L);
                }
                long currTxnId = this.getCurrentTxnId();
                if (currTxnId > 0L) {
                    AbortTxnRequest abortTxnRequest = new AbortTxnRequest(currTxnId);
                    abortTxnRequest.setErrorCode(TxnErrorMsg.ABORT_ROLLBACK.getErrorCode());
                    this.conn.getMSC().rollbackTxn(abortTxnRequest);
                    this.txnStatus[this.currentTxnIndex] = HiveStreamingConnection.TxnState.ABORTED;
                }
            }
            this.state = HiveStreamingConnection.TxnState.ABORTED;
        }
        catch (NoSuchTxnException e) {
            throw new TransactionError("Unable to abort invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
        }
        catch (TException e) {
            throw new TransactionError("Unable to abort transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
        }
        finally {
            this.transactionLock.unlock();
        }
    }

    @Override
    public void close() throws StreamingException {
        if (this.isClosed()) {
            return;
        }
        this.isTxnClosed.set(true);
        try {
            this.abort(true);
        }
        catch (Exception ex) {
            LOG.error("Fatal error on " + this.toString() + "; cause " + ex.getMessage(), (Throwable)ex);
            throw new StreamingException("Unable to abort", ex);
        }
        try {
            this.closeImpl();
        }
        catch (Exception ex) {
            LOG.error("Fatal error on " + this.toString() + "; cause " + ex.getMessage(), (Throwable)ex);
            throw new StreamingException("Unable to close", ex);
        }
    }

    private void closeImpl() throws StreamingException {
        this.state = HiveStreamingConnection.TxnState.INACTIVE;
        this.recordWriter.close();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    private static LockRequest createLockRequest(HiveStreamingConnection connection, String partNameForLock, String user, long txnId, String agentInfo) {
        LockRequestBuilder requestBuilder = new LockRequestBuilder(agentInfo);
        requestBuilder.setUser(user);
        requestBuilder.setTransactionId(txnId);
        LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setDbName(connection.getDatabase()).setTableName(connection.getTable().getTableName()).setSharedRead().setOperationType(DataOperationType.INSERT);
        if (connection.isDynamicPartitioning()) {
            lockCompBuilder.setIsDynamicPartitionWrite(true);
        }
        if (partNameForLock != null && !partNameForLock.isEmpty()) {
            lockCompBuilder.setPartitionName(partNameForLock);
        }
        requestBuilder.addLockComponent(lockCompBuilder.build());
        return requestBuilder.build();
    }

    @Override
    public Set<String> getPartitions() {
        return this.createdPartitions;
    }

    private static class HeartbeatRunnable
    implements Runnable {
        private final HiveStreamingConnection conn;
        private final AtomicLong minTxnId;
        private final long maxTxnId;
        private final ReentrantLock transactionLock;
        private final AtomicBoolean isTxnClosed;

        HeartbeatRunnable(HiveStreamingConnection conn, AtomicLong minTxnId, long maxTxnId, ReentrantLock transactionLock, AtomicBoolean isTxnClosed) {
            this.conn = conn;
            this.minTxnId = minTxnId;
            this.maxTxnId = maxTxnId;
            this.transactionLock = transactionLock;
            this.isTxnClosed = isTxnClosed;
        }

        @Override
        public void run() {
            this.transactionLock.lock();
            try {
                if (this.minTxnId.get() > 0L) {
                    HeartbeatTxnRangeResponse resp = this.conn.getHeatbeatMSC().heartbeatTxnRange(this.minTxnId.get(), this.maxTxnId);
                    if (!resp.getAborted().isEmpty() || !resp.getNosuch().isEmpty()) {
                        LOG.error("Heartbeat failure: {}", (Object)resp.toString());
                        this.isTxnClosed.set(true);
                    } else {
                        LOG.info("Heartbeat sent for range: [{}-{}]", (Object)this.minTxnId.get(), (Object)this.maxTxnId);
                    }
                }
            }
            catch (TException e) {
                LOG.warn("Failure to heartbeat for transaction range: [" + this.minTxnId.get() + "-" + this.maxTxnId + "]", (Throwable)e);
            }
            finally {
                this.transactionLock.unlock();
            }
        }
    }
}

