/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatTable {
    private static final Logger LOG = LoggerFactory.getLogger(HCatTable.class);
    public static final EnumSet<TableAttribute> DEFAULT_COMPARISON_ATTRIBUTES = EnumSet.of(TableAttribute.COLUMNS, new TableAttribute[]{TableAttribute.INPUT_FORMAT, TableAttribute.OUTPUT_FORMAT, TableAttribute.SERDE, TableAttribute.SERDE_PROPERTIES, TableAttribute.STORAGE_HANDLER, TableAttribute.TABLE_PROPERTIES});
    public static final EnumSet<TableAttribute> NO_DIFF = EnumSet.noneOf(TableAttribute.class);
    public static final String DEFAULT_SERDE_CLASS = LazySimpleSerDe.class.getName();
    public static final String DEFAULT_INPUT_FORMAT_CLASS = TextInputFormat.class.getName();
    public static final String DEFAULT_OUTPUT_FORMAT_CLASS = HiveIgnoreKeyTextOutputFormat.class.getName();
    private String dbName = "default";
    private String tableName;
    private HiveConf conf;
    private String tableType;
    private boolean isExternal;
    private List<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
    private List<HCatFieldSchema> partCols = new ArrayList<HCatFieldSchema>();
    private StorageDescriptor sd;
    private String fileFormat;
    private Map<String, String> tblProps = new HashMap<String, String>();
    private String comment = "";
    private String owner;

    public HCatTable(String dbName, String tableName) {
        this.dbName = StringUtils.isBlank((CharSequence)dbName) ? "default" : dbName;
        this.tableName = tableName;
        this.sd = new StorageDescriptor();
        this.sd.setInputFormat(DEFAULT_INPUT_FORMAT_CLASS);
        this.sd.setOutputFormat(DEFAULT_OUTPUT_FORMAT_CLASS);
        this.sd.setSerdeInfo(new SerDeInfo());
        this.sd.getSerdeInfo().setSerializationLib(DEFAULT_SERDE_CLASS);
        this.sd.getSerdeInfo().setParameters(new HashMap());
        this.sd.getSerdeInfo().getParameters().put("serialization.format", "1");
    }

    HCatTable(Table hiveTable) throws HCatException {
        this.tableName = hiveTable.getTableName();
        this.dbName = hiveTable.getDbName();
        this.tableType = hiveTable.getTableType();
        this.isExternal = hiveTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString());
        this.sd = hiveTable.getSd();
        for (FieldSchema colFS : this.sd.getCols()) {
            this.cols.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)colFS));
        }
        this.partCols = new ArrayList<HCatFieldSchema>();
        for (FieldSchema colFS : hiveTable.getPartitionKeys()) {
            this.partCols.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)colFS));
        }
        if (hiveTable.getParameters() != null) {
            this.tblProps.putAll(hiveTable.getParameters());
        }
        if (StringUtils.isNotBlank((CharSequence)this.tblProps.get("comment"))) {
            this.comment = this.tblProps.get("comment");
        }
        this.owner = hiveTable.getOwner();
    }

    Table toHiveTable() throws HCatException {
        Table newTable = new Table();
        newTable.setDbName(this.dbName);
        newTable.setTableName(this.tableName);
        if (this.tblProps != null) {
            newTable.setParameters(this.tblProps);
        }
        if (this.isExternal) {
            newTable.putToParameters("EXTERNAL", "TRUE");
            newTable.setTableType(TableType.EXTERNAL_TABLE.toString());
        } else {
            newTable.setTableType(TableType.MANAGED_TABLE.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            newTable.putToParameters("comment", this.comment);
        }
        if (newTable.getParameters().get("bucketing_version") == null) {
            newTable.putToParameters("bucketing_version", "2");
        }
        newTable.setSd(this.sd);
        if (this.partCols != null) {
            ArrayList<FieldSchema> hivePtnCols = new ArrayList<FieldSchema>();
            for (HCatFieldSchema fs : this.partCols) {
                hivePtnCols.add(HCatSchemaUtils.getFieldSchema((HCatFieldSchema)fs));
            }
            newTable.setPartitionKeys(hivePtnCols);
        }
        newTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        newTable.setLastAccessTimeIsSet(false);
        try {
            newTable.setOwner(this.owner == null ? this.getConf().getUser() : this.owner);
        }
        catch (Exception exception) {
            throw new HCatException("Unable to determine owner of table (" + this.dbName + "." + this.tableName + ") from HiveConf.");
        }
        return newTable;
    }

    void setConf(Configuration conf) {
        this.conf = conf instanceof HiveConf ? (HiveConf)conf : new HiveConf(conf, this.getClass());
    }

    HiveConf getConf() {
        if (this.conf == null) {
            LOG.warn("Conf hasn't been set yet. Using defaults.");
            this.conf = new HiveConf();
        }
        return this.conf;
    }

    StorageDescriptor getSd() {
        return this.sd;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HCatTable tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public HCatTable dbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public List<HCatFieldSchema> getCols() {
        return this.cols;
    }

    public HCatTable cols(List<HCatFieldSchema> cols) {
        if (!this.cols.equals(cols)) {
            this.cols.clear();
            this.cols.addAll(cols);
            this.sd.setCols(HCatSchemaUtils.getFieldSchemas(cols));
        }
        return this;
    }

    public List<HCatFieldSchema> getPartCols() {
        return this.partCols;
    }

    public HCatTable partCols(List<HCatFieldSchema> partCols) {
        this.partCols = partCols;
        return this;
    }

    public HCatTable partCol(HCatFieldSchema partCol) {
        if (this.partCols == null) {
            this.partCols = new ArrayList<HCatFieldSchema>();
        }
        this.partCols.add(partCol);
        return this;
    }

    public List<String> getBucketCols() {
        return this.sd.getBucketCols();
    }

    public HCatTable bucketCols(List<String> bucketCols) {
        this.sd.setBucketCols(bucketCols);
        return this;
    }

    public List<Order> getSortCols() {
        return this.sd.getSortCols();
    }

    public HCatTable sortCols(List<Order> sortCols) {
        this.sd.setSortCols(sortCols);
        return this;
    }

    public int getNumBuckets() {
        return this.sd.getNumBuckets();
    }

    public HCatTable numBuckets(int numBuckets) {
        this.sd.setNumBuckets(numBuckets);
        return this;
    }

    public String getStorageHandler() {
        return this.tblProps.get("storage_handler");
    }

    public HCatTable storageHandler(String storageHandler) throws HCatException {
        this.tblProps.put("storage_handler", storageHandler);
        LOG.warn("HiveStorageHandlers can't be reliably instantiated on the client-side. Attempting to derive Input/OutputFormat settings from StorageHandler, on best effort: ");
        try {
            HiveStorageHandler sh = HiveUtils.getStorageHandler((Configuration)this.getConf(), (String)storageHandler);
            this.sd.setInputFormat(sh.getInputFormatClass().getName());
            this.sd.setOutputFormat(sh.getOutputFormatClass().getName());
            this.sd.getSerdeInfo().setSerializationLib(sh.getSerDeClass().getName());
        }
        catch (HiveException e) {
            LOG.warn("Could not derive Input/OutputFormat and SerDe settings from storageHandler. These values need to be set explicitly.", (Throwable)e);
        }
        return this;
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public HCatTable tblProps(Map<String, String> tblProps) {
        if (!this.tblProps.equals(tblProps)) {
            this.tblProps.clear();
            this.tblProps.putAll(tblProps);
        }
        return this;
    }

    public String getTabletype() {
        return this.tableType;
    }

    public HCatTable tableType(Type tableType) {
        this.tableType = tableType.name();
        this.isExternal = tableType.equals((Object)Type.EXTERNAL_TABLE);
        return this;
    }

    private SerDeInfo getSerDeInfo() {
        if (!this.sd.isSetSerdeInfo()) {
            this.sd.setSerdeInfo(new SerDeInfo());
        }
        return this.sd.getSerdeInfo();
    }

    public HCatTable fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        if (fileFormat.equalsIgnoreCase("sequencefile")) {
            this.inputFileFormat(SequenceFileInputFormat.class.getName());
            this.outputFileFormat(HiveSequenceFileOutputFormat.class.getName());
            this.serdeLib(LazySimpleSerDe.class.getName());
        } else if (fileFormat.equalsIgnoreCase("rcfile")) {
            this.inputFileFormat(RCFileInputFormat.class.getName());
            this.outputFileFormat(RCFileOutputFormat.class.getName());
            this.serdeLib(LazyBinaryColumnarSerDe.class.getName());
        } else if (fileFormat.equalsIgnoreCase("orcfile")) {
            this.inputFileFormat(OrcInputFormat.class.getName());
            this.outputFileFormat(OrcOutputFormat.class.getName());
            this.serdeLib(OrcSerde.class.getName());
        }
        return this;
    }

    public String fileFormat() {
        return this.fileFormat;
    }

    public String getInputFileFormat() {
        return this.sd.getInputFormat();
    }

    public HCatTable inputFileFormat(String inputFileFormat) {
        this.sd.setInputFormat(inputFileFormat);
        return this;
    }

    public String getOutputFileFormat() {
        return this.sd.getOutputFormat();
    }

    public HCatTable outputFileFormat(String outputFileFormat) {
        this.sd.setOutputFormat(outputFileFormat);
        return this;
    }

    public String getSerdeLib() {
        return this.getSerDeInfo().getSerializationLib();
    }

    public HCatTable serdeLib(String serde) {
        this.getSerDeInfo().setSerializationLib(serde);
        return this;
    }

    public HCatTable serdeParams(Map<String, String> serdeParams) {
        this.getSerDeInfo().setParameters(serdeParams);
        return this;
    }

    public HCatTable serdeParam(String paramName, String value) {
        SerDeInfo serdeInfo = this.getSerDeInfo();
        if (serdeInfo.getParameters() == null) {
            serdeInfo.setParameters(new HashMap());
        }
        serdeInfo.getParameters().put(paramName, value);
        return this;
    }

    public Map<String, String> getSerdeParams() {
        return this.getSerDeInfo().getParameters();
    }

    public String getLocation() {
        return this.sd.getLocation();
    }

    public HCatTable location(String location) {
        this.sd.setLocation(location);
        return this;
    }

    public String owner() {
        return this.owner;
    }

    public HCatTable owner(String owner) {
        this.owner = owner;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public HCatTable comment(String comment) {
        this.comment = comment;
        return this;
    }

    public HCatTable fieldsTerminatedBy(char delimiter) {
        return this.serdeParam("field.delim", Character.toString(delimiter));
    }

    public HCatTable escapeChar(char escapeChar) {
        return this.serdeParam("escape.delim", Character.toString(escapeChar));
    }

    public HCatTable collectionItemsTerminatedBy(char delimiter) {
        return this.serdeParam("collection.delim", Character.toString(delimiter));
    }

    public HCatTable mapKeysTerminatedBy(char delimiter) {
        return this.serdeParam("mapkey.delim", Character.toString(delimiter));
    }

    public HCatTable linesTerminatedBy(char delimiter) {
        return this.serdeParam("line.delim", Character.toString(delimiter));
    }

    public HCatTable nullDefinedAs(char nullChar) {
        return this.serdeParam("serialization.null.format", Character.toString(nullChar));
    }

    public String toString() {
        return "HCatTable [ tableName=" + this.tableName + ", dbName=" + this.dbName + ", tableType=" + this.tableType + ", cols=" + this.cols + ", partCols=" + this.partCols + ", bucketCols=" + this.getBucketCols() + ", numBuckets=" + this.getNumBuckets() + ", sortCols=" + this.getSortCols() + ", inputFormat=" + this.getInputFileFormat() + ", outputFormat=" + this.getOutputFileFormat() + ", storageHandler=" + this.getStorageHandler() + ", serde=" + this.getSerdeLib() + ", tblProps=" + this.getTblProps() + ", location=" + this.getLocation() + ", owner=" + this.owner() + " ]";
    }

    public EnumSet<TableAttribute> diff(HCatTable rhs, EnumSet<TableAttribute> attributesToCheck) {
        EnumSet<TableAttribute> theDiff = EnumSet.noneOf(TableAttribute.class);
        for (TableAttribute attribute : attributesToCheck) {
            if (!(!attribute.equals((Object)TableAttribute.COLUMNS) || rhs.getCols().containsAll(this.getCols()) && this.getCols().containsAll(rhs.getCols()))) {
                theDiff.add(TableAttribute.COLUMNS);
            }
            if (attribute.equals((Object)TableAttribute.INPUT_FORMAT) && (this.getInputFileFormat() == null && rhs.getInputFileFormat() != null || this.getInputFileFormat() != null && (rhs.getInputFileFormat() == null || !rhs.getInputFileFormat().equals(this.getInputFileFormat())))) {
                theDiff.add(TableAttribute.INPUT_FORMAT);
            }
            if (attribute.equals((Object)TableAttribute.OUTPUT_FORMAT) && (this.getOutputFileFormat() == null && rhs.getOutputFileFormat() != null || this.getOutputFileFormat() != null && (rhs.getOutputFileFormat() == null || !rhs.getOutputFileFormat().equals(this.getOutputFileFormat())))) {
                theDiff.add(TableAttribute.OUTPUT_FORMAT);
            }
            if (attribute.equals((Object)TableAttribute.STORAGE_HANDLER) && (this.getStorageHandler() == null && rhs.getStorageHandler() != null || this.getStorageHandler() != null && (rhs.getStorageHandler() == null || !rhs.getStorageHandler().equals(this.getStorageHandler())))) {
                theDiff.add(TableAttribute.STORAGE_HANDLER);
            }
            if (attribute.equals((Object)TableAttribute.SERDE) && (this.getSerdeLib() == null && rhs.getSerdeLib() != null || this.getSerdeLib() != null && (rhs.getSerdeLib() == null || !rhs.getSerdeLib().equals(this.getSerdeLib())))) {
                theDiff.add(TableAttribute.SERDE);
            }
            if (attribute.equals((Object)TableAttribute.SERDE_PROPERTIES) && !HCatTable.equivalent(this.sd.getSerdeInfo().getParameters(), rhs.sd.getSerdeInfo().getParameters())) {
                theDiff.add(TableAttribute.SERDE_PROPERTIES);
            }
            if (!attribute.equals((Object)TableAttribute.TABLE_PROPERTIES) || HCatTable.equivalent(this.tblProps, rhs.tblProps)) continue;
            theDiff.add(TableAttribute.TABLE_PROPERTIES);
        }
        return theDiff;
    }

    private static boolean equivalent(Map<String, String> lhs, Map<String, String> rhs) {
        return lhs.size() == rhs.size() && Maps.difference(lhs, rhs).areEqual();
    }

    public EnumSet<TableAttribute> diff(HCatTable rhs) {
        return this.diff(rhs, DEFAULT_COMPARISON_ATTRIBUTES);
    }

    public HCatTable resolve(HCatTable rhs, EnumSet<TableAttribute> attributes) throws HCatException {
        if (rhs == this) {
            return this;
        }
        for (TableAttribute attribute : attributes) {
            if (attribute.equals((Object)TableAttribute.COLUMNS)) {
                this.cols(rhs.cols);
            }
            if (attribute.equals((Object)TableAttribute.INPUT_FORMAT)) {
                this.inputFileFormat(rhs.getInputFileFormat());
            }
            if (attribute.equals((Object)TableAttribute.OUTPUT_FORMAT)) {
                this.outputFileFormat(rhs.getOutputFileFormat());
            }
            if (attribute.equals((Object)TableAttribute.SERDE)) {
                this.serdeLib(rhs.getSerdeLib());
            }
            if (attribute.equals((Object)TableAttribute.SERDE_PROPERTIES)) {
                this.serdeParams(rhs.getSerdeParams());
            }
            if (attribute.equals((Object)TableAttribute.STORAGE_HANDLER)) {
                this.storageHandler(rhs.getStorageHandler());
            }
            if (!attribute.equals((Object)TableAttribute.TABLE_PROPERTIES)) continue;
            this.tblProps(rhs.tblProps);
        }
        return this;
    }

    public static enum TableAttribute {
        COLUMNS,
        PARTITION_COLUMNS,
        INPUT_FORMAT,
        OUTPUT_FORMAT,
        SERDE,
        SERDE_PROPERTIES,
        STORAGE_HANDLER,
        LOCATION,
        TABLE_PROPERTIES,
        STATS;

    }

    public static enum Type {
        MANAGED_TABLE,
        EXTERNAL_TABLE,
        VIRTUAL_VIEW,
        INDEX_TABLE;

    }
}

