/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hive.jdbc.ClosedOrCancelledStatementException;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.TGetQueryIdReq;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStatement
implements Statement {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStatement.class);
    public static final String QUERY_CANCELLED_MESSAGE = "Query was cancelled.";
    private final HiveConnection connection;
    private TCLIService.Iface client;
    private Optional<TOperationHandle> stmtHandle;
    private final TSessionHandle sessHandle;
    Map<String, String> sessConf = new HashMap<String, String>();
    private int fetchSize;
    private final boolean isScrollableResultset;
    private boolean isOperationComplete = false;
    private boolean closeOnResultSetCompletion = false;
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private boolean isQueryClosed = false;
    private boolean isLogBeingGenerated = true;
    private int queryTimeout = 0;
    private Optional<InPlaceUpdateStream> inPlaceUpdateStream;

    public HiveStatement(HiveConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this(connection, client, sessHandle, false, connection.fetchSize);
    }

    public HiveStatement(HiveConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset, int fetchSize) {
        this.connection = Objects.requireNonNull(connection);
        this.client = Objects.requireNonNull(client);
        this.sessHandle = Objects.requireNonNull(sessHandle);
        this.fetchSize = fetchSize;
        if (this.fetchSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.isScrollableResultset = isScrollableResultset;
        this.inPlaceUpdateStream = Optional.empty();
        this.stmtHandle = Optional.empty();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.stmtHandle.isPresent()) {
                TCancelOperationReq cancelReq = new TCancelOperationReq(this.stmtHandle.get());
                TCancelOperationResp cancelResp = this.client.CancelOperation(cancelReq);
                Utils.verifySuccessWithInfo(cancelResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to cancel statement", "08S01", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    private void closeStatementIfNeeded() throws SQLException {
        try {
            TCloseOperationReq closeReq;
            TCloseOperationResp closeResp;
            if (this.stmtHandle.isPresent() && !this.checkInvalidOperationHandle(closeResp = this.client.CloseOperation(closeReq = new TCloseOperationReq(this.stmtHandle.get())))) {
                Utils.verifySuccessWithInfo(closeResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (TApplicationException tae) {
            String errorMsg = "Failed to close statement";
            if (tae.getType() == 4) {
                errorMsg = "Failed to close statement. Mismatch thrift sequence id. A previous call to the Thrift library failed and now position within the input stream is lost. Please enable verbose error logging and check the status of previous calls.";
            }
            throw new SQLException(errorMsg, "08S01", tae);
        }
        catch (Exception e) {
            throw new SQLException("Failed to close statement", "08S01", e);
        }
        finally {
            this.stmtHandle = Optional.empty();
        }
    }

    private boolean checkInvalidOperationHandle(TCloseOperationResp closeResp) {
        List messages = closeResp.getStatus().getInfoMessages();
        if (messages != null && messages.size() > 0) {
            String message = (String)messages.get(0);
            if (message.contains("Invalid OperationHandle")) {
                LOG.warn("'Invalid OperationHandle' on server side (messages: " + messages + ")");
                return true;
            }
            if (message.contains("Operation does not exist")) {
                LOG.warn("'Operation does not exist' on server side (messages: " + messages + ")");
                return true;
            }
        }
        return false;
    }

    void closeClientOperation() throws SQLException {
        try {
            this.closeStatementIfNeeded();
        }
        finally {
            this.isQueryClosed = true;
        }
    }

    void closeOnResultSetCompletion() throws SQLException {
        if (this.closeOnResultSetCompletion) {
            this.resultSet = null;
            this.close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        if (this.resultSet != null) {
            if (!this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = null;
        }
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnResultSetCompletion = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        TGetOperationStatusResp status = this.waitForOperationToComplete();
        if (!status.isHasResultSet() && this.stmtHandle.isPresent() && !this.stmtHandle.get().isHasResultSet()) {
            return false;
        }
        this.resultSet = new HiveQueryResultSet.Builder(this).setClient(this.client).setStmtHandle(this.stmtHandle.get()).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    public boolean executeAsync(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        TGetOperationStatusResp status = this.waitForResultSetStatus();
        if (!status.isHasResultSet()) {
            return false;
        }
        this.resultSet = new HiveQueryResultSet.Builder(this).setClient(this.client).setStmtHandle(this.stmtHandle.get()).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    private void runAsyncOnServer(String sql) throws SQLException {
        this.checkConnection("execute");
        this.reInitState();
        TExecuteStatementReq execReq = new TExecuteStatementReq(this.sessHandle, sql);
        execReq.setRunAsync(true);
        execReq.setConfOverlay(this.sessConf);
        execReq.setQueryTimeout((long)this.queryTimeout);
        try {
            LOG.debug("Submitting statement [{}]: {}", (Object)this.sessHandle, (Object)sql);
            TExecuteStatementResp execResp = this.client.ExecuteStatement(execReq);
            Utils.verifySuccessWithInfo(execResp.getStatus());
            List infoMessages = execResp.getStatus().getInfoMessages();
            if (infoMessages != null) {
                for (String message : infoMessages) {
                    LOG.info(message);
                }
            }
            this.stmtHandle = Optional.of(execResp.getOperationHandle());
            LOG.debug("Running with statement handle: {}", (Object)this.stmtHandle.get());
        }
        catch (SQLException eS) {
            this.isLogBeingGenerated = false;
            throw eS;
        }
        catch (Exception ex) {
            this.isLogBeingGenerated = false;
            throw new SQLException("Failed to run async statement", "08S01", ex);
        }
    }

    private TGetOperationStatusResp waitForResultSetStatus() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle.get());
        TGetOperationStatusResp statusResp = null;
        while (statusResp == null || !statusResp.isSetHasResultSet()) {
            try {
                statusResp = this.client.GetOperationStatus(statusReq);
            }
            catch (TException e) {
                this.isLogBeingGenerated = false;
                throw new SQLException("Failed to wait for result set status", "08S01", e);
            }
        }
        return statusResp;
    }

    TGetOperationStatusResp waitForOperationToComplete() throws SQLException {
        TGetOperationStatusResp statusResp = null;
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle.get());
        statusReq.setGetProgressUpdate(this.inPlaceUpdateStream.isPresent());
        if (this.inPlaceUpdateStream.isPresent()) {
            this.inPlaceUpdateStream.get().getEventNotifier().progressBarCompleted();
        }
        LOG.debug("Waiting on operation to complete: Polling operation status");
        do {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    throw new SQLException(ErrorMsg.CLIENT_POLLING_OPSTATUS_INTERRUPTED.getMsg(), ErrorMsg.CLIENT_POLLING_OPSTATUS_INTERRUPTED.getSQLState());
                }
                statusResp = this.client.GetOperationStatus(statusReq);
                LOG.debug("Status response: {}", (Object)statusResp);
                if (!this.isOperationComplete && this.inPlaceUpdateStream.isPresent()) {
                    this.inPlaceUpdateStream.get().update(statusResp.getProgressUpdateResponse());
                }
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case CLOSED_STATE: 
                    case FINISHED_STATE: {
                        this.isOperationComplete = true;
                        this.isLogBeingGenerated = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        String errMsg = statusResp.getErrorMessage();
                        String fullErrMsg = errMsg == null || errMsg.isEmpty() ? QUERY_CANCELLED_MESSAGE : "Query was cancelled. " + errMsg;
                        throw new SQLException(fullErrMsg, "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Query timed out after " + this.queryTimeout + " seconds");
                    }
                    case ERROR_STATE: {
                        throw new SQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new SQLException("Unknown query", "HY000");
                    }
                }
            }
            catch (SQLException e) {
                this.isLogBeingGenerated = false;
                throw e;
            }
            catch (Exception e) {
                this.isLogBeingGenerated = false;
                throw new SQLException("Failed to wait for operation to complete", "08S01", e);
            }
        } while (!this.isOperationComplete);
        if (this.inPlaceUpdateStream.isPresent()) {
            this.inPlaceUpdateStream.get().getEventNotifier().progressBarCompleted();
        }
        return statusResp;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot " + action + " after statement has been closed");
        }
    }

    private void reInitState() throws SQLException {
        try {
            this.closeStatementIfNeeded();
        }
        finally {
            this.isCancelled = false;
            this.isQueryClosed = false;
            this.isLogBeingGenerated = true;
            this.isOperationComplete = false;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("The query did not generate a result set");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkConnection("getUpdateCount");
        long numModifiedRows = -1L;
        TGetOperationStatusResp resp = this.waitForOperationToComplete();
        if (resp != null) {
            numModifiedRows = resp.getNumModifiedRows();
        }
        if (numModifiedRows == -1L || numModifiedRows > Integer.MAX_VALUE) {
            LOG.warn("Invalid number of updated rows: {}", (Object)numModifiedRows);
            return -1;
        }
        return (int)numModifiedRows;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isQueryClosed() throws SQLException {
        return this.isQueryClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnResultSetCompletion;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            throw new SQLFeatureNotSupportedException("Method not supported");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException("Not supported direction: " + direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows == 0) {
            this.fetchSize = this.connection.fetchSize;
        } else {
            throw new SQLException("Fetch size must be greater or equal to 0");
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new SQLException("Maximum number of rows must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    public boolean hasMoreLogs() {
        return this.isLogBeingGenerated;
    }

    public List<String> getQueryLog() throws SQLException, ClosedOrCancelledStatementException {
        return this.getQueryLog(true, this.fetchSize);
    }

    public List<String> getQueryLog(boolean incremental, int fetchSize) throws SQLException, ClosedOrCancelledStatementException {
        this.checkConnection("getQueryLog");
        if (this.isCancelled) {
            throw new ClosedOrCancelledStatementException("Method getQueryLog() failed. The statement has been closed or cancelled.");
        }
        TFetchResultsResp tFetchResultsResp = null;
        try {
            if (!this.stmtHandle.isPresent()) {
                if (this.isQueryClosed) {
                    throw new ClosedOrCancelledStatementException("Method getQueryLog() failed. The statement has been closed or cancelled.");
                }
                return Collections.emptyList();
            }
            TFetchResultsReq tFetchResultsReq = new TFetchResultsReq(this.stmtHandle.get(), this.getFetchOrientation(incremental), (long)fetchSize);
            tFetchResultsReq.setFetchType((short)1);
            tFetchResultsResp = this.client.FetchResults(tFetchResultsReq);
            Utils.verifySuccessWithInfo(tFetchResultsResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Error when getting query log", e);
        }
        ArrayList<String> logs = new ArrayList<String>();
        try {
            RowSet rowSet = RowSetFactory.create((TRowSet)tFetchResultsResp.getResults(), (TProtocolVersion)this.connection.getProtocol());
            for (Object[] row : rowSet) {
                logs.add(String.valueOf(row[0]));
            }
        }
        catch (TException e) {
            throw new SQLException("Error building result set for query log", e);
        }
        return Collections.unmodifiableList(logs);
    }

    private TFetchOrientation getFetchOrientation(boolean incremental) {
        return incremental ? TFetchOrientation.FETCH_NEXT : TFetchOrientation.FETCH_FIRST;
    }

    public String getYarnATSGuid() {
        return this.stmtHandle.isPresent() ? Base64.getUrlEncoder().withoutPadding().encodeToString(this.stmtHandle.get().getOperationId().getGuid()) : null;
    }

    public void setInPlaceUpdateStream(InPlaceUpdateStream stream) {
        this.inPlaceUpdateStream = Optional.ofNullable(stream);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive and closely related projects."})
    public String getQueryId() throws SQLException {
        TOperationHandle stmtHandleTmp = this.stmtHandle.orElse(null);
        if (stmtHandleTmp == null) {
            return null;
        }
        try {
            String queryId = this.client.GetQueryId(new TGetQueryIdReq(stmtHandleTmp)).getQueryId();
            return StringUtils.isBlank((CharSequence)queryId) ? null : queryId;
        }
        catch (TException e) {
            throw new SQLException(e);
        }
    }
}

