/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.io;

import java.nio.charset.Charset;
import org.ldaptive.io.AbstractBinaryValueTranscoder;

public class UnicodePwdValueTranscoder
extends AbstractBinaryValueTranscoder<String> {
    private static final Charset UTF_16LE = Charset.forName("UTF-16LE");

    @Override
    public String decodeBinaryValue(byte[] value) {
        String pwd = new String(value, UTF_16LE);
        if (pwd.length() < 2) {
            throw new IllegalArgumentException("unicodePwd must be at least 2 characters long");
        }
        return pwd.substring(1, pwd.length() - 1);
    }

    @Override
    public byte[] encodeBinaryValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode null value");
        }
        String pwd = String.format("\"%s\"", value);
        return pwd.getBytes(UTF_16LE);
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }
}

