/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

public class HashUtil {
    private static final int HASH_VAL_NULL = 1476925031;
    private static final byte[] HASH_VAL_NULL_BYTE_BUF = new byte[4];

    public static long fastHash64(byte[] buf, long seed) {
        long v;
        if (buf == null) {
            buf = HASH_VAL_NULL_BYTE_BUF;
        }
        int len = buf.length;
        long m3 = -8645972361240307355L;
        long h2 = seed ^ (long)len * -8645972361240307355L;
        int len8 = len / 8;
        for (int i = 0; i < len8; ++i) {
            int pos = i * 8;
            v = (long)buf[pos] + ((long)buf[pos + 1] << 8) + ((long)buf[pos + 2] << 16) + ((long)buf[pos + 3] << 24) + ((long)buf[pos + 4] << 32) + ((long)buf[pos + 5] << 40) + ((long)buf[pos + 6] << 48) + ((long)buf[pos + 7] << 56);
            h2 ^= HashUtil.fastHashMix(v);
            h2 *= -8645972361240307355L;
        }
        v = 0L;
        int pos2 = len8 * 8;
        switch (len & 7) {
            case 7: {
                v ^= (long)buf[pos2 + 6] << 48;
            }
            case 6: {
                v ^= (long)buf[pos2 + 5] << 40;
            }
            case 5: {
                v ^= (long)buf[pos2 + 4] << 32;
            }
            case 4: {
                v ^= (long)buf[pos2 + 3] << 24;
            }
            case 3: {
                v ^= (long)buf[pos2 + 2] << 16;
            }
            case 2: {
                v ^= (long)buf[pos2 + 1] << 8;
            }
            case 1: {
                h2 ^= HashUtil.fastHashMix(v ^= (long)buf[pos2]);
                h2 *= -8645972361240307355L;
            }
        }
        return HashUtil.fastHashMix(h2);
    }

    public static int fastHash32(byte[] buf, int seed) {
        long h2 = HashUtil.fastHash64(buf, seed);
        return (int)(h2 - (h2 >>> 32));
    }

    private static long fastHashMix(long h2) {
        h2 ^= h2 >>> 23;
        h2 *= 2388976653695081527L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    static {
        HashUtil.HASH_VAL_NULL_BYTE_BUF[0] = 103;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[1] = 22;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[2] = 8;
        HashUtil.HASH_VAL_NULL_BYTE_BUF[3] = 88;
    }
}

